/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.alfresco.jlan.server.filesys.DiskOfflineException;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.PathNotFoundException;
import org.alfresco.jlan.server.filesys.TooManyFilesException;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.UnsupportedInfoLevelException;
import org.alfresco.jlan.smb.dcerpc.DCEPipeType;
import org.alfresco.jlan.smb.dcerpc.server.DCEPipeFile;
import org.alfresco.jlan.smb.dcerpc.server.DCEPipeHandler;
import org.alfresco.jlan.smb.server.DCERPCHandler;
import org.alfresco.jlan.smb.server.NTParameterPacker;
import org.alfresco.jlan.smb.server.NamedPipeTransaction;
import org.alfresco.jlan.smb.server.PipeLanmanHandler;
import org.alfresco.jlan.smb.server.QueryInfoPacker;
import org.alfresco.jlan.smb.server.SMBSrvException;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.SMBSrvTransPacket;
import org.alfresco.jlan.smb.server.SrvTransactBuffer;
import org.alfresco.jlan.smb.server.VirtualCircuit;
import org.alfresco.jlan.util.DataBuffer;
import org.alfresco.jlan.util.DataPacker;

class IPCHandler {
    IPCHandler() {
    }

    public static void processIPCRequest(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ Request [" + smbPkt.getTreeId() + "] - cmd = " + smbPkt.getPacketTypeString());
        }
        switch (smbPkt.getCommand()) {
            case 2: 
            case 45: {
                IPCHandler.procIPCFileOpen(sess, smbPkt);
                break;
            }
            case 10: {
                IPCHandler.procIPCFileRead(sess, smbPkt);
                break;
            }
            case 46: {
                IPCHandler.procIPCFileReadAndX(sess, smbPkt);
                break;
            }
            case 11: {
                IPCHandler.procIPCFileWrite(sess, smbPkt);
                break;
            }
            case 47: {
                IPCHandler.procIPCFileWriteAndX(sess, smbPkt);
                break;
            }
            case 4: {
                IPCHandler.procIPCFileClose(sess, smbPkt);
                break;
            }
            case 162: {
                IPCHandler.procNTCreateAndX(sess, smbPkt);
                break;
            }
            default: {
                sess.sendErrorResponseSMB(smbPkt, 64, 2);
            }
        }
    }

    protected static void procTransaction(VirtualCircuit vc, SrvTransactBuffer tbuf, SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ Transaction  pipe=" + tbuf.getName() + ", subCmd=" + NamedPipeTransaction.getSubCommand(tbuf.getFunction()));
        }
        if (tbuf.getName().compareTo("\\PIPE\\LANMAN") == 0 && PipeLanmanHandler.processRequest(tbuf, sess, smbPkt)) {
            return;
        }
        switch (tbuf.getFunction()) {
            case 1: {
                IPCHandler.procSetNamedPipeHandleState(sess, vc, tbuf, smbPkt);
                break;
            }
            case 38: {
                DCERPCHandler.processDCERPCRequest(sess, vc, tbuf, smbPkt);
                break;
            }
            case 7: {
                IPCHandler.procTrans2QueryFile(sess, vc, tbuf, smbPkt);
                break;
            }
            case 83: {
                sess.sendErrorResponseSMB(smbPkt, -1073741637, 65535, 2);
                break;
            }
            default: {
                sess.sendErrorResponseSMB(smbPkt, 64, 2);
            }
        }
    }

    protected static void procIPCFileOpen(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        int pipeType;
        int dataPos = smbPkt.getByteOffset();
        int dataLen = smbPkt.getByteCount();
        byte[] buf = smbPkt.getBuffer();
        String fileName = DataPacker.getString(buf, dataPos, dataLen);
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ Open file = " + fileName);
        }
        if ((pipeType = DCEPipeType.getNameAsType(fileName)) == -1) {
            sess.sendErrorResponseSMB(smbPkt, 2, 1);
            return;
        }
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        DCEPipeFile pipeFile = new DCEPipeFile(pipeType);
        pipeFile.setGrantedAccess(2);
        int fid = -1;
        try {
            fid = conn.addFile(pipeFile, sess);
        }
        catch (TooManyFilesException ex) {
            sess.sendErrorResponseSMB(smbPkt, 4, 1);
            return;
        }
        smbPkt.setParameterCount(15);
        smbPkt.setAndXCommand(255);
        smbPkt.setParameter(1, 0);
        smbPkt.setParameter(2, fid);
        smbPkt.setParameter(3, 0);
        smbPkt.setParameter(4, 0);
        smbPkt.setParameter(5, 0);
        smbPkt.setParameterLong(6, 0);
        smbPkt.setParameter(8, 0);
        smbPkt.setParameter(9, 0);
        smbPkt.setParameter(10, 0);
        smbPkt.setParameter(11, 0);
        smbPkt.setParameter(12, 0);
        smbPkt.setParameter(13, 0);
        smbPkt.setParameter(14, 0);
        smbPkt.setByteCount(0);
        sess.sendResponseSMB(smbPkt);
    }

    protected static void procIPCFileRead(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(5, 0)) {
            sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ File Read");
        }
        DCERPCHandler.processDCERPCRead(sess, smbPkt);
    }

    protected static void procIPCFileReadAndX(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(10, 0)) {
            sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ File Read AndX");
        }
        DCERPCHandler.processDCERPCRead(sess, smbPkt);
    }

    protected static void procIPCFileWrite(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(5, 0)) {
            sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ File Write");
        }
        DCERPCHandler.processDCERPCRequest(sess, smbPkt);
    }

    protected static void procIPCFileWriteAndX(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(12, 0)) {
            sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ File Write AndX");
        }
        DCERPCHandler.processDCERPCRequest(sess, smbPkt);
    }

    protected static void procIPCFileClose(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!smbPkt.checkPacketIsValid(3, 0)) {
            sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        int fid = smbPkt.getParameter(0);
        DCEPipeFile netFile = (DCEPipeFile)conn.findFile(fid);
        if (netFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ File close [" + smbPkt.getTreeId() + "] fid=" + fid);
        }
        conn.removeFile(fid, sess);
        smbPkt.setParameterCount(0);
        smbPkt.setByteCount(0);
        sess.sendResponseSMB(smbPkt);
    }

    protected static void procSetNamedPipeHandleState(SMBSrvSession sess, VirtualCircuit vc, SrvTransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        setupBuf.skipBytes(2);
        int fid = setupBuf.getShort();
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int state = paramBuf.getShort();
        TreeConnection conn = vc.findConnection(tbuf.getTreeId());
        DCEPipeFile netFile = (DCEPipeFile)conn.findFile(fid);
        if (netFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("  SetNmPHandState pipe=" + netFile.getName() + ", fid=" + fid + ", state=0x" + Integer.toHexString(state));
        }
        netFile.setPipeState(state);
        SMBSrvTransPacket.initTransactReply(smbPkt, 0, 0, 0, 0);
        sess.sendResponseSMB(smbPkt);
    }

    protected static void procNTCreateAndX(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        int pipeType;
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, -1073741811, 6);
            return;
        }
        NTParameterPacker prms = new NTParameterPacker(smbPkt.getBuffer(), 42);
        int nameLen = prms.unpackWord();
        int flags = prms.unpackInt();
        int rootFID = prms.unpackInt();
        int accessMask = prms.unpackInt();
        long allocSize = prms.unpackLong();
        int attrib = prms.unpackInt();
        int shrAccess = prms.unpackInt();
        int createDisp = prms.unpackInt();
        int createOptn = prms.unpackInt();
        int impersonLev = prms.unpackInt();
        int secFlags = prms.unpackByte();
        int pos = DataPacker.wordAlign(smbPkt.getByteOffset());
        String fileName = DataPacker.getUnicodeString(smbPkt.getBuffer(), pos, nameLen);
        if (fileName == null) {
            sess.sendErrorResponseSMB(smbPkt, -1073741811, 6);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("NT Create AndX [" + smbPkt.getTreeId() + "] name=" + fileName + ", flags=0x" + Integer.toHexString(flags) + ", attr=0x" + Integer.toHexString(attrib) + ", allocSize=" + allocSize);
        }
        if (!fileName.startsWith("\\PIPE")) {
            fileName = "\\PIPE" + fileName;
        }
        if ((pipeType = DCEPipeType.getNameAsType(fileName)) == -1) {
            sess.sendErrorResponseSMB(smbPkt, -1073741772, 6);
            return;
        }
        if (DCEPipeHandler.getHandlerForType(pipeType) == null) {
            sess.sendErrorResponseSMB(smbPkt, -1073741790, 6);
            return;
        }
        DCEPipeFile pipeFile = new DCEPipeFile(pipeType);
        pipeFile.setGrantedAccess(2);
        int fid = -1;
        try {
            fid = conn.addFile(pipeFile, sess);
        }
        catch (TooManyFilesException ex) {
            sess.sendErrorResponseSMB(smbPkt, 6, 6);
            return;
        }
        boolean extendedResponse = (flags & 0x10) != 0;
        smbPkt.setParameterCount(extendedResponse ? 42 : 34);
        prms.reset(smbPkt.getBuffer(), 41);
        prms.packByte(0);
        prms.packWord(fid);
        prms.packInt(1);
        prms.packLong(0L);
        prms.packLong(0L);
        prms.packLong(0L);
        prms.packLong(0L);
        prms.packInt(128);
        prms.packLong(0L);
        prms.packLong(0L);
        prms.packWord(2);
        prms.packByte(255);
        prms.packByte(5);
        prms.packByte(0);
        prms.packWord(0);
        if (extendedResponse) {
            prms.packLong(0L);
            prms.packLong(0L);
            prms.packInt(0);
            prms.packWord(0);
            prms.packInt(0x1F01FF);
            prms.packInt(1180059);
            prms.packInt(0);
        }
        int endPos = prms.getPosition();
        smbPkt.setParameter(1, endPos - 4);
        smbPkt.setLongErrorCode(0);
        sess.sendResponseSMB(smbPkt, endPos - 4);
    }

    protected static final void procTrans2QueryFile(SMBSrvSession sess, VirtualCircuit vc, SrvTransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ Query File - level=0x" + Integer.toHexString(infoLevl) + ", fid=" + fid + ", name=" + netFile.getFullName());
        }
        try {
            smbPkt.setParameterCount(10);
            byte[] buf = smbPkt.getBuffer();
            int prmPos = DataPacker.longwordAlign(smbPkt.getByteOffset());
            int dataPos = prmPos + 4;
            smbPkt.setPosition(prmPos);
            smbPkt.packWord(0);
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            FileInfo fileInfo = new FileInfo(netFile.getName(), netFile.getFileSize(), netFile.getFileAttributes());
            fileInfo.setAccessDateTime(netFile.getAccessDate());
            fileInfo.setCreationDateTime(netFile.getCreationDate());
            fileInfo.setModifyDateTime(netFile.getModifyDate());
            fileInfo.setChangeDateTime(netFile.getModifyDate());
            fileInfo.setFileId(netFile.getFileId());
            fileInfo.setAllocationSize(4096L);
            int dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            if (dataLen == 0) {
                sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            SMBSrvTransPacket.initTransactReply(smbPkt, 2, prmPos, dataLen, dataPos);
            smbPkt.setByteCount(replyBuf.getPosition() - smbPkt.getByteOffset());
            sess.sendResponseSMB(smbPkt);
        }
        catch (FileNotFoundException ex) {
            sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        catch (PathNotFoundException ex) {
            sess.sendErrorResponseSMB(smbPkt, -1073741766, 2, 1);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        catch (DiskOfflineException ex) {
            sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
    }
}

