/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.util.HashMap;
import java.util.Iterator;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.core.NoPooledMemoryException;
import org.alfresco.jlan.server.memory.ByteBufferPool;
import org.alfresco.jlan.server.thread.ThreadRequestPool;
import org.alfresco.jlan.server.thread.TimedThreadRequest;
import org.alfresco.jlan.smb.server.SMBSrvPacket;

public class CIFSPacketPool {
    public static final long CIFSAllocateWaitTime = 250L;
    public static final long CIFSLeaseTime = 5000L;
    public static final long CIFSLeaseTimeSecs = 5L;
    private ByteBufferPool m_bufferPool;
    private ThreadRequestPool m_threadPool;
    private HashMap<SMBSrvPacket, SMBSrvPacket> m_leasedPkts = new HashMap();
    private boolean m_debug;
    private boolean m_allocDebug;
    private boolean m_allowOverSize = true;
    private int m_maxOverSize = 131072;
    private int m_maxPoolBufSize;

    public CIFSPacketPool(ByteBufferPool bufPool, ThreadRequestPool threadPool) {
        this.m_bufferPool = bufPool;
        this.m_threadPool = threadPool;
        this.m_maxPoolBufSize = this.m_bufferPool.getLargestSize();
        this.m_threadPool.queueTimedRequest(new CIFSLeaseExpiryTimedRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SMBSrvPacket allocatePacket(int reqSiz) throws NoPooledMemoryException {
        byte[] buf = null;
        boolean overSize = false;
        if (reqSiz <= this.m_maxPoolBufSize) {
            buf = this.m_bufferPool.allocateBuffer(reqSiz, 250L);
        } else if (this.allowsOverSizedAllocations() && reqSiz <= this.getMaximumOverSizedAllocation()) {
            if (this.hasAllocateDebug()) {
                Debug.println("[SMB] Allocating an over-sized packet, reqSiz=" + reqSiz);
            }
            buf = new byte[reqSiz];
            overSize = true;
        }
        if (buf == null) {
            if (this.hasDebug()) {
                Debug.println("[SMB] CIFS Packet allocate failed, reqSiz=" + reqSiz);
            }
            throw new NoPooledMemoryException("Request size " + reqSiz);
        }
        SMBSrvPacket packet = new SMBSrvPacket(buf);
        if (!overSize) {
            HashMap<SMBSrvPacket, SMBSrvPacket> hashMap = this.m_leasedPkts;
            synchronized (hashMap) {
                packet.setLeaseTime(System.currentTimeMillis() + 5000L);
                this.m_leasedPkts.put(packet, packet);
            }
        }
        return packet;
    }

    public final SMBSrvPacket allocatePacket(int reqSiz, SMBSrvPacket reqPkt) throws NoPooledMemoryException {
        return this.allocatePacket(reqSiz, reqPkt, -1);
    }

    public final SMBSrvPacket allocatePacket(int reqSiz, SMBSrvPacket reqPkt, int copyLen) throws NoPooledMemoryException {
        SMBSrvPacket respPkt = this.allocatePacket(reqSiz);
        System.arraycopy(reqPkt.getBuffer(), 4, respPkt.getBuffer(), 4, copyLen == -1 ? 33 : copyLen);
        reqPkt.setAssociatedPacket(respPkt);
        if (!reqPkt.hasLeaseTime() && respPkt.hasLeaseTime()) {
            reqPkt.setLeaseTime(respPkt.getLeaseTime());
        }
        if (this.hasAllocateDebug()) {
            Debug.println("[SMB]  Associated packet reqSiz=" + reqSiz + " with pktSiz=" + reqPkt.getBuffer().length);
        }
        return respPkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releasePacket(SMBSrvPacket smbPkt) {
        if (smbPkt.hasLeaseTime()) {
            if (this.hasDebug() && smbPkt.getLeaseTime() < System.currentTimeMillis()) {
                Debug.println("[SMB] Release expired packet: pkt=" + smbPkt);
            }
            HashMap<SMBSrvPacket, SMBSrvPacket> hashMap = this.m_leasedPkts;
            synchronized (hashMap) {
                smbPkt.clearLeaseTime();
                this.m_leasedPkts.remove(smbPkt);
            }
        }
        if (smbPkt.getBuffer().length <= this.m_maxPoolBufSize) {
            this.m_bufferPool.releaseBuffer(smbPkt.getBuffer());
            if (this.hasAllocateDebug() && !smbPkt.hasAssociatedPacket()) {
                Debug.println("[SMB] CIFS Packet released bufSiz=" + smbPkt.getBuffer().length);
            }
        } else if (this.hasAllocateDebug()) {
            Debug.println("[SMB] Over sized packet left for garbage collector");
        }
        if (smbPkt.hasAssociatedPacket()) {
            byte[] assocBuf = smbPkt.getAssociatedPacket().getBuffer();
            if (assocBuf.length <= this.m_maxPoolBufSize) {
                this.m_bufferPool.releaseBuffer(smbPkt.getAssociatedPacket().getBuffer());
                this.m_leasedPkts.remove(smbPkt.getAssociatedPacket());
                if (this.hasAllocateDebug()) {
                    Debug.println("[SMB] CIFS Packet released bufSiz=" + smbPkt.getBuffer().length + " and assoc packet, bufSiz=" + smbPkt.getAssociatedPacket().getBuffer().length);
                }
            } else if (this.hasAllocateDebug()) {
                Debug.println("[SMB] Over sized associated packet left for garbage collector");
            }
            smbPkt.clearAssociatedPacket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkForExpiredLeases() {
        block7: {
            try {
                if (!this.hasDebug()) break block7;
                HashMap<SMBSrvPacket, SMBSrvPacket> hashMap = this.m_leasedPkts;
                synchronized (hashMap) {
                    if (!this.m_leasedPkts.isEmpty()) {
                        Iterator<SMBSrvPacket> leaseIter = this.m_leasedPkts.keySet().iterator();
                        long timeNow = System.currentTimeMillis();
                        while (leaseIter.hasNext()) {
                            SMBSrvPacket curPkt = leaseIter.next();
                            if (!curPkt.hasLeaseTime() || curPkt.getLeaseTime() >= timeNow) continue;
                            Debug.println("[SMB] Packet lease expired, pkt=" + curPkt);
                        }
                    }
                }
            }
            catch (Throwable ex) {
                Debug.println(ex);
            }
        }
    }

    public final ByteBufferPool getBufferPool() {
        return this.m_bufferPool;
    }

    public final int getSmallestSize() {
        return this.m_bufferPool.getSmallestSize();
    }

    public final int getLargestSize() {
        return this.m_bufferPool.getLargestSize();
    }

    public final boolean allowsOverSizedAllocations() {
        return this.m_allowOverSize;
    }

    public final int getMaximumOverSizedAllocation() {
        return this.m_maxOverSize;
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    public final void setAllocateDebug(boolean ena) {
        this.m_allocDebug = ena;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final boolean hasAllocateDebug() {
        return this.m_allocDebug;
    }

    public final void setAllowOverSizedAllocations(boolean ena) {
        this.m_allowOverSize = ena;
    }

    public String toString() {
        return this.m_bufferPool.toString();
    }

    private class CIFSLeaseExpiryTimedRequest
    extends TimedThreadRequest {
        public CIFSLeaseExpiryTimedRequest() {
            super("CIFSPacketPoolExpiry", -5L, 5L);
        }

        protected void runTimedRequest() {
            CIFSPacketPool.this.checkForExpiredLeases();
        }
    }
}

