/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.net.InetAddress;
import org.alfresco.jlan.server.auth.CifsAuthenticator;
import org.alfresco.jlan.server.auth.ICifsAuthenticator;
import org.alfresco.jlan.server.config.ConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.smb.DialectSelector;
import org.alfresco.jlan.util.StringList;
import org.springframework.extensions.config.ConfigElement;

public class CIFSConfigSection
extends ConfigSection {
    public static final String SectionName = "CIFS";
    public static final int DefSessionTimeout = 900000;
    private String m_name;
    private StringList m_aliasNames;
    private int m_srvType = 3;
    private String m_comment;
    private String m_domain;
    private String m_broadcast;
    private boolean m_announce;
    private int m_announceInterval;
    private int m_announcePort;
    private DialectSelector m_dialects = new DialectSelector();
    private ICifsAuthenticator m_authenticator;
    private ConfigElement m_authParams;
    private boolean m_localAuthenticator;
    private boolean m_nbDebug = false;
    private boolean m_announceDebug = false;
    private int m_sessDebug;
    private int m_namePort = 137;
    private int m_sessPort = 139;
    private int m_nbDatagramPort = 138;
    private int m_tcpSMBPort = 445;
    private boolean m_netBIOSEnable = true;
    private boolean m_tcpSMBEnable = false;
    private boolean m_win32NBEnable = false;
    private InetAddress m_smbBindAddress;
    private InetAddress m_nbBindAddress;
    private InetAddress m_winsPrimary;
    private InetAddress m_winsSecondary;
    private boolean m_macExtensions;
    private boolean m_disableNIO;
    private int m_clientSocketTimeout = 900000;
    private String m_win32NBName;
    private int m_win32NBLANA = -1;
    private String m_win32NBAccept = "*";
    private boolean m_win32NBAnnounce = false;
    private int m_win32NBAnnounceInterval;
    private boolean m_win32NBUseWinsock = true;
    private boolean m_disableNativeCode = false;

    public CIFSConfigSection(ServerConfiguration config) {
        super(SectionName, config);
        this.m_dialects.EnableAll();
    }

    public final ICifsAuthenticator getAuthenticator() {
        return this.m_authenticator;
    }

    public final ConfigElement getAuthenticatorParameters() {
        return this.m_authParams;
    }

    public final InetAddress getSMBBindAddress() {
        return this.m_smbBindAddress;
    }

    public final InetAddress getNetBIOSBindAddress() {
        return this.m_nbBindAddress;
    }

    public final String getBroadcastMask() {
        return this.m_broadcast;
    }

    public final String getComment() {
        return this.m_comment != null ? this.m_comment : "";
    }

    public final String getDomainName() {
        return this.m_domain;
    }

    public final DialectSelector getEnabledDialects() {
        return this.m_dialects;
    }

    public final int getNameServerPort() {
        return this.m_namePort;
    }

    public final int getDatagramPort() {
        return this.m_nbDatagramPort;
    }

    public final String getServerName() {
        return this.m_name;
    }

    public final boolean hasAliasNames() {
        return this.m_aliasNames != null;
    }

    public final int getNumberOfAliasNames() {
        return this.m_aliasNames != null ? this.m_aliasNames.numberOfStrings() : 0;
    }

    public final StringList getAliasNames() {
        return this.m_aliasNames;
    }

    public final int getServerType() {
        return this.m_srvType;
    }

    public final int getSessionDebugFlags() {
        return this.m_sessDebug;
    }

    public final int getSessionPort() {
        return this.m_sessPort;
    }

    public final String getWin32ServerName() {
        return this.m_win32NBName;
    }

    public final String getWin32ClientAccept() {
        return this.m_win32NBAccept;
    }

    public final boolean hasWin32EnableAnnouncer() {
        return this.m_win32NBAnnounce;
    }

    public final int getWin32HostAnnounceInterval() {
        return this.m_win32NBAnnounceInterval;
    }

    public final int getWin32LANA() {
        return this.m_win32NBLANA;
    }

    public final boolean useWinsockNetBIOS() {
        return this.m_win32NBUseWinsock;
    }

    public final boolean hasDisableNIOCode() {
        return this.m_disableNIO;
    }

    public final boolean hasPrimaryWINSServer() {
        return this.m_winsPrimary != null;
    }

    public final InetAddress getPrimaryWINSServer() {
        return this.m_winsPrimary;
    }

    public final boolean hasSecondaryWINSServer() {
        return this.m_winsSecondary != null;
    }

    public final InetAddress getSecondaryWINSServer() {
        return this.m_winsSecondary;
    }

    public final boolean hasSMBBindAddress() {
        return this.m_smbBindAddress != null;
    }

    public final boolean hasNetBIOSBindAddress() {
        return this.m_nbBindAddress != null;
    }

    public final boolean hasNetBIOSDebug() {
        return this.m_nbDebug;
    }

    public final boolean hasHostAnnounceDebug() {
        return this.m_announceDebug;
    }

    public final boolean hasEnableAnnouncer() {
        return this.m_announce;
    }

    public final int getHostAnnounceInterval() {
        return this.m_announceInterval;
    }

    public final int getHostAnnouncerPort() {
        return this.m_announcePort;
    }

    public final boolean hasMacintoshExtensions() {
        return this.m_macExtensions;
    }

    public final boolean hasNetBIOSSMB() {
        return this.m_netBIOSEnable;
    }

    public final boolean hasTcpipSMB() {
        return this.m_tcpSMBEnable;
    }

    public final boolean hasWin32NetBIOS() {
        return this.m_win32NBEnable;
    }

    public final int getTcpipSMBPort() {
        return this.m_tcpSMBPort;
    }

    public final int getSocketTimeout() {
        return this.m_clientSocketTimeout;
    }

    public final boolean isNativeCodeDisabled() {
        return this.m_disableNativeCode;
    }

    public final int setAuthenticator(String authClass, ConfigElement params, int accessMode, boolean allowGuest) throws InvalidConfigurationException {
        int sts = 0;
        CifsAuthenticator auth = null;
        try {
            Object authObj = Class.forName(authClass).newInstance();
            if (!(authObj instanceof CifsAuthenticator)) {
                throw new InvalidConfigurationException("Authenticator is not derived from required base class");
            }
            auth = (CifsAuthenticator)authObj;
            auth.setAccessMode(accessMode);
            auth.setAllowGuest(allowGuest);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidConfigurationException("Authenticator class " + authClass + " not found");
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Authenticator class error");
        }
        auth.initialize(this.getServerConfiguration(), params);
        sts = this.setAuthenticator(auth);
        this.m_localAuthenticator = true;
        this.m_authParams = params;
        return sts;
    }

    public final int setAuthenticator(ICifsAuthenticator auth) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131098, auth);
        this.m_authenticator = auth;
        this.m_localAuthenticator = false;
        return sts;
    }

    public final int setSMBBindAddress(InetAddress addr) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131085, addr);
        this.m_smbBindAddress = addr;
        return sts;
    }

    public final int setNetBIOSBindAddress(InetAddress addr) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(327683, addr);
        this.m_nbBindAddress = addr;
        return sts;
    }

    public final int setBroadcastMask(String mask) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131078, mask);
        this.m_broadcast = mask;
        return sts;
    }

    public final int setComment(String comment) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131076, comment);
        this.m_comment = comment;
        return sts;
    }

    public final int setDomainName(String domain) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131077, domain);
        this.m_domain = domain;
        return sts;
    }

    public final int setEnabledDialects(DialectSelector dialects) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131081, dialects);
        this.m_dialects = new DialectSelector();
        this.m_dialects.copyFrom(dialects);
        return sts;
    }

    public final int setHostAnnouncer(boolean b) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_announce != b) {
            sts = this.fireConfigurationChange(131079, new Boolean(b));
            this.m_announce = b;
        }
        return sts;
    }

    public final int setHostAnnounceInterval(int ival) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131080, new Integer(ival));
        this.m_announceInterval = ival;
        return sts;
    }

    public final int setHostAnnouncerPort(int port) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131095, new Integer(port));
        this.m_announcePort = port;
        return sts;
    }

    public final int setNameServerPort(int port) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(327681, new Integer(port));
        this.m_namePort = port;
        return sts;
    }

    public final int setDatagramPort(int port) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(327687, new Integer(port));
        this.m_nbDatagramPort = port;
        return sts;
    }

    public final int setNetBIOSDebug(boolean ena) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_nbDebug != ena) {
            sts = this.fireConfigurationChange(327684, new Boolean(ena));
            this.m_nbDebug = ena;
        }
        return sts;
    }

    public final int setHostAnnounceDebug(boolean ena) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_announceDebug != ena) {
            sts = this.fireConfigurationChange(131089, new Boolean(ena));
            this.m_announceDebug = ena;
        }
        return sts;
    }

    public final int setMacintoshExtensions(boolean ena) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_macExtensions != ena) {
            sts = this.fireConfigurationChange(131086, new Boolean(ena));
            this.m_macExtensions = ena;
        }
        return sts;
    }

    public final int setServerName(String name) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131073, name);
        this.m_name = name;
        return sts;
    }

    public final int addAliasName(String alias) throws InvalidConfigurationException {
        if (this.m_aliasNames == null) {
            this.m_aliasNames = new StringList();
        }
        int sts = 0;
        if (!this.m_aliasNames.containsString(alias)) {
            sts = this.fireConfigurationChange(131074, alias);
            this.m_aliasNames.addString(alias);
        }
        return sts;
    }

    public final int addAliasNames(StringList names) throws InvalidConfigurationException {
        if (this.m_aliasNames == null) {
            this.m_aliasNames = new StringList();
        }
        int sts = 0;
        for (int i = 0; i < names.numberOfStrings(); ++i) {
            String curAlias = names.getStringAt(i);
            int curSts = this.addAliasName(curAlias);
            if (curSts <= sts) continue;
            sts = curSts;
        }
        return sts;
    }

    public final int setServerType(int typ) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131075, new Integer(typ));
        this.m_srvType = typ;
        return sts;
    }

    public final int setSessionDebugFlags(int flags) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131087, new Integer(flags));
        this.m_sessDebug = flags;
        return sts;
    }

    public final int setSessionPort(int port) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(327682, new Integer(port));
        this.m_sessPort = port;
        return sts;
    }

    public final int setNetBIOSSMB(boolean ena) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_netBIOSEnable != ena) {
            sts = this.fireConfigurationChange(131083, new Boolean(ena));
            this.m_netBIOSEnable = ena;
        }
        return sts;
    }

    public final int setTcpipSMB(boolean ena) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_tcpSMBEnable != ena) {
            sts = this.fireConfigurationChange(131084, new Boolean(ena));
            this.m_tcpSMBEnable = ena;
        }
        return sts;
    }

    public final int setWin32NetBIOS(boolean ena) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_win32NBEnable != ena) {
            sts = this.fireConfigurationChange(131090, new Boolean(ena));
            this.m_win32NBEnable = ena;
        }
        return sts;
    }

    public final int setWin32NetBIOSName(String name) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131091, name);
        this.m_win32NBName = name;
        return sts;
    }

    public final int setWin32NetBIOSClientAccept(String name) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131092, name);
        this.m_win32NBAccept = name;
        return sts;
    }

    public final int setWin32HostAnnouncer(boolean b) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_win32NBAnnounce != b) {
            sts = this.fireConfigurationChange(131093, new Boolean(b));
            this.m_win32NBAnnounce = b;
        }
        return sts;
    }

    public final int setWin32LANA(int ival) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131094, new Integer(ival));
        this.m_win32NBLANA = ival;
        return sts;
    }

    public final int setWin32HostAnnounceInterval(int ival) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131093, new Integer(ival));
        this.m_win32NBAnnounceInterval = ival;
        return sts;
    }

    public final int setWin32WinsockNetBIOS(boolean useWinsock) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131097, new Boolean(useWinsock));
        this.m_win32NBUseWinsock = useWinsock;
        return sts;
    }

    public final int setTcpipSMBPort(int port) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131082, new Integer(port));
        this.m_tcpSMBPort = port;
        return sts;
    }

    public final int setPrimaryWINSServer(InetAddress addr) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(327685, addr);
        this.m_winsPrimary = addr;
        return sts;
    }

    public final int setSecondaryWINSServer(InetAddress addr) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(327686, addr);
        this.m_winsSecondary = addr;
        return sts;
    }

    public final int setDisableNIOCode(boolean disableNIO) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131099, new Boolean(disableNIO));
        this.m_disableNIO = disableNIO;
        return sts;
    }

    public final int setSocketTimeout(int tmo) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(131100, new Integer(tmo));
        this.m_clientSocketTimeout = tmo;
        return sts;
    }

    public final void setNativeCodeDisabled(boolean noNative) {
        this.m_disableNativeCode = noNative;
    }

    public final void closeConfig() {
        if (this.m_authenticator != null && this.m_localAuthenticator) {
            this.m_authenticator.closeAuthenticator();
            this.m_authenticator = null;
        }
    }
}

