/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.dcerpc.info;

import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.DCEReadable;

public class SessionInfo
implements DCEReadable {
    public static final int InfoLevel0 = 0;
    public static final int InfoLevel1 = 1;
    public static final int InfoLevel2 = 2;
    public static final int InfoLevel10 = 10;
    public static final int InfoLevel502 = 502;
    public static final int Guest = 1;
    public static final int EncryptedPassword = 2;
    private int m_infoLevel;
    private String m_client;
    private String m_user;
    private int m_openFiles;
    private int m_sessTime;
    private int m_idleTime;
    private int m_userFlags;
    private String m_clientType;
    private String m_transport;

    public SessionInfo() {
    }

    public SessionInfo(int infoLevel) {
        this.m_infoLevel = infoLevel;
    }

    public final int getInformationLevel() {
        return this.m_infoLevel;
    }

    public final String getClientName() {
        return this.m_client;
    }

    public final String getUserName() {
        return this.m_user;
    }

    public final int getNumberOfOpenFiles() {
        return this.m_openFiles;
    }

    public final int getSessionTime() {
        return this.m_sessTime;
    }

    public final int getIdleTime() {
        return this.m_idleTime;
    }

    public final int getUserFlags() {
        return this.m_userFlags;
    }

    public final boolean isGuest() {
        return (this.m_userFlags & 1) != 0;
    }

    public final boolean usedEncryptedPassword() {
        return (this.m_userFlags & 2) != 0;
    }

    public final String getClientType() {
        return this.m_clientType;
    }

    public final String getTransport() {
        return this.m_transport;
    }

    protected final void clearStrings() {
        this.m_client = null;
        this.m_user = null;
        this.m_clientType = null;
        this.m_transport = null;
    }

    public void readObject(DCEBuffer buf) throws DCEBufferException {
        this.clearStrings();
        switch (this.getInformationLevel()) {
            case 0: {
                this.m_client = buf.getPointer() != 0 ? "" : null;
                break;
            }
            case 1: {
                this.m_client = buf.getPointer() != 0 ? "" : null;
                this.m_user = buf.getPointer() != 0 ? "" : null;
                this.m_openFiles = buf.getInt();
                this.m_sessTime = buf.getInt();
                this.m_idleTime = buf.getInt();
                this.m_userFlags = buf.getInt();
                break;
            }
            case 2: {
                this.m_client = buf.getPointer() != 0 ? "" : null;
                this.m_user = buf.getPointer() != 0 ? "" : null;
                this.m_openFiles = buf.getInt();
                this.m_sessTime = buf.getInt();
                this.m_idleTime = buf.getInt();
                this.m_userFlags = buf.getInt();
                this.m_clientType = buf.getPointer() != 0 ? "" : null;
                break;
            }
            case 10: {
                this.m_client = buf.getPointer() != 0 ? "" : null;
                this.m_user = buf.getPointer() != 0 ? "" : null;
                this.m_sessTime = buf.getInt();
                this.m_idleTime = buf.getInt();
                break;
            }
            case 502: {
                this.m_client = buf.getPointer() != 0 ? "" : null;
                this.m_user = buf.getPointer() != 0 ? "" : null;
                this.m_openFiles = buf.getInt();
                this.m_sessTime = buf.getInt();
                this.m_idleTime = buf.getInt();
                this.m_userFlags = buf.getInt();
                this.m_clientType = buf.getPointer() != 0 ? "" : null;
                this.m_transport = buf.getPointer() != 0 ? "" : null;
            }
        }
    }

    public void readStrings(DCEBuffer buf) throws DCEBufferException {
        if (this.getClientName() != null) {
            this.m_client = buf.getString(1);
        }
        if (this.getUserName() != null) {
            this.m_user = buf.getString(1);
        }
        if (this.getClientType() != null) {
            this.m_clientType = buf.getString(1);
        }
        if (this.getTransport() != null) {
            this.m_transport = buf.getString(1);
        }
    }

    public final void setClientName(String client) {
        this.m_client = client;
    }

    public final void setUserName(String userName) {
        this.m_user = userName;
    }

    public final void setNumberOfOpenFiles(int files) {
        this.m_openFiles = files;
    }

    public final void setSessionTime(int sessTime) {
        this.m_sessTime = sessTime;
    }

    public final void setIdleTime(int idleTime) {
        this.m_idleTime = idleTime;
    }

    public final void setUserFlags(int flags) {
        this.m_userFlags = flags;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[Client=");
        str.append(this.getClientName());
        str.append(":Level=");
        str.append(this.getInformationLevel());
        str.append(":");
        if (this.getInformationLevel() >= 1) {
            str.append("User=");
            str.append(this.getUserName());
            str.append(",OpenFiles=");
            str.append(this.getNumberOfOpenFiles());
            str.append(",Connected=");
            str.append(this.getSessionTime());
            str.append(",Idle=");
            str.append(this.getIdleTime());
            str.append(",UserFlags=");
            str.append(this.getUserFlags());
        }
        if (this.getInformationLevel() >= 2) {
            str.append(",ClientType=");
            str.append(this.getClientType());
        }
        if (this.getInformationLevel() == 502) {
            str.append(",Transport=");
            str.append(this.getTransport());
        }
        str.append("]");
        return str.toString();
    }
}

