/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.dcerpc.info;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.DCEDataPacker;
import org.alfresco.jlan.smb.dcerpc.DCEReadableList;
import org.alfresco.jlan.smb.dcerpc.info.ServiceStatusInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceStatusList
implements DCEReadableList {
    private List<ServiceStatusInfo> m_list = new ArrayList<ServiceStatusInfo>();
    private int m_moreData;

    public final List<ServiceStatusInfo> getList() {
        return this.m_list;
    }

    public final ServiceStatusInfo getInfo(int idx) {
        if (this.m_list == null || idx >= this.m_list.size()) {
            return null;
        }
        return this.m_list.get(idx);
    }

    public final int numberOfServices() {
        return this.m_list.size();
    }

    public final void addServiceStatus(ServiceStatusInfo stsInfo) {
        this.m_list.add(stsInfo);
    }

    @Override
    public void readObject(DCEBuffer buf) throws DCEBufferException {
        int dataLen = buf.getInt();
        buf.positionAt(DCEDataPacker.longwordAlign(dataLen + 8));
        int numSvcs = buf.getInt();
        this.m_moreData = buf.getPointer() != 0 ? buf.getInt() : 0;
        buf.positionAt(4);
        for (int i = 0; i < numSvcs; ++i) {
            int pName = buf.getInt();
            int pDisp = buf.getInt();
            ServiceStatusInfo stsInfo = new ServiceStatusInfo();
            stsInfo.readObject(buf);
            String srvName = "";
            if (pName != 0) {
                srvName = buf.getStringAt(pName + 4);
            }
            String dspName = "";
            if (pDisp != 0) {
                dspName = buf.getStringAt(pDisp + 4);
            }
            stsInfo.setName(srvName);
            stsInfo.setDisplayName(dspName);
            this.m_list.add(stsInfo);
        }
    }

    public final int getMultiPartHandle() {
        return this.m_moreData;
    }
}

