/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.thread;

import java.util.Date;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.thread.ThreadRequest;
import org.alfresco.jlan.server.thread.ThreadRequestPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimedThreadRequest
implements ThreadRequest,
Comparable<TimedThreadRequest> {
    public static final long TimedRequestPaused = 0L;
    private long m_runAt;
    private long m_repeatSecs;
    private String m_description;
    private ThreadRequestPool m_threadPool;

    public TimedThreadRequest(String desc, long runAt) {
        this.setRunAtTime(runAt);
        this.m_description = desc;
    }

    public TimedThreadRequest(String desc, long runAt, long repeatSecs) {
        this.setRunAtTime(runAt);
        this.setRepeatInterval(repeatSecs);
        this.m_description = desc;
    }

    public final String getDescription() {
        return this.m_description;
    }

    public final long getRunAtTime() {
        return this.m_runAt;
    }

    public final boolean isPaused() {
        return this.m_runAt == 0L;
    }

    public final boolean hasRepeatInterval() {
        return this.m_repeatSecs > 0L;
    }

    public final long getRepeatInterval() {
        return this.m_repeatSecs;
    }

    public final boolean hasThreadRequestPool() {
        return this.m_threadPool != null;
    }

    public final ThreadRequestPool getThreadRequestPool() {
        return this.m_threadPool;
    }

    public final void setRunAtTime(long runAt) {
        this.m_runAt = runAt < 0L ? System.currentTimeMillis() + -runAt * 1000L : runAt;
        if (this.hasThreadRequestPool()) {
            this.getThreadRequestPool().queueTimedRequest(this);
        }
    }

    public final void setRepeatInterval(long repeatSecs) {
        this.m_repeatSecs = repeatSecs;
    }

    protected final void setThreadRequestPool(ThreadRequestPool threadPool) {
        this.m_threadPool = threadPool;
    }

    public final void restartRequest() {
        if (this.isPaused()) {
            this.setRunAtTime(System.currentTimeMillis() + this.getRepeatInterval() * 1000L);
        }
    }

    @Override
    public void runRequest() {
        try {
            this.runTimedRequest();
        }
        catch (Throwable ex) {
            Debug.println(ex, 1);
        }
        if (!this.isPaused()) {
            if (this.hasRepeatInterval()) {
                this.setRunAtTime(System.currentTimeMillis() + this.getRepeatInterval() * 1000L);
                this.m_threadPool.queueTimedRequest(this);
            } else {
                this.m_threadPool = null;
            }
        } else {
            this.m_threadPool.queueTimedRequest(this);
        }
    }

    protected abstract void runTimedRequest();

    @Override
    public int compareTo(TimedThreadRequest timedReq) {
        if (this.isPaused() && timedReq.isPaused()) {
            return 0;
        }
        if (this.isPaused()) {
            return 1;
        }
        if (timedReq.isPaused()) {
            return -1;
        }
        if (this.getRunAtTime() < timedReq.getRunAtTime()) {
            return -1;
        }
        if (this.getRunAtTime() == timedReq.getRunAtTime()) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getDescription());
        str.append(",RunAt=");
        if (this.getRunAtTime() == 0L) {
            str.append("Paused");
        } else {
            str.append(new Date(this.getRunAtTime()));
        }
        str.append(",Repeat=");
        if (this.getRepeatInterval() > 0L) {
            str.append(this.getRepeatInterval());
        } else {
            str.append("None");
        }
        str.append("]");
        return str.toString();
    }
}

