/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.locking;

import java.io.IOException;
import org.alfresco.jlan.server.filesys.DeferFailedException;
import org.alfresco.jlan.server.locking.OpLockDetails;
import org.alfresco.jlan.smb.OpLock;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class LocalOpLockDetails
implements OpLockDetails {
    private int m_type;
    private String m_path;
    private boolean m_folder;
    private SMBSrvSession m_deferredSess;
    private SMBSrvPacket m_deferredPkt;
    private long m_opBreakTime;
    private boolean m_failedBreak;
    private SMBSrvSession m_ownerSess;
    private int m_pid;
    private int m_uid;
    private int m_treeId;
    private int m_fileId;

    public LocalOpLockDetails(int lockTyp, String path, SMBSrvSession sess, int pid, int uid, int treeId, int fileId, boolean folder) {
        this.m_type = lockTyp;
        this.m_path = path;
        this.m_folder = folder;
        this.m_ownerSess = sess;
        this.m_pid = pid;
        this.m_uid = uid;
        this.m_treeId = treeId;
        this.m_fileId = fileId;
    }

    public LocalOpLockDetails(int lockTyp, String path, SMBSrvSession sess, SMBSrvPacket pkt, boolean folder) {
        this.m_type = lockTyp;
        this.m_path = path;
        this.m_folder = folder;
        this.m_ownerSess = sess;
        this.m_pid = pkt.getProcessId();
        this.m_uid = pkt.getUserId();
        this.m_treeId = pkt.getTreeId();
        this.m_fileId = -1;
    }

    public LocalOpLockDetails(int lockTyp, String path, SMBSrvSession sess, int pid, int treeId, boolean folder) {
        this.m_type = lockTyp;
        this.m_path = path;
        this.m_folder = folder;
        this.m_ownerSess = sess;
        this.m_pid = pid;
        this.m_treeId = treeId;
        this.m_uid = -1;
        this.m_fileId = -1;
    }

    public int getLockType() {
        return this.m_type;
    }

    public SMBSrvSession getOwnerSession() {
        return this.m_ownerSess;
    }

    public final int getOwnerPID() {
        return this.m_pid;
    }

    public final int getOwnerUID() {
        return this.m_uid;
    }

    public final int getOwnerTreeId() {
        return this.m_treeId;
    }

    public final int getOwnerFileId() {
        return this.m_fileId;
    }

    public String getPath() {
        return this.m_path;
    }

    public boolean isFolder() {
        return this.m_folder;
    }

    public synchronized boolean hasDeferredSession() {
        return this.m_deferredSess != null;
    }

    public SMBSrvSession getDeferredSession() {
        return this.m_deferredSess;
    }

    public SMBSrvPacket getDeferredPacket() {
        return this.m_deferredPkt;
    }

    public long getOplockBreakTime() {
        return this.m_opBreakTime;
    }

    public boolean hasOplockBreakFailed() {
        return this.m_failedBreak;
    }

    public boolean isRemoteLock() {
        return false;
    }

    public final void setOwnerFileId(int fileId) {
        this.m_fileId = fileId;
    }

    public final void setDeferredSession(SMBSrvSession deferredSess, SMBSrvPacket deferredPkt) throws DeferFailedException {
        if (this.hasDeferredSession()) {
            throw new DeferFailedException("Cannot defer session/packet");
        }
        this.m_deferredSess = deferredSess;
        this.m_deferredPkt = deferredPkt;
        this.m_opBreakTime = System.currentTimeMillis();
        deferredPkt.incrementDeferredCount();
    }

    public final void clearDeferredSession() {
        this.m_deferredSess = null;
        this.m_deferredPkt = null;
    }

    public final void setOplockBreakFailed() {
        this.m_failedBreak = true;
    }

    public void setLockType(int lockTyp) {
        this.m_type = lockTyp;
    }

    public void requestOpLockBreak() throws IOException {
        if (this.getOwnerSession() == null || this.hasOplockBreakFailed()) {
            return;
        }
        SMBSrvPacket opBreakPkt = new SMBSrvPacket(128);
        opBreakPkt.clearHeader();
        opBreakPkt.setCommand(36);
        opBreakPkt.setFlags(0);
        opBreakPkt.setFlags2(0);
        opBreakPkt.setTreeId(this.getOwnerTreeId());
        opBreakPkt.setProcessId(65535);
        opBreakPkt.setUserId(0);
        opBreakPkt.setMultiplexId(65535);
        opBreakPkt.setParameterCount(8);
        opBreakPkt.setAndXCommand(255);
        opBreakPkt.setParameter(1, 0);
        opBreakPkt.setParameter(2, this.getOwnerFileId());
        opBreakPkt.setParameter(3, 258);
        opBreakPkt.setParameterLong(4, 0);
        opBreakPkt.setParameter(6, 0);
        opBreakPkt.setParameter(7, 0);
        opBreakPkt.setByteCount(0);
        opBreakPkt.setRequestPacket(true);
        boolean breakSent = this.getOwnerSession().sendAsynchResponseSMB(opBreakPkt, opBreakPkt.getLength());
        this.m_opBreakTime = System.currentTimeMillis();
        if (this.getOwnerSession().hasDebug(0x8000000)) {
            this.getOwnerSession().debugPrintln("Oplock break sent to " + this.getOwnerSession().getUniqueId() + " async=" + (breakSent ? "Sent" : "Queued"));
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Local Type=");
        str.append(OpLock.getTypeAsString(this.getLockType()));
        str.append(",");
        str.append(this.getPath());
        str.append(",Owner=");
        if (this.getOwnerSession() != null) {
            str.append(this.getOwnerSession().getUniqueId());
        } else {
            str.append("NULL");
        }
        str.append(",PID=");
        str.append(this.getOwnerPID());
        str.append(",UID=");
        str.append(this.getOwnerUID());
        str.append(",TreeID=");
        str.append(this.getOwnerTreeId());
        str.append(",FileId=");
        str.append(this.getOwnerFileId());
        if (this.hasDeferredSession()) {
            str.append(",Deferred=");
            str.append(this.getDeferredSession());
        }
        if (this.hasOplockBreakFailed()) {
            str.append(" BreakFailed");
        }
        str.append("]");
        return str.toString();
    }
}

