/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.loader;

import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.loader.WriteRequest;
import org.alfresco.jlan.server.filesys.loader.WriteRequestQueue;

public class ThreadedWriter {
    public static final int DefaultWorkerThreads = 8;
    public static final int MinimumWorkerThreads = 4;
    public static final int MaximumWorkerThreads = 50;
    private WriteRequestQueue m_queue = new WriteRequestQueue();
    private ThreadWorker[] m_workers = new ThreadWorker[8];
    private static boolean m_debug = true;

    public ThreadedWriter() {
        for (int i = 0; i < this.m_workers.length; ++i) {
            this.m_workers[i] = new ThreadWorker("ThreadedWriter_" + (i + 1), i);
        }
    }

    public static final boolean hasDebug() {
        return m_debug;
    }

    public final void addWriteRequest(WriteRequest req) {
        this.m_queue.addRequest(req);
    }

    public void shutdownWriter() {
        if (this.m_workers != null) {
            for (int i = 0; i < this.m_workers.length; ++i) {
                this.m_workers[i].shutdownRequest();
            }
        }
    }

    protected class ThreadWorker
    implements Runnable {
        private Thread mi_thread;
        private int mi_id;
        private boolean mi_shutdown = false;

        public ThreadWorker(String name, int id) {
            this.mi_id = id;
            this.mi_thread = new Thread(this);
            this.mi_thread.setName(name);
            this.mi_thread.setDaemon(true);
            this.mi_thread.start();
        }

        public final void shutdownRequest() {
            this.mi_shutdown = true;
            try {
                this.mi_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            WriteRequest writeReq = null;
            while (!this.mi_shutdown) {
                try {
                    writeReq = ThreadedWriter.this.m_queue.removeRequest();
                }
                catch (InterruptedException ex) {
                    if (this.mi_shutdown) break;
                }
                if (writeReq == null) continue;
                if (ThreadedWriter.hasDebug()) {
                    Debug.println("ThreadedWriter writeReq=" + writeReq);
                }
                writeReq.doWrite();
            }
            if (ThreadedWriter.hasDebug()) {
                Debug.println("ThreadedWriter thread=" + this.mi_thread.getName() + " shutdown");
            }
        }
    }
}

