/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.db;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.alfresco.jlan.server.filesys.db.DBNetworkFile;

public class LocalDataNetworkFile
extends DBNetworkFile {
    protected File m_file;
    protected RandomAccessFile m_io;
    protected boolean m_eof;

    public LocalDataNetworkFile(String name, int fid, int did, File file) {
        super(name, fid, 0, did);
        this.m_file = file;
        this.setFileSize(this.m_file.length());
        this.m_eof = false;
        this.setModifyDate(this.m_file.lastModified());
    }

    public void openFile(boolean createFlag) throws IOException {
        this.m_io = new RandomAccessFile(this.m_file, "rw");
    }

    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.m_io == null) {
            this.openFile(false);
        }
        this.m_io.seek(fileOff);
        int rdlen = this.m_io.read(buf, pos, len);
        return rdlen;
    }

    public void writeFile(byte[] buf, int len, int pos, long offset) throws IOException {
        long fileLen;
        long endpos;
        if (this.m_io == null) {
            this.openFile(false);
        }
        if ((endpos = offset + (long)len) > (fileLen = this.m_io.length())) {
            this.m_io.setLength(endpos);
        }
        if (len == 0) {
            return;
        }
        this.m_io.seek(offset);
        this.m_io.write(buf, pos, len);
        this.incrementWriteCount();
        this.setStatus(3);
    }

    public final void flushFile() throws IOException {
        if (this.m_io != null) {
            this.m_io.getFD().sync();
        }
    }

    public long seekFile(long pos, int typ) throws IOException {
        if (this.m_io == null) {
            this.openFile(false);
        }
        long curPos = this.m_io.getFilePointer();
        switch (typ) {
            case 0: {
                if (curPos == pos) break;
                this.m_io.seek(pos);
                break;
            }
            case 1: {
                this.m_io.seek(curPos + pos);
                break;
            }
            case 2: {
                long newPos = this.m_io.length() + pos;
                this.m_io.seek(newPos);
            }
        }
        return (int)(this.m_io.getFilePointer() & 0xFFFFFFFFFFFFFFFFL);
    }

    public void truncateFile(long siz) throws IOException {
        if (this.m_io == null) {
            this.openFile(false);
        }
        this.m_io.setLength(siz);
        this.incrementWriteCount();
    }

    public void closeFile() {
        if (this.m_io != null) {
            try {
                this.m_io.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_io = null;
            if (this.getWriteCount() > 0) {
                this.m_file.setLastModified(System.currentTimeMillis());
            }
            this.setFileSize(this.m_file.length());
        }
    }
}

