/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.FileStatus;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;
import org.alfresco.jlan.server.filesys.cache.hazelcast.RemoteStateTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateStateTask
extends RemoteStateTask<Boolean> {
    private static final long serialVersionUID = 1L;
    private int m_fileStatus;

    public UpdateStateTask() {
    }

    public UpdateStateTask(String mapName, String key, int fileSts, boolean debug, boolean timingDebug) {
        super(mapName, key, true, false, debug, timingDebug);
        this.m_fileStatus = fileSts;
    }

    @Override
    protected Boolean runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        if (this.hasDebug()) {
            Debug.println("UpdateStateTask: Update file status=" + FileStatus.asString(this.m_fileStatus) + ", state=" + fState);
        }
        boolean changedSts = false;
        if (fState.getFileStatus() != this.m_fileStatus) {
            fState.setFileStatusInternal(this.m_fileStatus, 0);
            changedSts = true;
            if (fState.getFileStatus() == 0) {
                fState.setFileId(-1);
                fState.removeAllAttributes();
            }
            if (this.hasDebug()) {
                Debug.println("UpdateStateTask: Status updated, state=" + fState);
            }
        }
        return new Boolean(changedSts);
    }
}

