/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileStateCache;
import org.alfresco.jlan.server.filesys.cache.cluster.FileStatePostProcessor;
import org.alfresco.jlan.server.filesys.cache.hazelcast.HazelCastClusterFileState;

public class StateUpdatePostProcessor
extends FileStatePostProcessor {
    private int m_updateMask;

    public StateUpdatePostProcessor(ClusterFileStateCache stateCache, HazelCastClusterFileState state, int updateMask) {
        super(stateCache, state);
        this.m_updateMask = updateMask;
    }

    public final int getUpdateMask() {
        return this.m_updateMask;
    }

    public final void addToUpdateMask(int updateMask) {
        this.m_updateMask |= updateMask;
    }

    public final void removeFromUpdateMask(int updateMask) {
        this.m_updateMask &= ~updateMask;
    }

    public void runProcessor() {
        block2: {
            try {
                this.getStateCache().updateFileState(this.getState(), this.m_updateMask);
            }
            catch (Exception ex) {
                if (!StateUpdatePostProcessor.hasDebug()) break block2;
                Debug.println("State update post processor failed to update state=" + this.getState() + ", updates=" + ClusterFileState.getUpdateMaskAsString(this.m_updateMask));
                Debug.println(ex);
            }
        }
    }
}

