/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import java.io.IOException;
import java.io.Serializable;
import org.alfresco.jlan.server.filesys.DeferFailedException;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileStateCache;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterNode;
import org.alfresco.jlan.server.filesys.cache.cluster.PerNodeState;
import org.alfresco.jlan.server.locking.OpLockDetails;
import org.alfresco.jlan.server.locking.OpLockDetailsAdapter;
import org.alfresco.jlan.smb.OpLock;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class RemoteOpLockDetails
extends OpLockDetailsAdapter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int m_lockType;
    private String m_ownerName;
    private String m_path;
    private transient ClusterFileStateCache m_stateCache;

    public RemoteOpLockDetails() {
    }

    protected RemoteOpLockDetails(ClusterNode clNode, int lockTyp, String path, ClusterFileStateCache stateCache) {
        this.m_ownerName = clNode.getName();
        this.m_lockType = lockTyp;
        this.m_path = path;
        this.m_stateCache = stateCache;
    }

    protected RemoteOpLockDetails(ClusterNode clNode, OpLockDetails localOpLock, ClusterFileStateCache stateCache) {
        this.m_ownerName = clNode.getName();
        this.m_lockType = localOpLock.getLockType();
        this.m_path = localOpLock.getPath();
        this.m_stateCache = stateCache;
    }

    protected RemoteOpLockDetails(String ownerName, int lockTyp, String path, ClusterFileStateCache stateCache) {
        this.m_ownerName = ownerName;
        this.m_lockType = lockTyp;
        this.m_path = path;
        this.m_stateCache = stateCache;
    }

    public int getLockType() {
        return this.m_lockType;
    }

    public final String getOwnerName() {
        return this.m_ownerName;
    }

    public String getPath() {
        return this.m_path;
    }

    public boolean isRemoteLock() {
        return true;
    }

    public void requestOpLockBreak() throws IOException {
        throw new IOException("Attempt to break remote oplock, owner=" + this.getOwnerName() + ", type=" + OpLock.getTypeAsString(this.getLockType()));
    }

    public SMBSrvSession getDeferredSession() {
        PerNodeState perNode;
        SMBSrvSession sess = null;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this.getPath(), false)) != null) {
            sess = perNode.getDeferredSession();
        }
        return sess;
    }

    public SMBSrvPacket getDeferredPacket() {
        PerNodeState perNode;
        SMBSrvPacket pkt = null;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this.getPath(), false)) != null) {
            pkt = perNode.getDeferredPacket();
        }
        return pkt;
    }

    public long getOplockBreakTime() {
        PerNodeState perNode;
        long breakTime = 0L;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this.getPath(), true)) != null) {
            breakTime = perNode.getOplockBreakTime();
        }
        return breakTime;
    }

    public boolean hasOplockBreakFailed() {
        return false;
    }

    public void setDeferredSession(SMBSrvSession deferredSess, SMBSrvPacket deferredPkt) throws DeferFailedException {
        PerNodeState perNode;
        if (this.getStateCache() != null) {
            perNode = this.getStateCache().getPerNodeState(this.getPath(), true);
            if (perNode == null) {
                throw new RuntimeException("PerNode is null oplock=" + this);
            }
        } else {
            throw new RuntimeException("Remote oplock does not have stateCache, oplock=" + this);
        }
        perNode.setDeferredSession(deferredSess);
        perNode.setDeferredPacket(deferredPkt);
    }

    public void clearDeferredSession() {
        if (this.getStateCache() != null) {
            PerNodeState perNode = this.getStateCache().getPerNodeState(this.getPath(), false);
            if (perNode != null) {
                perNode.setDeferredSession(null);
                perNode.setDeferredPacket(null);
            }
        } else {
            throw new RuntimeException("Remote oplock does not have stateCache, oplock=" + this);
        }
    }

    public void setOplockBreakFailed() {
    }

    public final ClusterFileStateCache getStateCache() {
        return this.m_stateCache;
    }

    public final void setStateCache(ClusterFileStateCache stateCache) {
        this.m_stateCache = stateCache;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Remote Owner=");
        str.append(this.getOwnerName());
        str.append(",type=");
        str.append(OpLock.getTypeAsString(this.getLockType()));
        if (this.getStateCache() == null) {
            str.append(",stateCache=null");
        }
        str.append("]");
        return str.toString();
    }
}

