/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IMap;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteCacheTask<T>
implements Callable<T>,
HazelcastInstanceAware,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TaskDebug = 1;
    public static final int TaskTiming = 2;
    private String m_mapName;
    private String m_keyName;
    private transient HazelcastInstance m_hcInstance;
    private short m_taskOptions;
    private transient String m_taskName;

    public RemoteCacheTask() {
    }

    public RemoteCacheTask(String mapName, String key, int options) {
        this.m_mapName = mapName;
        this.m_keyName = key;
        this.m_taskOptions = (short)options;
    }

    public RemoteCacheTask(String mapName, String key, boolean debug, boolean timingDebug) {
        this.m_mapName = mapName;
        this.m_keyName = key;
        if (debug) {
            this.m_taskOptions = (short)(this.m_taskOptions + 1);
        }
        if (timingDebug) {
            this.m_taskOptions = (short)(this.m_taskOptions + 2);
        }
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.m_hcInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hcInstance) {
        this.m_hcInstance = hcInstance;
    }

    public final String getMapName() {
        return this.m_mapName;
    }

    public final String getKey() {
        return this.m_keyName;
    }

    public final boolean hasOption(int option) {
        return (this.m_taskOptions & option) != 0;
    }

    public final boolean hasDebug() {
        return this.hasOption(1);
    }

    public final boolean hasTimingDebug() {
        return this.hasOption(2);
    }

    public final String getTaskName() {
        if (this.m_taskName == null) {
            this.m_taskName = this.getClass().getSimpleName();
        }
        return this.m_taskName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public T call() throws Exception {
        IMap cache;
        long startTime = 0L;
        if (this.hasTimingDebug()) {
            startTime = System.currentTimeMillis();
        }
        if ((cache = this.getHazelcastInstance().getMap(this.getMapName())) == null) {
            throw new Exception("Failed to find clustered map " + this.getMapName());
        }
        T retVal = null;
        try {
            retVal = this.runRemoteTask((IMap<String, ClusterFileState>)cache, this.getKey());
            Object var6_4 = null;
            if (!this.hasTimingDebug()) return retVal;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!this.hasTimingDebug()) throw throwable;
            Debug.println("Remote task executed in " + (System.currentTimeMillis() - startTime) + "ms");
            throw throwable;
        }
        Debug.println("Remote task executed in " + (System.currentTimeMillis() - startTime) + "ms");
        return retVal;
    }

    protected abstract T runRemoteTask(IMap<String, ClusterFileState> var1, String var2) throws Exception;
}

