/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.FileAccessToken;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;
import org.alfresco.jlan.server.filesys.cache.hazelcast.HazelCastAccessToken;
import org.alfresco.jlan.server.filesys.cache.hazelcast.OpLockMessage;
import org.alfresco.jlan.server.filesys.cache.hazelcast.RemoteStateTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseFileAccessTask
extends RemoteStateTask<Integer> {
    private static final long serialVersionUID = 1L;
    private FileAccessToken m_token;
    private String m_clusterTopic;

    public ReleaseFileAccessTask() {
    }

    public ReleaseFileAccessTask(String mapName, String key, FileAccessToken token, String clusterTopic, boolean debug, boolean timingDebug) {
        super(mapName, key, true, false, debug, timingDebug);
        this.m_token = token;
    }

    @Override
    protected Integer runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        int openCount;
        if (this.hasDebug()) {
            Debug.println("ReleaseFileAccessTask: Release token=" + this.m_token + " path " + fState);
        }
        if ((openCount = fState.decrementOpenCount()) == 0) {
            fState.setSharedAccess(7);
            fState.setPrimaryOwner(null);
        }
        if (this.m_token instanceof HazelCastAccessToken) {
            HazelCastAccessToken hcToken = (HazelCastAccessToken)this.m_token;
            if (fState.hasOpLock() && hcToken.getOpLockType() != 0) {
                fState.clearOpLock();
                ITopic clusterTopic = this.getHazelcastInstance().getTopic(this.m_clusterTopic);
                OpLockMessage oplockMsg = new OpLockMessage("*", 2, fState.getPath());
                clusterTopic.publish((Object)oplockMsg);
                if (this.hasDebug()) {
                    Debug.println("Cleared remote oplock during token release");
                }
            }
        }
        return new Integer(openCount);
    }
}

