/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.ExistingOpLockException;
import org.alfresco.jlan.server.filesys.FileAccessToken;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileSharingException;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;
import org.alfresco.jlan.server.filesys.cache.hazelcast.GrantAccessParams;
import org.alfresco.jlan.server.filesys.cache.hazelcast.HazelCastAccessToken;
import org.alfresco.jlan.server.filesys.cache.hazelcast.RemoteOpLockDetails;
import org.alfresco.jlan.server.filesys.cache.hazelcast.RemoteStateTask;
import org.alfresco.jlan.smb.OpLock;
import org.alfresco.jlan.smb.SharingMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrantFileAccessTask
extends RemoteStateTask<FileAccessToken> {
    private static final long serialVersionUID = 1L;
    private GrantAccessParams m_params;

    public GrantFileAccessTask() {
    }

    public GrantFileAccessTask(String mapName, String key, GrantAccessParams params, boolean debug, boolean timingDebug) {
        super(mapName, key, true, false, debug, timingDebug);
        this.m_params = params;
    }

    @Override
    protected FileAccessToken runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        if (this.hasDebug()) {
            Debug.println("GrantFileAccessTask: Open params=" + this.m_params + " path " + fState);
        }
        boolean nosharing = false;
        int grantedOplock = 0;
        boolean oplockNotAvailable = false;
        String noshrReason = null;
        if (fState.getOpenCount() > 0) {
            String curPrimaryOwner = (String)fState.getPrimaryOwner();
            if (this.hasDebug()) {
                Debug.println("File already open by " + curPrimaryOwner + ", pid=" + fState.getProcessId() + ", sharingMode=" + SharingMode.getSharingModeAsString(fState.getSharedAccess()));
            }
            if (this.m_params.getOpenAction() == 2) {
                throw new FileExistsException();
            }
            if (this.m_params.getSecurityLevel() == 2 && this.m_params.getProcessId() == fState.getProcessId() && curPrimaryOwner.equalsIgnoreCase(this.m_params.getOwnerName())) {
                nosharing = false;
            } else if (this.m_params.isReadOnlyAccess() && (fState.getSharedAccess() & 1) != 0) {
                nosharing = false;
            } else if ((this.m_params.isReadWriteAccess() || this.m_params.isWriteOnlyAccess()) && (fState.getSharedAccess() & 2) == 0) {
                nosharing = true;
                noshrReason = "Sharing mode disallows write";
                if (this.hasDebug()) {
                    Debug.println("Sharing mode disallows write access path=" + fState.getPath());
                }
            } else if (fState.getSharedAccess() == 0) {
                nosharing = true;
                noshrReason = "Sharing mode exclusive";
            } else if ((fState.getSharedAccess() & this.m_params.getSharedAccess()) != this.m_params.getSharedAccess()) {
                nosharing = true;
                noshrReason = "Sharing mode mismatch";
                if (this.hasDebug()) {
                    Debug.println("Local share mode=0x" + Integer.toHexString(fState.getSharedAccess()) + ", params share mode=0x" + Integer.toHexString(this.m_params.getSharedAccess()));
                }
            } else if (this.m_params.getSharedAccess() == 0) {
                nosharing = true;
                noshrReason = "Requestor wants exclusive mode";
            }
            oplockNotAvailable = true;
        } else if (this.m_params.hasOpLockRequest() && !this.m_params.isDirectory()) {
            grantedOplock = this.m_params.getOpLockType();
            if (this.hasDebug()) {
                Debug.println("Granted oplock type=" + OpLock.getTypeAsString(grantedOplock));
            }
        }
        if (nosharing) {
            throw new FileSharingException("File sharing violation, reason " + noshrReason);
        }
        fState.setSharedAccess(this.m_params.getSharedAccess());
        fState.setProcessId(this.m_params.getProcessId());
        fState.setPrimaryOwner(this.m_params.getOwnerName());
        if (grantedOplock != 0) {
            try {
                RemoteOpLockDetails remoteOplock = new RemoteOpLockDetails(this.m_params.getOwnerName(), grantedOplock, fState.getPath(), null);
                fState.setOpLock(remoteOplock);
            }
            catch (ExistingOpLockException ex) {
                if (this.hasDebug()) {
                    Debug.println("Failed to set oplock on " + fState + ", existing oplock=" + fState.getOpLock());
                }
                grantedOplock = 0;
                oplockNotAvailable = true;
            }
        }
        fState.incrementOpenCount();
        if (this.m_params.getFileStatus() != -1) {
            fState.setFileStatusInternal(this.m_params.getFileStatus(), 0);
        }
        return new HazelCastAccessToken(this.m_params.getOwnerName(), this.m_params.getProcessId(), grantedOplock, oplockNotAvailable);
    }
}

