/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import java.io.Serializable;
import org.alfresco.jlan.server.filesys.FileAction;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.FileStatus;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterNode;
import org.alfresco.jlan.smb.OpLock;

public class GrantAccessParams
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String m_ownerName;
    private int m_pid;
    private int m_fileSts;
    private int m_accessMode;
    private int m_sharedAccess;
    private int m_secLevel;
    private int m_createOptions;
    private int m_openAction;
    private int m_oplock = 0;

    public GrantAccessParams() {
    }

    public GrantAccessParams(ClusterNode clNode, FileOpenParams openParams, int fileSts) {
        this.m_ownerName = clNode.getName();
        this.m_fileSts = fileSts;
        this.m_pid = openParams.getProcessId();
        this.m_accessMode = openParams.getAccessMode();
        this.m_sharedAccess = openParams.getSharedAccess();
        this.m_secLevel = openParams.getSecurityLevel();
        this.m_createOptions = openParams.getCreateOptions();
        this.m_openAction = openParams.getOpenAction();
        if (openParams.requestBatchOpLock()) {
            this.m_oplock = 2;
        } else if (openParams.requestExclusiveOpLock()) {
            this.m_oplock = 1;
        }
    }

    public final String getOwnerName() {
        return this.m_ownerName;
    }

    public final int getFileStatus() {
        return this.m_fileSts;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public final int getSharedAccess() {
        return this.m_sharedAccess;
    }

    public final int getOpenAction() {
        return this.m_openAction;
    }

    public final boolean hasSecurityLevel() {
        return this.m_secLevel != -1;
    }

    public final int getSecurityLevel() {
        return this.m_secLevel;
    }

    public final boolean isReadOnlyAccess() {
        return (this.m_accessMode & 3) == 1;
    }

    public final boolean isWriteOnlyAccess() {
        return (this.m_accessMode & 3) == 2;
    }

    public final boolean isReadWriteAccess() {
        return (this.m_accessMode & 3) == 3;
    }

    public final boolean isAttributesOnlyAccess() {
        return (this.m_accessMode & 7) == 0 && (this.m_accessMode & 0x180) != 0;
    }

    public final int getAccessMode() {
        return this.m_accessMode;
    }

    public final boolean hasOpLockRequest() {
        return this.m_oplock != 0;
    }

    public final int getOpLockType() {
        return this.m_oplock;
    }

    public final boolean isDirectory() {
        return this.hasCreateOption(1) || this.getFileStatus() == 2;
    }

    protected final boolean hasCreateOption(int flag) {
        return (this.m_createOptions & flag) != 0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Owner=");
        str.append(this.getOwnerName());
        str.append(",pid=");
        str.append(this.getProcessId());
        str.append(",fileSts=");
        if (this.getFileStatus() != -1) {
            str.append(FileStatus.asString(this.getFileStatus()));
        } else {
            str.append("Unknown");
        }
        str.append(",openAction=");
        str.append(FileAction.asString(this.getOpenAction()));
        str.append(",create=0x");
        str.append(Integer.toHexString(this.m_createOptions));
        str.append(",access=0x");
        str.append(Integer.toHexString(this.getAccessMode()));
        str.append(",sharing=0x");
        str.append(Integer.toHexString(this.getSharedAccess()));
        str.append(",secLevel=");
        str.append(this.getSecurityLevel());
        str.append(",oplock=");
        str.append(OpLock.getTypeAsString(this.getOpLockType()));
        if (this.isDirectory()) {
            str.append(" DIR");
        }
        str.append("]");
        return str.toString();
    }
}

