/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterNode;
import org.alfresco.jlan.server.filesys.cache.hazelcast.RemoteStateTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDataUpdateTask
extends RemoteStateTask<Boolean> {
    private static final long serialVersionUID = 1L;
    private String m_updateNode;
    private boolean m_startUpdate;

    public FileDataUpdateTask() {
    }

    public FileDataUpdateTask(String mapName, String key, ClusterNode node, boolean startUpdate, boolean debug, boolean timingDebug) {
        super(mapName, key, true, false, debug, timingDebug);
        this.m_updateNode = node.getName();
        this.m_startUpdate = startUpdate;
    }

    @Override
    protected Boolean runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        if (this.hasDebug()) {
            Debug.println("FileDataUpdateTask: Update on node " + this.m_updateNode + " " + (this.m_startUpdate ? "started" : "completed") + " on " + fState);
        }
        boolean updSts = false;
        if (this.m_startUpdate) {
            if (fState.hasDataUpdateInProgress()) {
                if (this.hasDebug()) {
                    Debug.println("Existing data update on state=" + fState);
                }
            } else {
                fState.setDataUpdateNode(this.m_updateNode);
                updSts = true;
                if (this.hasDebug()) {
                    Debug.println("File data update start on node=" + this.m_updateNode + ", state=" + fState);
                }
            }
        } else if (fState.hasDataUpdateInProgress()) {
            if (!fState.getDataUpdateNode().equals(this.m_updateNode)) {
                if (this.hasDebug()) {
                    Debug.println("Update is not the requesting node, node=" + this.m_updateNode + ", update=" + fState.getDataUpdateNode());
                }
            } else {
                fState.setDataUpdateNode(null);
                updSts = true;
                if (this.hasDebug()) {
                    Debug.println("File data update complete on node=" + this.m_updateNode + ", state=" + fState);
                }
            }
        }
        return new Boolean(updSts);
    }
}

