/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import java.io.Serializable;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterNode;
import org.alfresco.jlan.server.filesys.cache.hazelcast.ClusterMessageType;

public class ClusterMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String AllNodes = "*";
    private String m_targetNode;
    private String m_fromNode;
    private int m_msgType;

    ClusterMessage() {
    }

    public ClusterMessage(String targetNode, int msgType) {
        this.m_targetNode = targetNode;
        this.m_msgType = msgType;
    }

    public ClusterMessage(String targetNode, String fromNode, int msgType) {
        this.m_targetNode = targetNode;
        this.m_fromNode = fromNode;
        this.m_msgType = msgType;
    }

    public ClusterMessage(String targetNode, ClusterNode fromNode, int msgType) {
        this.m_targetNode = targetNode;
        if (fromNode != null) {
            this.m_fromNode = fromNode.getName();
        }
        this.m_msgType = msgType;
    }

    public final String getTargetNode() {
        return this.m_targetNode;
    }

    public final boolean isAllNodes() {
        return this.m_targetNode.equals(AllNodes);
    }

    public final int isType() {
        return this.m_msgType;
    }

    public final boolean hasFromNode() {
        return this.m_fromNode != null && this.m_fromNode.length() > 0;
    }

    public final String getFromNode() {
        return this.m_fromNode;
    }

    public final boolean isFromLocalNode(ClusterNode localNode) {
        return this.m_fromNode != null && this.m_fromNode.equals(localNode.getName());
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Target=");
        if (this.isAllNodes()) {
            str.append("All");
        } else {
            str.append(this.getTargetNode());
        }
        if (this.hasFromNode()) {
            str.append(",from=");
            str.append(this.getFromNode());
        }
        str.append(",type=");
        str.append(ClusterMessageType.getTypeAsString(this.isType()));
        str.append("]");
        return str.toString();
    }
}

