/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.FileNotFoundException;
import org.alfresco.jlan.server.config.ConfigSection;
import org.alfresco.jlan.server.config.ServerConfiguration;

public class ClusterConfigSection
extends ConfigSection {
    public static final String SectionName = "HazelcastCluster";
    private String m_configFile;
    private HazelcastInstance m_hazelcastInstance;

    public ClusterConfigSection(ServerConfiguration config) {
        super(SectionName, config);
    }

    public String getConfigFile() {
        return this.m_configFile;
    }

    public void setConfigFile(String path) {
        this.m_configFile = path;
    }

    public synchronized HazelcastInstance getHazelcastInstance() throws FileNotFoundException {
        if (this.m_hazelcastInstance == null) {
            FileSystemXmlConfig hcConfig = new FileSystemXmlConfig(this.getConfigFile());
            this.m_hazelcastInstance = Hazelcast.newHazelcastInstance((Config)hcConfig);
        }
        return this.m_hazelcastInstance;
    }

    public void closeConfig() {
        if (this.m_hazelcastInstance != null) {
            this.m_hazelcastInstance = null;
            Hazelcast.shutdownAll();
        }
    }
}

