/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileLock;
import org.alfresco.jlan.server.filesys.cache.cluster.ClusterFileState;
import org.alfresco.jlan.server.filesys.cache.hazelcast.RemoteStateTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckFileByteLockTask
extends RemoteStateTask<Boolean> {
    private static final long serialVersionUID = 1L;
    private ClusterFileLock m_lockCheck;
    private boolean m_writeCheck;

    public CheckFileByteLockTask() {
    }

    public CheckFileByteLockTask(String mapName, String key, ClusterFileLock lockCheck, boolean writeCheck, boolean debug, boolean timingDebug) {
        super(mapName, key, true, false, debug, timingDebug);
        this.m_lockCheck = lockCheck;
        this.m_writeCheck = writeCheck;
    }

    @Override
    protected Boolean runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        if (this.hasDebug()) {
            Debug.println("CheckFileByteLockTask: checkArea=" + this.m_lockCheck + (this.m_writeCheck ? " (Write)" : " (Read)") + " on " + fState);
        }
        boolean accessOK = true;
        if (fState.hasActiveLocks()) {
            accessOK = this.m_writeCheck ? fState.getLockList().canWriteFile(this.m_lockCheck) : fState.getLockList().canReadFile(this.m_lockCheck);
        }
        return accessOK;
    }
}

