/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache.cluster;

import java.util.HashMap;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.ExistingOpLockException;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileList;
import org.alfresco.jlan.server.locking.LocalOpLockDetails;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerNodeState {
    private int m_fileId = -1;
    private int m_dataStatus = 0;
    private HashMap<String, Object> m_cache;
    private PseudoFileList m_pseudoFiles;
    private Object m_filesysObj;
    private LocalOpLockDetails m_localOpLock;
    private SMBSrvSession m_sess;
    private SMBSrvPacket m_pkt;
    private long m_oplockBreakTime;

    public int getFileId() {
        return this.m_fileId;
    }

    public int getDataStatus() {
        return this.m_dataStatus;
    }

    public void setFileId(int id) {
        this.m_fileId = id;
    }

    public void setDataStatus(int sts) {
        this.m_dataStatus = sts;
    }

    public boolean hasPseudoFiles() {
        if (this.m_pseudoFiles != null) {
            return this.m_pseudoFiles.numberOfFiles() > 0;
        }
        return false;
    }

    protected PseudoFileList getPseudoFileList(boolean createList) {
        if (this.m_pseudoFiles == null && createList) {
            this.m_pseudoFiles = new PseudoFileList();
        }
        return this.m_pseudoFiles;
    }

    public Object getFilesystemObject() {
        return this.m_filesysObj;
    }

    public void setFilesystemObject(Object filesysObj) {
        this.m_filesysObj = filesysObj;
    }

    protected HashMap<String, Object> getAttributeMap(boolean createMap) {
        if (this.m_cache == null && createMap) {
            this.m_cache = new HashMap();
        }
        return this.m_cache;
    }

    public final void remoteAllAttributes() {
        if (this.m_cache != null) {
            this.m_cache.clear();
            this.m_cache = null;
        }
    }

    public boolean hasOpLock() {
        return this.m_localOpLock != null;
    }

    public LocalOpLockDetails getOpLock() {
        return this.m_localOpLock;
    }

    public synchronized void setOpLock(LocalOpLockDetails oplock) throws ExistingOpLockException {
        if (this.m_localOpLock != null) {
            throw new ExistingOpLockException();
        }
        this.m_localOpLock = oplock;
    }

    public synchronized void clearOpLock() {
        this.m_localOpLock = null;
        if (this.hasDeferredSession()) {
            Debug.println("%%% PerNodeState.clearOpLock() with deferred session/packet");
            Thread.dumpStack();
        }
    }

    public final boolean hasDeferredSession() {
        return this.m_sess != null;
    }

    public final SMBSrvSession getDeferredSession() {
        return this.m_sess;
    }

    public final SMBSrvPacket getDeferredPacket() {
        return this.m_pkt;
    }

    public final void setDeferredSession(SMBSrvSession sess) {
        this.m_sess = sess;
    }

    public final void setDeferredPacket(SMBSrvPacket pkt) {
        this.m_pkt = pkt;
    }

    public final void clearDeferredSession() {
        this.m_sess = null;
        this.m_pkt = null;
    }

    public final long getOplockBreakTime() {
        return this.m_oplockBreakTime;
    }

    public final void setOplockBreakStartTime() {
        this.m_oplockBreakTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[FID=");
        str.append(this.getFileId());
        str.append(",data=");
        str.append(this.getDataStatus());
        str.append(",filesysObj=");
        str.append(this.getFilesystemObject());
        str.append(",oplock=");
        str.append(this.getOpLock());
        if (this.getDeferredSession() != null) {
            str.append(",deferSess=");
            str.append(this.getDeferredSession().getUniqueId());
            str.append(", deferPkt=");
            str.append(this.getDeferredPacket());
        }
        str.append("]");
        return str.toString();
    }
}

