/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache;

import java.io.IOException;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.locking.FileLock;
import org.alfresco.jlan.locking.LockConflictException;
import org.alfresco.jlan.locking.NotLockedException;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DeferFailedException;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.ExistingOpLockException;
import org.alfresco.jlan.server.filesys.FileAccessToken;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.FileSharingException;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCacheListener;
import org.alfresco.jlan.server.filesys.cache.FileStateListener;
import org.alfresco.jlan.server.filesys.cache.FileStateProxy;
import org.alfresco.jlan.server.filesys.cache.LocalFileAccessToken;
import org.alfresco.jlan.server.filesys.cache.LocalFileStateProxy;
import org.alfresco.jlan.server.locking.OpLockDetails;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.springframework.extensions.config.ConfigElement;

public abstract class FileStateCache {
    protected static final long DefaultExpireCheckInterval = 60000L;
    protected static final long MinimumExpireCheckInterval = 5000L;
    protected static final long DefaultFileStateExpireInterval = 300000L;
    protected static final long MinimumFileStateExpireInterval = 15000L;
    private long m_expireCheckInterval = 60000L;
    private long m_fileStateExpireInterval = 300000L;
    private FileStateListener m_stateListener;
    private FileStateCacheListener m_cacheListener;
    private boolean m_caseSensitive = true;
    private boolean m_debug = false;
    private boolean m_debugExpired = false;

    public final long getCheckInterval() {
        return this.m_expireCheckInterval;
    }

    public final long getFileStateExpireInterval() {
        return this.m_fileStateExpireInterval;
    }

    public final boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public boolean isClusteredCache() {
        return false;
    }

    public final void setFileStateExpireInterval(long tmo) {
        this.m_fileStateExpireInterval = tmo;
    }

    public final void setCheckInterval(long chkIntval) {
        this.m_expireCheckInterval = chkIntval;
    }

    public final void setCaseSensitive(boolean caseSensitive) {
        this.m_caseSensitive = caseSensitive;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final boolean hasDebugExpiredStates() {
        return this.m_debugExpired;
    }

    public final void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }

    public final void setDebugExpiredStates(boolean dbg) {
        this.m_debugExpired = dbg;
    }

    public final void addStateListener(FileStateListener l) {
        this.m_stateListener = l;
    }

    public final void removeStateListener(FileStateListener l) {
        if (this.m_stateListener == l) {
            this.m_stateListener = null;
        }
    }

    public final boolean hasStateListener() {
        return this.m_stateListener != null;
    }

    protected final FileStateListener getStateListener() {
        return this.m_stateListener;
    }

    public final void addStateCacheListener(FileStateCacheListener l) {
        this.m_cacheListener = l;
    }

    public final void removeStateCacheListener(FileStateCacheListener l) {
        if (this.m_cacheListener == l) {
            this.m_cacheListener = null;
        }
    }

    public final boolean hasStateCacheListener() {
        return this.m_cacheListener != null;
    }

    protected final FileStateCacheListener getStateCacheListener() {
        return this.m_cacheListener;
    }

    public abstract int numberOfStates();

    public FileStateProxy getFileStateProxy(FileState fstate) {
        return new LocalFileStateProxy(fstate);
    }

    public abstract FileState findFileState(String var1);

    public abstract FileState findFileState(String var1, boolean var2);

    public abstract FileState findFileState(String var1, boolean var2, int var3);

    public abstract FileState removeFileState(String var1);

    public abstract void renameFileState(String var1, FileState var2, boolean var3);

    public abstract void removeAllFileStates();

    public abstract int removeExpiredFileStates();

    public abstract void dumpCache(boolean var1);

    public OpLockDetails getOpLock(FileState fstate) {
        return fstate.getOpLock();
    }

    public boolean addOpLock(FileState fstate, OpLockDetails oplock, NetworkFile netFile) throws ExistingOpLockException {
        if (fstate.getOpenCount() != 1) {
            return false;
        }
        fstate.setOpLock(oplock);
        return true;
    }

    public void clearOpLock(FileState fstate) {
        fstate.clearOpLock();
    }

    public void requestOplockBreak(String path, OpLockDetails oplock, SMBSrvSession sess, SMBSrvPacket pkt) throws IOException, DeferFailedException {
        oplock.setDeferredSession(sess, pkt);
        oplock.requestOpLockBreak();
    }

    public FileLock createFileLockObject(NetworkFile file, long offset, long len, int pid) {
        return new FileLock(offset, len, pid);
    }

    public boolean hasActiveLocks(FileState fstate) {
        return fstate.hasActiveLocks();
    }

    public void addLock(FileState fstate, FileLock lock) throws LockConflictException {
        fstate.addLock(lock);
    }

    public void removeLock(FileState fstate, FileLock lock) throws NotLockedException {
        fstate.removeLock(lock);
    }

    public void initializeCache(ConfigElement config, ServerConfiguration srvConfig) throws InvalidConfigurationException {
        ConfigElement elem = config.getChild("fileStateExpire");
        if (elem != null && elem.getValue() != null) {
            long stateExpire = 0L;
            try {
                stateExpire = Long.parseLong(elem.getValue()) * 1000L;
                if (stateExpire < 15000L) {
                    throw new InvalidConfigurationException("File state expiry interval too low, " + elem.getValue());
                }
                this.setFileStateExpireInterval(stateExpire);
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid file state expiry interval, " + elem.getValue());
            }
        }
        if ((elem = config.getChild("cacheCheckInterval")) != null && elem.getValue() != null) {
            long checkInterval = 0L;
            try {
                checkInterval = Long.parseLong(elem.getValue()) * 1000L;
                if (checkInterval < 5000L) {
                    throw new InvalidConfigurationException("Cache check interval too low, " + elem.getValue());
                }
                this.setCheckInterval(checkInterval);
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid cache check interval, " + elem.getValue());
            }
        }
        if (config.getChild("Debug") != null) {
            this.setDebug(true);
        }
        if (config.getChild("expiryDebug") != null) {
            this.setDebugExpiredStates(true);
        }
    }

    public void setDriverDetails(DiskSharedDevice diskDev) {
    }

    public void stateCacheStarted() {
        if (this.hasStateCacheListener()) {
            this.getStateCacheListener().stateCacheRunning();
        }
    }

    public void stateCacheShuttingDown() {
        if (this.hasStateCacheListener()) {
            this.getStateCacheListener().stateCacheShuttingDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileAccessToken grantFileAccess(FileOpenParams params, FileState fstate, int fileSts) throws FileSharingException, AccessDeniedException, FileExistsException {
        FileState fileState = fstate;
        synchronized (fileState) {
            boolean nosharing = false;
            String noshrReason = null;
            if (fstate.getOpenCount() > 0) {
                if (params.getOpenAction() == 2) {
                    throw new FileExistsException(params.getFullPath());
                }
                if (params.getSecurityLevel() == 2 && params.getProcessId() == fstate.getProcessId()) {
                    nosharing = false;
                } else if (params.isReadOnlyAccess() && (fstate.getSharedAccess() & 1) != 0) {
                    nosharing = false;
                } else if ((params.isReadWriteAccess() || params.isWriteOnlyAccess()) && (fstate.getSharedAccess() & 2) == 0) {
                    nosharing = true;
                    noshrReason = "Sharing mode disallows write";
                    if (this.hasDebug()) {
                        Debug.println("Sharing mode disallows write access path=" + params.getPath());
                    }
                } else if (fstate.getSharedAccess() == 0) {
                    nosharing = true;
                    noshrReason = "Sharing mode exclusive";
                } else if ((fstate.getSharedAccess() & params.getSharedAccess()) != params.getSharedAccess()) {
                    nosharing = true;
                    noshrReason = "Sharing mode mismatch";
                    if (this.hasDebug()) {
                        Debug.println("Local share mode=0x" + Integer.toHexString(fstate.getSharedAccess()) + ", params share mode=0x" + Integer.toHexString(params.getSharedAccess()));
                    }
                } else if (params.getSharedAccess() == 0) {
                    nosharing = true;
                    noshrReason = "Requestor wants exclusive mode";
                }
            }
            if (nosharing) {
                throw new FileSharingException("File sharing violation, reason " + noshrReason);
            }
            fstate.setSharedAccess(params.getSharedAccess());
            fstate.setProcessId(params.getProcessId());
            fstate.incrementOpenCount();
            if (fileSts != -1) {
                fstate.setFileStatus(fileSts);
            }
        }
        return new LocalFileAccessToken(params.getProcessId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int releaseFileAccess(FileState fstate, FileAccessToken token) {
        int openCount = -1;
        FileState fileState = fstate;
        synchronized (fileState) {
            openCount = fstate.decrementOpenCount();
            if (openCount == 0) {
                fstate.setSharedAccess(7);
            }
        }
        return openCount;
    }

    public void setDataUpdateInProgress(FileState fstate) {
    }

    public void setDataUpdateCompleted(FileState fstate) {
    }
}

