/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys;

import java.util.Date;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.smb.SMBDate;

public class FileInfo {
    public static final int SetFileSize = 1;
    public static final int SetAllocationSize = 2;
    public static final int SetAttributes = 4;
    public static final int SetModifyDate = 8;
    public static final int SetCreationDate = 16;
    public static final int SetAccessDate = 32;
    public static final int SetChangeDate = 64;
    public static final int SetGid = 128;
    public static final int SetUid = 256;
    public static final int SetMode = 512;
    public static final int SetDeleteOnClose = 1024;
    protected String m_name;
    protected String m_shortName;
    protected String m_path;
    protected long m_size;
    protected int m_attr = -1;
    private long m_modifyDate;
    private long m_createDate;
    private long m_accessDate;
    private long m_changeDate;
    private long m_allocSize;
    private int m_fileId = -1;
    private int m_dirId = -1;
    private int m_gid = -1;
    private int m_uid = -1;
    private int m_mode = -1;
    private int m_fileType;
    private boolean m_deleteOnClose;
    private int m_setFlags;
    private NetworkFile m_netFile;

    public FileInfo() {
    }

    public FileInfo(String fname, long fsize, int fattr) {
        this.m_name = fname;
        this.m_size = fsize;
        this.m_attr = fattr;
        this.setAllocationSize(0L);
        if (this.isDirectory()) {
            this.setFileType(2);
        } else {
            this.setFileType(1);
        }
    }

    public FileInfo(String fname, long fsize, int fattr, int ftime) {
        this.m_name = fname;
        this.m_size = fsize;
        this.m_attr = fattr;
        this.m_modifyDate = new SMBDate(ftime).getTime();
        this.setAllocationSize(0L);
        if (this.isDirectory()) {
            this.setFileType(2);
        } else {
            this.setFileType(1);
        }
    }

    public FileInfo(String fname, long fsize, int fattr, int fdate, int ftime) {
        this.m_name = fname;
        this.m_size = fsize;
        this.m_attr = fattr;
        if (fdate != 0 && ftime != 0) {
            this.m_modifyDate = new SMBDate(fdate, ftime).getTime();
        }
        this.setAllocationSize(0L);
        if (this.isDirectory()) {
            this.setFileType(2);
        } else {
            this.setFileType(1);
        }
    }

    public FileInfo(String fpath, String fname, long fsize, int fattr) {
        this.m_path = fpath;
        this.m_name = fname;
        this.m_size = fsize;
        this.m_attr = fattr;
        this.setAllocationSize(0L);
        if (this.isDirectory()) {
            this.setFileType(2);
        } else {
            this.setFileType(1);
        }
    }

    public FileInfo(String fpath, String fname, long fsize, int fattr, int ftime) {
        this.m_path = fpath;
        this.m_name = fname;
        this.m_size = fsize;
        this.m_attr = fattr;
        this.m_modifyDate = new SMBDate(ftime).getTime();
        this.setAllocationSize(0L);
        if (this.isDirectory()) {
            this.setFileType(2);
        } else {
            this.setFileType(1);
        }
    }

    public FileInfo(String fpath, String fname, long fsize, int fattr, int fdate, int ftime) {
        this.m_path = fpath;
        this.m_name = fname;
        this.m_size = fsize;
        this.m_attr = fattr;
        this.m_modifyDate = new SMBDate(fdate, ftime).getTime();
        this.setAllocationSize(0L);
        if (this.isDirectory()) {
            this.setFileType(2);
        } else {
            this.setFileType(1);
        }
    }

    public long getAccessDateTime() {
        return this.m_accessDate;
    }

    public long getAllocationSize() {
        return this.m_allocSize;
    }

    public int getAllocationSizeInt() {
        return (int)(this.m_allocSize & 0xFFFFFFFFL);
    }

    public long getChangeDateTime() {
        return this.m_changeDate;
    }

    public long getCreationDateTime() {
        return this.m_createDate;
    }

    public final boolean hasDeleteOnClose() {
        return this.m_deleteOnClose;
    }

    public int getFileAttributes() {
        return this.m_attr;
    }

    public final String getFileName() {
        return this.m_name;
    }

    public final boolean hasShortName() {
        return this.m_shortName != null;
    }

    public final String getShortName() {
        return this.m_shortName;
    }

    public final long getModifyDateTime() {
        return this.m_modifyDate;
    }

    public final String getPath() {
        return this.m_path;
    }

    public final long getSize() {
        return this.m_size;
    }

    public final int getSizeInt() {
        return (int)(this.m_size & 0xFFFFFFFFL);
    }

    public final int getFileId() {
        return this.m_fileId;
    }

    public final long getFileIdLong() {
        return (long)this.m_fileId & 0xFFFFFFFFL;
    }

    public final int getDirectoryId() {
        return this.m_dirId;
    }

    public final long getDirectoryIdLong() {
        return (long)this.m_dirId & 0xFFFFFFFFL;
    }

    public boolean hasAccessDateTime() {
        return this.m_accessDate != 0L;
    }

    public boolean hasChangeDateTime() {
        return this.m_changeDate != 0L;
    }

    public boolean hasCreationDateTime() {
        return this.m_createDate > 0L;
    }

    public boolean hasModifyDateTime() {
        return this.m_modifyDate > 0L;
    }

    public final boolean hasFileAttributes() {
        return this.m_attr != -1;
    }

    public final boolean hasAttribute(int attr) {
        return (this.m_attr & attr) != 0;
    }

    public final boolean isDirectory() {
        return (this.m_attr & 0x10) != 0;
    }

    public final boolean isHidden() {
        return (this.m_attr & 2) != 0;
    }

    public final boolean isReadOnly() {
        return (this.m_attr & 1) != 0;
    }

    public final boolean isSystem() {
        return (this.m_attr & 4) != 0;
    }

    public final boolean isArchived() {
        return (this.m_attr & 0x20) != 0;
    }

    public boolean isPseudoFile() {
        return false;
    }

    public final boolean hasGid() {
        return this.m_gid != -1;
    }

    public final int getGid() {
        return this.m_gid;
    }

    public final boolean hasUid() {
        return this.m_uid != -1;
    }

    public final int getUid() {
        return this.m_uid;
    }

    public final boolean hasMode() {
        return this.m_mode != -1;
    }

    public final int getMode() {
        return this.m_mode;
    }

    public final int isFileType() {
        return this.m_fileType;
    }

    public final void resetInfo() {
        this.m_name = "";
        this.m_path = null;
        this.m_size = 0L;
        this.m_allocSize = 0L;
        this.m_attr = 0;
        this.m_accessDate = 0L;
        this.m_createDate = 0L;
        this.m_modifyDate = 0L;
        this.m_changeDate = 0L;
        this.m_fileId = -1;
        this.m_dirId = -1;
        this.m_gid = -1;
        this.m_uid = -1;
        this.m_mode = -1;
    }

    public final void copyFrom(FileInfo finfo) {
        this.m_name = finfo.getFileName();
        this.m_path = finfo.getPath();
        this.m_size = finfo.getSize();
        this.m_allocSize = finfo.getAllocationSize();
        this.m_attr = finfo.getFileAttributes();
        this.m_accessDate = finfo.getAccessDateTime();
        this.m_createDate = finfo.getCreationDateTime();
        this.m_modifyDate = finfo.getModifyDateTime();
        this.m_changeDate = finfo.getChangeDateTime();
        this.m_fileId = finfo.getFileId();
        this.m_dirId = finfo.getDirectoryId();
        this.m_gid = finfo.getGid();
        this.m_uid = finfo.getUid();
        this.m_mode = finfo.getMode();
        if (finfo.isDirectory()) {
            this.setFileType(2);
        } else {
            this.setFileType(1);
        }
    }

    public void setAccessDateTime(long timesec) {
        this.m_accessDate = timesec;
    }

    public void setAllocationSize(long siz) {
        this.m_allocSize = siz;
    }

    public void setChangeDateTime(long timesec) {
        this.m_changeDate = timesec;
    }

    public void setCreationDateTime(long timesec) {
        this.m_createDate = timesec;
    }

    public final void setDeleteOnClose(boolean del) {
        this.m_deleteOnClose = del;
    }

    public final void setFileAttributes(int attr) {
        this.m_attr = attr;
    }

    public final void setFileName(String name) {
        this.m_name = name;
    }

    public final void setFileSize(long siz) {
        this.m_size = siz;
    }

    public void setModifyDateTime(long timesec) {
        this.m_modifyDate = timesec;
    }

    public final void setFileId(int id) {
        this.m_fileId = id;
    }

    public final void setDirectoryId(int id) {
        this.m_dirId = id;
    }

    public final void setShortName(String name) {
        this.m_shortName = name;
    }

    public final void setPath(String path) {
        this.m_path = path;
    }

    public final void setSize(int siz) {
        this.m_size = siz;
    }

    public final void setSize(long siz) {
        this.m_size = siz;
    }

    public final void setGid(int id) {
        this.m_gid = id;
    }

    public final void setUid(int id) {
        this.m_uid = id;
    }

    public final void setMode(int mode) {
        this.m_mode = mode;
    }

    public final void setFileType(int typ) {
        this.m_fileType = typ;
    }

    public final void setFileInformationFlags(int setFlags) {
        this.m_setFlags = setFlags;
    }

    public final boolean hasSetFlag(int flag) {
        return (this.m_setFlags & flag) != 0;
    }

    public final int getSetFileInformationFlags() {
        return this.m_setFlags;
    }

    public final boolean hasNetworkFile() {
        return this.m_netFile != null;
    }

    public final NetworkFile getNetworkFile() {
        return this.m_netFile;
    }

    public final void setNetworkFile(NetworkFile netFile) {
        this.m_netFile = netFile;
    }

    public final String getSetFileInformationFlagsString() {
        StringBuilder str = new StringBuilder();
        if (this.hasSetFlag(1)) {
            str.append("Size,");
        }
        if (this.hasSetFlag(2)) {
            str.append("Alloc,");
        }
        if (this.hasSetFlag(4)) {
            str.append("Attr,");
        }
        if (this.hasSetFlag(8)) {
            str.append("Modify,");
        }
        if (this.hasSetFlag(16)) {
            str.append("Create,");
        }
        if (this.hasSetFlag(32)) {
            str.append("Access,");
        }
        if (this.hasSetFlag(64)) {
            str.append("Change,");
        }
        if (this.hasSetFlag(128)) {
            str.append("GID,");
        }
        if (this.hasSetFlag(256)) {
            str.append("UID,");
        }
        if (this.hasSetFlag(512)) {
            str.append("Mode,");
        }
        if (this.hasSetFlag(1024)) {
            str.append("Delete,");
        }
        if (str.length() > 0) {
            str.setLength(str.length() - 1);
        }
        return str.toString();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.m_path != null) {
            str.append(this.m_path);
            if (!this.m_path.endsWith("\\")) {
                str.append("\\");
            }
        }
        str.append(this.m_name);
        while (str.length() < 15) {
            str.append(" ");
        }
        if (this.isReadOnly()) {
            str.append("R");
        } else {
            str.append("-");
        }
        if (this.isHidden()) {
            str.append("H");
        } else {
            str.append("-");
        }
        if (this.isSystem()) {
            str.append("S");
        } else {
            str.append("-");
        }
        if (this.isDirectory()) {
            str.append("D");
        } else {
            str.append("-");
        }
        str.append(" ");
        str.append(this.m_size);
        while (str.length() < 30) {
            str.append(" ");
        }
        if (this.m_modifyDate != 0L) {
            str.append(" - ");
            str.append(new Date(this.m_modifyDate));
        }
        if (this.hasShortName()) {
            str.append(" (");
            str.append(this.getShortName());
            str.append(")");
        }
        return str.toString();
    }
}

