/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys;

import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.VolumeInfo;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.server.filesys.cache.FileStateCacheListener;
import org.alfresco.jlan.server.filesys.quota.QuotaManager;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.jlan.smb.server.notify.NotifyChangeHandler;
import org.alfresco.jlan.smb.server.notify.NotifyRequest;

public class DiskDeviceContext
extends DeviceContext {
    private NotifyChangeHandler m_changeHandler;
    private boolean m_filesysNotifications = true;
    private VolumeInfo m_volumeInfo;
    private SrvDiskInfo m_diskInfo;
    private QuotaManager m_quotaManager;
    private int m_filesysAttribs;
    private int m_deviceAttribs;
    private FileStateCache m_stateCache;
    private boolean m_requireStateCache;

    public DiskDeviceContext() {
    }

    public DiskDeviceContext(String devName) {
        super(devName);
    }

    public DiskDeviceContext(String devName, String shareName) {
        super(devName, shareName);
    }

    public final boolean hasVolumeInformation() {
        return this.m_volumeInfo != null;
    }

    public final VolumeInfo getVolumeInformation() {
        return this.m_volumeInfo;
    }

    public final boolean hasDiskInformation() {
        return this.m_diskInfo != null;
    }

    public final SrvDiskInfo getDiskInformation() {
        return this.m_diskInfo;
    }

    public final int getFilesystemAttributes() {
        return this.m_filesysAttribs;
    }

    public final int getDeviceAttributes() {
        return this.m_deviceAttribs;
    }

    public String getFilesystemType() {
        return "FAT";
    }

    public final boolean isCaseless() {
        return (this.m_filesysAttribs & 2) == 0;
    }

    public final boolean requiresStateCache() {
        return this.m_requireStateCache;
    }

    public final void enableChangeHandler(boolean ena) {
        if (ena) {
            this.m_changeHandler = new NotifyChangeHandler(this);
        } else {
            if (this.m_changeHandler != null) {
                this.m_changeHandler.shutdownRequest();
            }
            this.m_changeHandler = null;
        }
    }

    public void CloseContext() {
        super.CloseContext();
        if (this.hasChangeHandler()) {
            this.enableChangeHandler(false);
        }
    }

    public final boolean hasChangeHandler() {
        return this.m_changeHandler != null;
    }

    public final NotifyChangeHandler getChangeHandler() {
        return this.m_changeHandler;
    }

    public final boolean hasFileServerNotifications() {
        if (this.m_changeHandler == null) {
            return false;
        }
        return this.m_filesysNotifications;
    }

    public final void addNotifyRequest(NotifyRequest req) {
        this.m_changeHandler.addNotifyRequest(req);
    }

    public final void removeNotifyRequest(NotifyRequest req) {
        this.m_changeHandler.removeNotifyRequest(req);
    }

    public final void setVolumeInformation(VolumeInfo vol) {
        this.m_volumeInfo = vol;
    }

    public final void setDiskInformation(SrvDiskInfo disk) {
        this.m_diskInfo = disk;
    }

    public final boolean hasQuotaManager() {
        return this.m_quotaManager != null;
    }

    public final QuotaManager getQuotaManager() {
        return this.m_quotaManager;
    }

    public final void setQuotaManager(QuotaManager quotaMgr) {
        this.m_quotaManager = quotaMgr;
    }

    public final void setFilesystemAttributes(int attrib) {
        this.m_filesysAttribs = attrib;
    }

    public final void setDeviceAttributes(int attrib) {
        this.m_deviceAttribs = attrib;
    }

    public final void setFileServerNotifications(boolean ena) {
        this.m_filesysNotifications = ena;
    }

    public void startFilesystem(DiskSharedDevice share) throws DeviceContextException {
    }

    public final boolean hasStateCache() {
        return this.m_stateCache != null;
    }

    public final FileStateCache getStateCache() {
        return this.m_stateCache;
    }

    public final void setStateCache(FileStateCache stateCache) {
        this.m_stateCache = stateCache;
        if (this instanceof FileStateCacheListener) {
            this.m_stateCache.addStateCacheListener((FileStateCacheListener)((Object)this));
        }
    }

    public final void setRequiresStateCache(boolean reqStateCache) {
        this.m_requireStateCache = reqStateCache;
    }

    public LockManager getLockManager() {
        return null;
    }

    public OpLockManager getOpLockManager() {
        return null;
    }
}

