/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.passthru;

import org.alfresco.jlan.server.auth.passthru.DomainMapping;
import org.alfresco.jlan.util.IPAddress;

public class RangeDomainMapping
extends DomainMapping {
    private int m_rangeFrom;
    private int m_rangeTo;

    public RangeDomainMapping(String domain, int rangeFrom, int rangeTo) {
        super(domain);
        this.m_rangeFrom = rangeFrom;
        this.m_rangeTo = rangeTo;
    }

    public final int getRangeFrom() {
        return this.m_rangeFrom;
    }

    public final int getRangeTo() {
        return this.m_rangeTo;
    }

    public boolean isMemberOfDomain(int clientIP) {
        return clientIP >= this.m_rangeFrom && clientIP <= this.m_rangeTo;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getDomain());
        str.append(",");
        str.append(IPAddress.asString(this.getRangeFrom()));
        str.append(":");
        str.append(IPAddress.asString(this.getRangeTo()));
        str.append("]");
        return str.toString();
    }
}

