/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.acl;

import org.alfresco.jlan.server.auth.acl.ACLParseException;
import org.alfresco.jlan.server.auth.acl.AccessControl;
import org.alfresco.jlan.server.auth.acl.AccessControlParser;
import org.alfresco.jlan.server.auth.acl.UidAccessControl;
import org.springframework.extensions.config.ConfigElement;

public class UidAccessControlParser
extends AccessControlParser {
    public String getType() {
        return "uid";
    }

    public AccessControl createAccessControl(ConfigElement params) throws ACLParseException {
        int access = this.parseAccessType(params);
        String val = params.getAttribute("id");
        if (val == null || val.length() == 0) {
            throw new ACLParseException("User id not specified");
        }
        String userId = val.trim();
        int uid = -1;
        try {
            uid = Integer.parseInt(userId);
            if (uid < 0 || uid > 32768) {
                throw new ACLParseException("Invalid user id, out of valid range");
            }
        }
        catch (NumberFormatException ex) {
            throw new ACLParseException("User id not valid");
        }
        return new UidAccessControl(userId, uid, this.getType(), access);
    }
}

