/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.acl;

import java.util.Enumeration;
import java.util.List;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.acl.ACLParseException;
import org.alfresco.jlan.server.auth.acl.AccessControl;
import org.alfresco.jlan.server.auth.acl.AccessControlFactory;
import org.alfresco.jlan.server.auth.acl.AccessControlList;
import org.alfresco.jlan.server.auth.acl.AccessControlManager;
import org.alfresco.jlan.server.auth.acl.AccessControlParser;
import org.alfresco.jlan.server.auth.acl.DomainAccessControlParser;
import org.alfresco.jlan.server.auth.acl.GidAccessControlParser;
import org.alfresco.jlan.server.auth.acl.InvalidACLTypeException;
import org.alfresco.jlan.server.auth.acl.IpAddressAccessControlParser;
import org.alfresco.jlan.server.auth.acl.ProtocolAccessControlParser;
import org.alfresco.jlan.server.auth.acl.UidAccessControlParser;
import org.alfresco.jlan.server.auth.acl.UserAccessControlParser;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.springframework.extensions.config.ConfigElement;

public class DefaultAccessControlManager
implements AccessControlManager {
    private AccessControlFactory m_factory = new AccessControlFactory();
    private boolean m_debug;

    public int checkAccessControl(SrvSession sess, SharedDevice share) {
        if (!share.hasAccessControls()) {
            if (this.hasDebug()) {
                sess.debugPrintln("Check access control for " + share.getName() + ", no ACLs");
            }
            return 2;
        }
        AccessControlList acls = share.getAccessControls();
        int access = -1;
        if (this.hasDebug()) {
            sess.debugPrintln("Check access control for " + share.getName() + ", ACLs=" + acls.numberOfControls());
        }
        for (int i = 0; i < acls.numberOfControls(); ++i) {
            AccessControl acl = acls.getControlAt(i);
            int curAccess = acl.allowsAccess(sess, share, this);
            if (this.hasDebug()) {
                sess.debugPrintln("  Check access ACL=" + acl + ", access=" + AccessControl.asAccessString(curAccess));
            }
            if (curAccess == -1) continue;
            access = curAccess;
        }
        if (access == -1) {
            access = acls.getDefaultAccessLevel();
            if (this.hasDebug()) {
                sess.debugPrintln("Access defaulted=" + AccessControl.asAccessString(access) + ", share=" + share);
            }
        } else if (this.hasDebug()) {
            sess.debugPrintln("Access allowed=" + AccessControl.asAccessString(access) + ", share=" + share);
        }
        return access;
    }

    public SharedDeviceList filterShareList(SrvSession sess, SharedDeviceList shares) {
        if (shares == null || shares.numberOfShares() == 0) {
            return shares;
        }
        if (this.hasDebug()) {
            sess.debugPrintln("Filter share list for " + sess + ", shares=" + shares);
        }
        SharedDeviceList filterList = new SharedDeviceList();
        Enumeration<SharedDevice> enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice share = enm.nextElement();
            if (share.hasAccessControls()) {
                int access = this.checkAccessControl(sess, share);
                if (access == 0) continue;
                filterList.addShare(share);
                continue;
            }
            filterList.addShare(share);
        }
        if (this.hasDebug()) {
            sess.debugPrintln("Filtered share list " + filterList);
        }
        return filterList;
    }

    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        if (params.getChild("debug") != null) {
            this.setDebug(true);
        }
        this.addAccessControlType(new UserAccessControlParser());
        this.addAccessControlType(new ProtocolAccessControlParser());
        this.addAccessControlType(new DomainAccessControlParser());
        this.addAccessControlType(new IpAddressAccessControlParser());
        this.addAccessControlType(new GidAccessControlParser());
        this.addAccessControlType(new UidAccessControlParser());
        ConfigElement ruleList = params.getChild("rule");
        if (ruleList != null && ruleList.hasChildren()) {
            List rules = ruleList.getChildren();
            for (ConfigElement ruleVal : rules) {
                if (ruleVal.getValue() == null || ruleVal.getValue().length() == 0) {
                    throw new InvalidConfigurationException("Empty rule definition");
                }
                try {
                    Object ruleObj = Class.forName(ruleVal.getValue()).newInstance();
                    if (!(ruleObj instanceof AccessControlParser)) continue;
                    this.addAccessControlType((AccessControlParser)ruleObj);
                }
                catch (ClassNotFoundException ex) {
                    throw new InvalidConfigurationException("Rule class not found, " + ruleVal.getValue());
                }
                catch (InstantiationException ex) {
                    throw new InvalidConfigurationException("Error creating rule object, " + ruleVal.getValue() + ", " + ex.toString());
                }
                catch (IllegalAccessException ex) {
                    throw new InvalidConfigurationException("Error creating rule object, " + ruleVal.getValue() + ", " + ex.toString());
                }
            }
        }
    }

    public AccessControl createAccessControl(String type, ConfigElement params) throws ACLParseException, InvalidACLTypeException {
        return this.m_factory.createAccessControl(type, params);
    }

    public void addAccessControlType(AccessControlParser parser) {
        if (this.hasDebug()) {
            Debug.println("AccessControlManager Add rule type " + parser.getType());
        }
        this.m_factory.addParser(parser);
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }
}

