/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.sample;

import java.security.MessageDigest;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.loader.FileProcessor;
import org.alfresco.jlan.server.filesys.loader.FileSegment;
import org.alfresco.jlan.util.HexDump;

public class Md5SumFileProcessor
implements FileProcessor {
    private boolean m_md5field = true;

    public void processStoredFile(DiskDeviceContext context, FileState state, FileSegment segment) {
        String md5sum = this.calculateMd5Checksum(segment);
        Debug.println("## StoreFile file=" + state.getPath() + ", fid=" + state.getFileId() + ", temp=" + segment.getTemporaryFile() + ", MD5=" + md5sum);
    }

    public void processLoadedFile(DiskDeviceContext context, FileState state, FileSegment segment) {
    }

    protected final String calculateMd5Checksum(FileSegment segment) {
        MessageDigest md5 = null;
        String checksum = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte[] inbuf = new byte[512];
            long fileOff = 0L;
            int rdlen = segment.readBytes(inbuf, inbuf.length, 0, fileOff);
            while (rdlen > 0) {
                md5.update(inbuf, 0, rdlen);
                rdlen = segment.readBytes(inbuf, inbuf.length, 0, fileOff += (long)rdlen);
            }
            byte[] md5sum = md5.digest();
            checksum = HexDump.hexString(md5sum);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return checksum;
    }
}

