/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.oncrpc;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.alfresco.jlan.oncrpc.RpcPacket;
import org.alfresco.jlan.oncrpc.RpcProcessor;
import org.alfresco.jlan.server.DatagramSessionHandler;
import org.alfresco.jlan.server.NetworkServer;

public class UdpRpcDatagramHandler
extends DatagramSessionHandler {
    private RpcProcessor m_rpcProcessor;

    public UdpRpcDatagramHandler(String name, String protocol, RpcProcessor rpcServer, NetworkServer server, InetAddress addr, int port, int maxSize) {
        super(name, protocol, server, addr, port);
        this.m_rpcProcessor = rpcServer;
        this.setMaximumDatagramSize(maxSize);
    }

    protected final RpcProcessor getRpcProcessor() {
        return this.m_rpcProcessor;
    }

    protected boolean processDatagram(DatagramPacket pkt) throws IOException {
        RpcPacket rpcPkt = new RpcPacket(pkt.getData(), 0, pkt.getLength());
        rpcPkt.setClientDetails(pkt.getAddress(), pkt.getPort(), 17);
        if (rpcPkt.getRpcVersion() != 2) {
            rpcPkt.buildRpcMismatchResponse();
            pkt.setData(rpcPkt.getBuffer(), rpcPkt.getOffset(), 24);
            this.sendDatagram(pkt);
        } else {
            RpcPacket response = this.m_rpcProcessor.processRpc(rpcPkt);
            if (response != null) {
                pkt.setData(response.getBuffer(), response.getOffset(), response.getLength());
                this.sendDatagram(pkt);
            }
        }
        return true;
    }
}

