/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.oncrpc.RpcProcessor;
import org.alfresco.jlan.oncrpc.TcpRpcPacketHandler;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.PacketHandlerInterface;
import org.alfresco.jlan.server.SocketSessionHandler;

public class TcpRpcSessionHandler
extends SocketSessionHandler {
    private RpcProcessor m_rpcProcessor;
    private int m_maxRpcSize;
    private Hashtable<Integer, TcpRpcPacketHandler> m_sessions;

    public TcpRpcSessionHandler(String name, String protocol, RpcProcessor rpcServer, NetworkServer server, InetAddress addr, int port, int maxSize) {
        super(name, protocol, server, addr, port);
        this.m_rpcProcessor = rpcServer;
        this.m_maxRpcSize = maxSize;
        this.m_sessions = new Hashtable();
    }

    protected int getMaximumRpcSize() {
        return this.m_maxRpcSize;
    }

    protected final RpcProcessor getRpcProcessor() {
        return this.m_rpcProcessor;
    }

    protected void acceptConnection(Socket sock) {
        try {
            sock.setTcpNoDelay(true);
            int sessId = this.getNextSessionId();
            TcpRpcPacketHandler pktHandler = this.createPacketHandler(sessId, sock);
            this.m_sessions.put(new Integer(sessId), pktHandler);
            if (this.hasDebug()) {
                Debug.println("[" + this.getProtocolName() + "] Created new session id = " + sessId + ", from = " + sock.getInetAddress().getHostAddress() + ":" + sock.getPort());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected final void closeSession(int sessId) {
        PacketHandlerInterface pktHandler = this.m_sessions.remove(new Integer(sessId));
        if (pktHandler != null) {
            pktHandler.closePacketHandler();
        }
    }

    public void closeSessionHandler(NetworkServer server) {
        super.closeSessionHandler(server);
        if (this.m_sessions.size() > 0) {
            Enumeration<TcpRpcPacketHandler> enm = this.m_sessions.elements();
            while (enm.hasMoreElements()) {
                PacketHandlerInterface handler = enm.nextElement();
                handler.closePacketHandler();
            }
            this.m_sessions.clear();
        }
    }

    protected TcpRpcPacketHandler createPacketHandler(int sessId, Socket sock) throws IOException {
        return new TcpRpcPacketHandler(this, sessId, this.m_rpcProcessor, sock, this.getMaximumRpcSize());
    }
}

