/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.netbios;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.NameTemplateException;
import org.alfresco.jlan.netbios.NetBIOSName;
import org.alfresco.jlan.netbios.NetBIOSNameList;
import org.alfresco.jlan.netbios.NetBIOSPacket;
import org.alfresco.jlan.netbios.NetworkSession;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.jlan.util.HexDump;
import org.alfresco.jlan.util.IPAddress;
import org.alfresco.jlan.util.StringList;

public final class NetBIOSSession
extends NetworkSession {
    private static final String ProtocolName = "TCP/IP NetBIOS";
    public static final int DNSOnly = 1;
    public static final int WINSOnly = 2;
    public static final int WINSAndDNS = 3;
    public static final int MaxCallerNameTemplateLength = 8;
    public static final char SessionIdChar = '#';
    public static final char JVMIdChar = '@';
    public static final String ValidTemplateChars = "@#_";
    private static final int FindNameBufferSize = 2048;
    private int m_remotePort = 139;
    private int m_namePort = 137;
    private String m_subnetMask = _subnetMask;
    private InetAddress m_winsServer = _winsServer;
    private int m_lookupType = _lookupType;
    private int m_lookupTmo = _lookupTmo;
    private boolean m_useWildcardServerName = _useWildcardFileServer;
    private Socket m_nbSocket;
    private DataInputStream m_nbIn;
    private DataOutputStream m_nbOut;
    private char m_locNameType = (char)32;
    private char m_remNameType = (char)32;
    private static int m_sessIdx = 0;
    private static int m_jvmIdx = 0;
    private static String m_callerTemplate = "_##";
    private static String m_localNamePart;
    private static short m_tranIdx;
    private static DatagramSocket m_dgramSock;
    private static boolean m_debug;
    private static String _subnetMask;
    private static InetAddress _winsServer;
    private static int _lookupType;
    private static int _lookupTmo;
    private static boolean _useWildcardFileServer;

    public NetBIOSSession() {
        super(ProtocolName);
    }

    public NetBIOSSession(int tmo) {
        super(ProtocolName);
        this.setTimeout(tmo);
    }

    public NetBIOSSession(int tmo, int port, int namePort) {
        super(ProtocolName);
        this.setTimeout(tmo);
        this.m_remotePort = port;
        this.m_namePort = namePort;
    }

    public final int getSessionPort() {
        return this.m_remotePort;
    }

    public final int getNamePort() {
        return this.m_namePort;
    }

    public final int getLookupType() {
        return this.m_lookupType;
    }

    public final int getLookupTimeout() {
        return this.m_lookupTmo;
    }

    public final boolean hasWINSServer() {
        return this.m_winsServer != null;
    }

    public final InetAddress getWINSServer() {
        return this.m_winsServer;
    }

    public final String getSubnetMask() {
        return this.m_subnetMask;
    }

    public final boolean isConnected() {
        return this.m_nbSocket != null;
    }

    public final boolean hasData() throws IOException {
        if (this.m_nbSocket == null || this.m_nbIn == null) {
            return false;
        }
        return this.m_nbIn.available() > 0;
    }

    public static String ConvertName(String hostName) {
        return NetBIOSSession.ConvertName(hostName, ' ');
    }

    public static String ConvertName(String hostName, char nameType) {
        StringBuffer hName = new StringBuffer(hostName.toUpperCase());
        if (hName.length() > 15) {
            hName.setLength(15);
        }
        while (hName.length() < 15) {
            hName.append(' ');
        }
        hName.append(nameType);
        String convstr = "ABCDEFGHIJKLMNOP";
        StringBuffer nameBuf = new StringBuffer(32);
        int idx = 0;
        while (idx < hName.length()) {
            char ch;
            if ((ch = hName.charAt(idx++)) == ' ') {
                nameBuf.append("CA");
                continue;
            }
            nameBuf.append(convstr.charAt(ch / 16));
            nameBuf.append(convstr.charAt(ch % 16));
        }
        return nameBuf.toString();
    }

    public static String DecodeName(byte[] buf, int off) {
        String convstr = "ABCDEFGHIJKLMNOP";
        StringBuffer nameBuf = new StringBuffer(16);
        for (int idx = 0; idx < 32; idx += 2) {
            char ch1 = (char)buf[off + idx];
            char ch2 = (char)buf[off + idx + 1];
            if (ch1 == 'C' && ch2 == 'A') {
                nameBuf.append(' ');
                continue;
            }
            int val = convstr.indexOf(ch1) << 4;
            nameBuf.append((char)((val += convstr.indexOf(ch2)) & 0xFF));
        }
        return nameBuf.toString();
    }

    public static String DecodeName(String encnam) {
        if (encnam == null || encnam.length() != 32) {
            return "";
        }
        String convstr = "ABCDEFGHIJKLMNOP";
        StringBuffer nameBuf = new StringBuffer(16);
        for (int idx = 0; idx < 32; idx += 2) {
            char ch1 = encnam.charAt(idx);
            char ch2 = encnam.charAt(idx + 1);
            if (ch1 == 'C' && ch2 == 'A') {
                nameBuf.append(' ');
                continue;
            }
            int val = convstr.indexOf(ch1) << 4;
            nameBuf.append((char)((val += convstr.indexOf(ch2)) & 0xFF));
        }
        return nameBuf.toString();
    }

    public static int EncodeName(String hostName, char nameType, byte[] buf, int off) {
        StringBuffer hName = new StringBuffer(hostName.toUpperCase());
        if (hName.length() > 15) {
            hName.setLength(15);
        }
        while (hName.length() < 15) {
            hName.append(' ');
        }
        hName.append(nameType);
        String convstr = "ABCDEFGHIJKLMNOP";
        int idx = 0;
        int bufpos = off;
        buf[bufpos++] = 32;
        while (idx < hName.length()) {
            char ch;
            if ((ch = hName.charAt(idx++)) == ' ') {
                buf[bufpos++] = 67;
                buf[bufpos++] = 65;
                continue;
            }
            buf[bufpos++] = (byte)convstr.charAt(ch / 16);
            buf[bufpos++] = (byte)convstr.charAt(ch % 16);
        }
        buf[bufpos++] = 0;
        return bufpos;
    }

    public static NetBIOSName FindName(String nbName, char nbType, int tmo, NetBIOSSession sess) throws IOException {
        return NetBIOSSession.FindName(new NetBIOSName(nbName, nbType, false), tmo, sess);
    }

    public static NetBIOSName FindName(String nbName, char nbType, int tmo) throws IOException {
        return NetBIOSSession.FindName(new NetBIOSName(nbName, nbType, false), tmo, null);
    }

    public static NetBIOSName FindName(NetBIOSName nbName, int tmo) throws IOException {
        return NetBIOSSession.FindName(nbName, tmo, null);
    }

    public static NetBIOSName FindName(NetBIOSName nbName, int tmo, NetBIOSSession sess) throws IOException {
        int lookupTypes = NetBIOSSession.getDefaultLookupType();
        if (sess != null) {
            lookupTypes = sess.getLookupType();
        }
        if (lookupTypes == 1) {
            InetAddress inetAddr = InetAddress.getByName(nbName.getFullName());
            return new NetBIOSName(inetAddr.getHostName(), nbName.getType(), nbName.isGroupName(), inetAddr.getAddress());
        }
        InetAddress locAddr = InetAddress.getLocalHost();
        if (m_dgramSock == null) {
            m_dgramSock = new DatagramSocket();
        }
        m_dgramSock.setSoTimeout(tmo);
        boolean wins = false;
        if (sess != null && sess.hasWINSServer() || NetBIOSSession.hasDefaultWINSServer()) {
            wins = true;
        }
        NetBIOSPacket nbpkt = new NetBIOSPacket();
        short s = m_tranIdx;
        m_tranIdx = (short)(s + 1);
        nbpkt.buildNameQueryRequest(nbName, s, wins);
        String locIP = locAddr.getHostAddress();
        int dotIdx = locIP.indexOf(46);
        if (dotIdx == -1) {
            return null;
        }
        String subnetMask = NetBIOSSession.getDefaultSubnetMask();
        if (sess != null) {
            subnetMask = sess.getSubnetMask();
        }
        InetAddress destAddr = null;
        if (!NetBIOSSession.hasDefaultWINSServer() || sess != null && !sess.hasWINSServer()) {
            if (subnetMask == null) {
                subnetMask = NetBIOSSession.GenerateSubnetMask(null);
            }
            destAddr = InetAddress.getByName(subnetMask);
        } else {
            destAddr = sess != null ? sess.getWINSServer() : NetBIOSSession.getDefaultWINSServer();
        }
        DatagramPacket dgram = new DatagramPacket(nbpkt.getBuffer(), nbpkt.getLength(), destAddr, 137);
        byte[] rxbuf = new byte[2048];
        DatagramPacket rxdgram = new DatagramPacket(rxbuf, rxbuf.length);
        NetBIOSPacket rxpkt = new NetBIOSPacket(rxbuf);
        if (m_debug) {
            nbpkt.DumpPacket(false);
        }
        m_dgramSock.send(dgram);
        boolean rxOK = false;
        do {
            m_dgramSock.receive(rxdgram);
            if (m_debug) {
                Debug.println("NetBIOS: Rx Datagram");
                rxpkt.DumpPacket(false);
            }
            if (!rxpkt.isResponse() || rxpkt.getOpcode() != 16) continue;
            rxOK = true;
        } while (!rxOK);
        NetBIOSNameList nameList = rxpkt.getAnswerNameList();
        if (nameList != null && nameList.numberOfNames() > 0) {
            return nameList.getName(0);
        }
        return null;
    }

    public static NetBIOSName FindName(NetBIOSName nbName, int tmo, int lookupTypes, NetBIOSSession sess) throws IOException {
        if (lookupTypes == 1) {
            InetAddress inetAddr = InetAddress.getByName(nbName.getFullName());
            return new NetBIOSName(inetAddr.getHostName(), nbName.getType(), nbName.isGroupName(), inetAddr.getAddress());
        }
        InetAddress locAddr = InetAddress.getLocalHost();
        if (m_dgramSock == null) {
            m_dgramSock = new DatagramSocket();
        }
        m_dgramSock.setSoTimeout(tmo);
        boolean wins = false;
        if (sess != null && sess.hasWINSServer() || NetBIOSSession.hasDefaultWINSServer()) {
            wins = true;
        }
        NetBIOSPacket nbpkt = new NetBIOSPacket();
        short s = m_tranIdx;
        m_tranIdx = (short)(s + 1);
        nbpkt.buildNameQueryRequest(nbName, s, wins);
        String locIP = locAddr.getHostAddress();
        int dotIdx = locIP.indexOf(46);
        if (dotIdx == -1) {
            return null;
        }
        String subnetMask = NetBIOSSession.getDefaultSubnetMask();
        if (sess != null) {
            subnetMask = sess.getSubnetMask();
        }
        InetAddress destAddr = null;
        if (!NetBIOSSession.hasDefaultWINSServer() || sess != null && !sess.hasWINSServer()) {
            if (subnetMask == null) {
                subnetMask = NetBIOSSession.GenerateSubnetMask(null);
            }
            destAddr = InetAddress.getByName(subnetMask);
        } else {
            destAddr = sess != null ? sess.getWINSServer() : NetBIOSSession.getDefaultWINSServer();
        }
        DatagramPacket dgram = new DatagramPacket(nbpkt.getBuffer(), nbpkt.getLength(), destAddr, 137);
        byte[] rxbuf = new byte[2048];
        DatagramPacket rxdgram = new DatagramPacket(rxbuf, rxbuf.length);
        NetBIOSPacket rxpkt = new NetBIOSPacket(rxbuf);
        if (m_debug) {
            nbpkt.DumpPacket(false);
        }
        m_dgramSock.send(dgram);
        boolean rxOK = false;
        do {
            m_dgramSock.receive(rxdgram);
            if (m_debug) {
                Debug.println("NetBIOS: Rx Datagram");
                rxpkt.DumpPacket(false);
            }
            if (!rxpkt.isResponse() || rxpkt.getOpcode() != 16) continue;
            rxOK = true;
        } while (!rxOK);
        NetBIOSNameList nameList = rxpkt.getAnswerNameList();
        if (nameList != null && nameList.numberOfNames() > 0) {
            return nameList.getName(0);
        }
        return null;
    }

    public static StringList FindNameList(String nbName, char nbType, int tmo) throws IOException {
        return NetBIOSSession.FindNameList(nbName, nbType, tmo, null);
    }

    public static StringList FindNameList(String nbName, char nbType, int tmo, NetBIOSSession sess) throws IOException {
        InetAddress locAddr = InetAddress.getLocalHost();
        if (m_dgramSock == null) {
            m_dgramSock = new DatagramSocket();
        }
        m_dgramSock.setSoTimeout(tmo);
        NetBIOSPacket nbpkt = new NetBIOSPacket();
        short s = m_tranIdx;
        m_tranIdx = (short)(s + 1);
        nbpkt.setTransactionId(s);
        nbpkt.setOpcode(0);
        nbpkt.setFlags(1);
        nbpkt.setQuestionCount(1);
        nbpkt.setQuestionName(nbName, nbType, 32, 1);
        String locIP = locAddr.getHostAddress();
        int dotIdx = locIP.indexOf(46);
        if (dotIdx == -1) {
            return null;
        }
        InetAddress destAddr = null;
        if (!NetBIOSSession.hasDefaultWINSServer() || sess != null && !sess.hasWINSServer()) {
            String subnetMask = NetBIOSSession.getDefaultSubnetMask();
            if (sess != null) {
                subnetMask = sess.getSubnetMask();
            }
            if (subnetMask == null) {
                subnetMask = NetBIOSSession.GenerateSubnetMask(null);
            }
            destAddr = InetAddress.getByName(subnetMask);
        } else {
            destAddr = sess != null ? sess.getWINSServer() : NetBIOSSession.getDefaultWINSServer();
        }
        DatagramPacket dgram = new DatagramPacket(nbpkt.getBuffer(), nbpkt.getLength(), destAddr, 137);
        byte[] rxbuf = new byte[2048];
        DatagramPacket rxdgram = new DatagramPacket(rxbuf, rxbuf.length);
        NetBIOSPacket rxpkt = new NetBIOSPacket(rxbuf);
        if (m_debug) {
            nbpkt.DumpPacket(false);
        }
        Vector<InetAddress> addrList = new Vector<InetAddress>();
        long endTime = System.currentTimeMillis() + (long)tmo;
        m_dgramSock.send(dgram);
        do {
            try {
                m_dgramSock.receive(rxdgram);
                if (m_debug) {
                    Debug.println("NetBIOS: Rx Datagram");
                    rxpkt.DumpPacket(false);
                }
                if (!rxpkt.isResponse() || rxpkt.getOpcode() != 16) continue;
                addrList.addElement(rxdgram.getAddress());
            }
            catch (IOException ex) {
                if (!m_debug) continue;
                Debug.println(ex.toString());
            }
        } while (System.currentTimeMillis() < endTime);
        if (addrList.size() == 0) {
            return null;
        }
        StringList nameList = new StringList();
        for (int i = 0; i < addrList.size(); ++i) {
            InetAddress addr = (InetAddress)addrList.elementAt(i);
            String name = NetBIOSSession.NetBIOSName(addr.getHostName());
            if (nameList.containsString(name)) continue;
            nameList.addString(name);
        }
        return nameList;
    }

    public static NetBIOSNameList FindNamesForAddress(String ipAddr) throws UnknownHostException, SocketException {
        return NetBIOSSession.FindNamesForAddress(ipAddr, null);
    }

    public static NetBIOSNameList FindNamesForAddress(String ipAddr, NetBIOSSession sess) throws UnknownHostException, SocketException {
        if (m_dgramSock == null) {
            m_dgramSock = new DatagramSocket();
        }
        m_dgramSock.setSoTimeout(2000);
        NetBIOSPacket nbpkt = new NetBIOSPacket();
        short s = m_tranIdx;
        m_tranIdx = (short)(s + 1);
        nbpkt.setTransactionId(s);
        nbpkt.setOpcode(0);
        nbpkt.setFlags(1);
        nbpkt.setQuestionCount(1);
        nbpkt.setQuestionName("*\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", '\u0000', 33, 1);
        int namePort = 137;
        if (sess != null) {
            namePort = sess.getNamePort();
        }
        InetAddress destAddr = InetAddress.getByName(ipAddr);
        DatagramPacket dgram = new DatagramPacket(nbpkt.getBuffer(), nbpkt.getLength(), destAddr, namePort);
        byte[] rxbuf = new byte[2048];
        DatagramPacket rxdgram = new DatagramPacket(rxbuf, rxbuf.length);
        NetBIOSPacket rxpkt = new NetBIOSPacket(rxbuf);
        if (m_debug) {
            nbpkt.DumpPacket(false);
        }
        NetBIOSNameList nameList = null;
        try {
            m_dgramSock.send(dgram);
            m_dgramSock.receive(rxdgram);
            if (m_debug) {
                Debug.println("NetBIOS: Rx Datagram");
                rxpkt.DumpPacket(false);
            }
            if (rxpkt.isResponse() && rxpkt.getOpcode() == 16 && rxpkt.getAnswerCount() >= 1 && (nameList = rxpkt.getAdapterStatusNameList()) != null) {
                byte[] ipByts = IPAddress.asBytes(ipAddr);
                for (int i = 0; i < nameList.numberOfNames(); ++i) {
                    NetBIOSName nbName = nameList.getName(i);
                    nbName.addIPAddress(ipByts);
                }
            }
        }
        catch (IOException ex) {
            if (m_debug) {
                Debug.println(ex.toString());
            }
            throw new UnknownHostException(ipAddr);
        }
        return nameList;
    }

    public static final NetBIOSName ConvertAddressToName(String addr, char nbTyp, boolean isGroup) throws UnknownHostException, SocketException, IOException {
        return NetBIOSSession.ConvertAddressToName(addr, nbTyp, isGroup, null);
    }

    public static final NetBIOSName ConvertAddressToName(String addr, char nbTyp, boolean isGroup, NetBIOSSession sess) throws UnknownHostException, SocketException, IOException {
        int lookupTypes = NetBIOSSession.getDefaultLookupType();
        if (sess != null) {
            lookupTypes = sess.getLookupType();
        }
        NetBIOSName nbName = null;
        if (IPAddress.isNumericAddress(addr)) {
            if (lookupTypes != 2) {
                try {
                    InetAddress inetAddr = InetAddress.getByName(addr);
                    nbName = new NetBIOSName(addr, nbTyp, isGroup, inetAddr.getAddress());
                    if (NetBIOSSession.isDebug()) {
                        Debug.println("Converted " + addr + " to NetBIOS name " + nbName + " [DNS]");
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (nbName == null && lookupTypes != 1) {
                NetBIOSNameList nameList = NetBIOSSession.FindNamesForAddress(addr);
                nbName = nameList.findName(nbTyp, isGroup);
                if (NetBIOSSession.isDebug()) {
                    Debug.println("Converted " + addr + " to NetBIOS name " + nbName + " [WINS]");
                }
            }
        }
        if (nbName == null) {
            throw new IOException("NetBIOS service not running");
        }
        return nbName;
    }

    public static String GenerateSubnetMask(String addr) throws UnknownHostException {
        int dotPos;
        String localIP = addr;
        if (localIP == null) {
            localIP = InetAddress.getLocalHost().getHostAddress();
        }
        if ((dotPos = localIP.indexOf(46)) != -1) {
            String ipStr = localIP.substring(0, dotPos);
            int ipVal = Integer.valueOf(ipStr);
            if (ipVal <= 127) {
                _subnetMask = "" + ipVal + ".255.255.255";
            } else if (ipVal <= 191) {
                ++dotPos;
                while (localIP.charAt(dotPos) != '.' && dotPos < localIP.length()) {
                    ++dotPos;
                }
                if (dotPos < localIP.length()) {
                    _subnetMask = localIP.substring(0, dotPos) + ".255.255";
                }
            } else if (ipVal <= 223) {
                ++dotPos;
                int dotCnt = 1;
                while (dotCnt < 3 && dotPos < localIP.length()) {
                    if (localIP.charAt(dotPos++) != '.') continue;
                    ++dotCnt;
                }
                if (dotPos < localIP.length()) {
                    _subnetMask = localIP.substring(0, dotPos - 1) + ".255";
                }
            }
        }
        if (_subnetMask == null) {
            _subnetMask = "255.255.255.255";
        }
        if (m_debug) {
            Debug.println("NetBIOS: Set subnet mask to " + _subnetMask);
        }
        return _subnetMask;
    }

    public static int getDefaultLookupTimeout() {
        return _lookupTmo;
    }

    public static int getDefaultLookupType() {
        return _lookupType;
    }

    public static String getDefaultSubnetMask() {
        return _subnetMask;
    }

    public static final boolean hasDefaultWINSServer() {
        return _winsServer != null;
    }

    public static final InetAddress getDefaultWINSServer() {
        return _winsServer;
    }

    public static boolean isDebug() {
        return m_debug;
    }

    private static final synchronized int getSessionId() {
        return m_sessIdx++;
    }

    public static final int getJVMIndex() {
        return m_jvmIdx;
    }

    public static String NetBIOSName(String hostName) {
        String nbName = hostName.toUpperCase();
        int pos = nbName.indexOf(".");
        if (pos != -1) {
            nbName = nbName.substring(0, pos);
        }
        return nbName;
    }

    public final void setSessionPort(int port) {
        this.m_remotePort = port;
    }

    public final void setLookupType(int lookupTyp) {
        this.m_lookupType = lookupTyp;
    }

    public final void setLookupTimeout(int tmo) {
        this.m_lookupTmo = tmo;
    }

    public final void setWINSServer(InetAddress addr) {
        this.m_winsServer = addr;
    }

    public final void setSubnetMask(String mask) {
        this.m_subnetMask = mask;
    }

    public static void setDebug(boolean dbg) {
        m_debug = dbg;
    }

    public static void setDefaultLookupTimeout(int tmo) {
        if (tmo >= 250) {
            _lookupTmo = tmo;
        }
    }

    public static void setDefaultLookupType(int typ) {
        if (typ >= 1 && typ <= 3) {
            _lookupType = typ;
        }
    }

    public static void setDefaultSubnetMask(String subnet) {
        _subnetMask = subnet;
    }

    public static final void setDefaultWINSServer(InetAddress addr) {
        _winsServer = addr;
    }

    private static Vector AdapterStatus(String nodeName) throws IOException {
        DatagramSocket nameSock = new DatagramSocket();
        nameSock.setSoTimeout(2000);
        NetBIOSPacket nbpkt = new NetBIOSPacket();
        nbpkt.setTransactionId(9999);
        nbpkt.setOpcode(0);
        nbpkt.setFlags(1);
        nbpkt.setQuestionCount(1);
        nbpkt.setQuestionName(nodeName, '\u0000', 33, 1);
        InetAddress destAddr = InetAddress.getByName(nodeName);
        DatagramPacket dgram = new DatagramPacket(nbpkt.getBuffer(), nbpkt.getLength(), destAddr, 137);
        byte[] rxbuf = new byte[512];
        DatagramPacket rxdgram = new DatagramPacket(rxbuf, rxbuf.length);
        NetBIOSPacket rxpkt = new NetBIOSPacket(rxbuf);
        if (m_debug) {
            nbpkt.DumpPacket(false);
        }
        nameSock.send(dgram);
        boolean rxOK = false;
        do {
            nameSock.receive(rxdgram);
            if (m_debug) {
                Debug.println("NetBIOS: Rx Datagram");
                rxpkt.DumpPacket(false);
            }
            if (!rxpkt.isResponse() || rxpkt.getOpcode() != 16) continue;
            rxOK = true;
        } while (!rxOK);
        return null;
    }

    public void Open(String remHost, String locName, String remAddr) throws IOException, UnknownHostException {
        if (m_debug) {
            Debug.println("NetBIOS: Call " + remHost);
        }
        boolean dnsLookup = false;
        InetAddress addr = null;
        if (remAddr != null) {
            addr = InetAddress.getByName(remAddr);
        } else {
            if (this.getLookupType() != 1) {
                try {
                    NetBIOSName netName = NetBIOSSession.FindName(remHost, ' ', 500);
                    if (netName != null && netName.numberOfAddresses() > 0) {
                        addr = InetAddress.getByName(netName.getIPAddressString(0));
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (addr == null && this.getLookupType() != 2) {
                addr = InetAddress.getByName(remHost);
                dnsLookup = true;
            }
        }
        if (addr == null) {
            throw new UnknownHostException(remHost);
        }
        if (m_debug) {
            Debug.println("NetBIOS: Remote node has address " + addr.getHostAddress() + " (" + (dnsLookup ? "DNS" : "WINS") + ")");
        }
        String remoteName = null;
        remoteName = this.getRemoteNameType() == ' ' && this.useWildcardFileServerName() ? "*SMBSERVER" : remHost;
        int resp = this.openSession(remoteName, addr);
        if (resp == 130) {
            return;
        }
        if (resp == 131) {
            if (IPAddress.isNumericAddress(remHost)) {
                NetBIOSName nbName = null;
                int tmpLookupType = this.getLookupType();
                this.setLookupType(2);
                nbName = NetBIOSSession.ConvertAddressToName(remHost, ' ', false, this);
                this.setLookupType(tmpLookupType);
                remHost = nbName.getFullName();
            }
            if (!remoteName.equals(remHost)) {
                resp = this.openSession(remHost, addr);
            }
            if (resp == 130) {
                return;
            }
            throw new IOException("NetBIOS session reject");
        }
        if (resp == 132) {
            throw new IOException("NetBIOS ReTarget");
        }
        this.Close();
        throw new IOException("Invalid NetBIOS response, 0x" + Integer.toHexString(resp));
    }

    private final int openSession(String remoteName, InetAddress addr) throws IOException {
        long start = System.currentTimeMillis();
        this.m_nbSocket = new Socket();
        try {
            this.m_nbSocket.connect(new InetSocketAddress(addr, this.m_remotePort), this.getTimeout());
        }
        catch (IOException e) {
            this.m_nbSocket = null;
            throw e;
        }
        this.m_nbSocket.setSoTimeout(this.getTimeout());
        this.m_nbSocket.setTcpNoDelay(true);
        this.m_nbIn = new DataInputStream(this.m_nbSocket.getInputStream());
        this.m_nbOut = new DataOutputStream(this.m_nbSocket.getOutputStream());
        byte[] inpkt = new byte[9];
        NetBIOSName fromName = this.createUniqueCallerName();
        NetBIOSName toName = new NetBIOSName(remoteName, this.getRemoteNameType(), false);
        if (m_debug) {
            Debug.println("NetBIOS: Call from " + fromName + " to " + toName);
        }
        NetBIOSPacket nbPkt = new NetBIOSPacket();
        nbPkt.buildSessionSetupRequest(fromName, toName);
        this.m_nbOut.write(nbPkt.getBuffer(), 0, nbPkt.getLength());
        while (this.m_nbIn.available() < 1) {
            if (this.getTimeout() > 0 && System.currentTimeMillis() - start > (long)this.getTimeout()) {
                this.m_nbIn.close();
                this.m_nbIn = null;
                this.m_nbOut.close();
                this.m_nbOut = null;
                this.m_nbSocket.close();
                this.m_nbSocket = null;
                throw new IOException("NetBIOS session response timeout");
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
        int resp = -1;
        if (this.m_nbIn.read(inpkt, 0, 9) >= 4) {
            resp = inpkt[0] & 0xFF;
            if (m_debug) {
                Debug.println("NetBIOS: Rx " + NetBIOSPacket.getTypeAsString(resp));
            }
        }
        if (resp != 130) {
            this.m_nbIn.close();
            this.m_nbIn = null;
            this.m_nbOut.close();
            this.m_nbOut = null;
            this.m_nbSocket.close();
            this.m_nbSocket = null;
        }
        return resp;
    }

    public char getLocalNameType() {
        return this.m_locNameType;
    }

    public char getRemoteNameType() {
        return this.m_remNameType;
    }

    public void Close() throws IOException {
        if (m_debug) {
            Debug.println("NetBIOS: HangUp");
        }
        if (this.m_nbSocket != null) {
            this.m_nbSocket.close();
            this.m_nbSocket = null;
        }
    }

    public int Receive(byte[] buf) throws IOException {
        int rdlen;
        int pkttyp;
        do {
            rdlen = this.m_nbIn.read(buf, 0, 4);
            if (m_debug) {
                Debug.println("NetBIOS: Read " + rdlen + " bytes");
            }
            if (rdlen >= 4) continue;
            throw new IOException("NetBIOS Short Read");
        } while ((pkttyp = buf[0] & 0xFF) == 133);
        if (m_debug) {
            Debug.print("NetBIOS: Rx pkt ");
            switch (pkttyp) {
                case 0: {
                    Debug.println("Session_Message");
                    break;
                }
                case 132: {
                    Debug.print("Session_Retarget - ");
                    int len = DataPacker.getShort(buf, 2);
                    len = this.m_nbIn.read(buf, 4, len);
                    int addr = DataPacker.getInt(buf, 4);
                    Debug.println(Integer.toHexString(addr));
                    break;
                }
                default: {
                    Debug.println("NetBIOS: Rx Pkt Type = " + pkttyp + ", " + Integer.toHexString(pkttyp));
                }
            }
        }
        if (pkttyp != 0) {
            throw new IOException("NetBIOS Unknown Packet Type, " + pkttyp);
        }
        int pktlen = DataPacker.getShort(buf, 2);
        if (m_debug) {
            Debug.println("NetBIOS: Rx Data Len = " + pktlen);
        }
        if (buf.length < pktlen + 4) {
            if (m_debug) {
                Debug.println("NetBIOS: Rx Pkt Type = " + pkttyp + ", " + Integer.toHexString(pkttyp));
                Debug.println("NetBIOS: Rx Buf Too Small pkt=" + pktlen + " buflen=" + buf.length);
                HexDump.Dump(buf, 16, 0);
            }
            throw new IOException("NetBIOS Recv Buffer Too Small (pkt=" + pktlen + "/buf=" + buf.length + ")");
        }
        int totlen = 0;
        int offset = 4;
        while (pktlen > 0) {
            rdlen = this.m_nbIn.read(buf, offset, pktlen);
            totlen += rdlen;
            pktlen -= rdlen;
            offset += rdlen;
        }
        return totlen;
    }

    public boolean Send(byte[] data, int siz) throws IOException {
        if (this.m_nbSocket == null) {
            return false;
        }
        if (m_debug) {
            Debug.println("NetBIOS: Tx " + siz + " bytes");
        }
        data[0] = 0;
        data[1] = 0;
        DataPacker.putShort((short)siz, data, 2);
        int bufSiz = siz + 4;
        this.m_nbOut.write(data, 0, bufSiz);
        return true;
    }

    public void setTimeout(int tmo) {
        super.setTimeout(tmo);
        if (this.m_nbSocket != null) {
            try {
                this.m_nbSocket.setSoTimeout(this.getTimeout());
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public void setLocalNameType(char nameType) {
        this.m_locNameType = nameType;
    }

    public void setRemoteNameType(char nameType) {
        this.m_remNameType = nameType;
    }

    public static final void setCallerNameTemplate(String template) throws NameTemplateException {
        if (template == null || template.length() == 0 || template.length() > 8) {
            throw new NameTemplateException("Invalid template string, " + template);
        }
        if (template.indexOf(35) == -1) {
            throw new NameTemplateException("No session id character in template");
        }
        for (int i = 0; i < template.length(); ++i) {
            if (ValidTemplateChars.indexOf(template.charAt(i)) != -1) continue;
            throw new NameTemplateException("Invalid character in template, '" + template.charAt(i) + "'");
        }
        m_callerTemplate = template;
        m_localNamePart = null;
    }

    public static final void setJVMIndex(int jvmIdx) {
        if (jvmIdx >= 0) {
            m_jvmIdx = jvmIdx;
        }
    }

    private final NetBIOSName createUniqueCallerName() {
        if (m_localNamePart == null) {
            String localName = null;
            try {
                localName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                // empty catch block
            }
            int pos = localName.indexOf(".");
            if (pos != -1) {
                localName = localName.substring(0, pos);
            }
            int nameLen = 16 - m_callerTemplate.length();
            if (localName.length() > nameLen) {
                localName = localName.substring(0, nameLen - 1);
            }
            m_localNamePart = localName.toUpperCase();
        }
        int sessId = NetBIOSSession.getSessionId();
        int jvmId = NetBIOSSession.getJVMIndex();
        StringBuffer nameBuf = new StringBuffer(16);
        nameBuf.append(m_localNamePart);
        int idx = 0;
        int len = -1;
        block6: while (idx < m_callerTemplate.length()) {
            char ch = m_callerTemplate.charAt(idx++);
            switch (ch) {
                case '#': {
                    len = this.findRepeatLength(m_callerTemplate, idx, '#');
                    this.appendZeroPaddedHexValue(sessId, len, nameBuf);
                    idx += len - 1;
                    continue block6;
                }
                case '@': {
                    len = this.findRepeatLength(m_callerTemplate, idx, '@');
                    this.appendZeroPaddedHexValue(jvmId, len, nameBuf);
                    idx += len - 1;
                    continue block6;
                }
            }
            nameBuf.append(ch);
        }
        return new NetBIOSName(nameBuf.toString(), this.getLocalNameType(), false);
    }

    private final int findRepeatLength(String str, int pos, char ch) {
        int len = 1;
        while (pos < str.length() && str.charAt(pos++) == ch) {
            ++len;
        }
        return len;
    }

    private final void appendZeroPaddedHexValue(int val, int len, StringBuffer str) {
        String hex = Integer.toHexString(val);
        for (int i = 0; i < len - hex.length(); ++i) {
            str.append("0");
        }
        str.append(hex);
    }

    public final boolean useWildcardFileServerName() {
        return this.m_useWildcardServerName;
    }

    public final void setWildcardFileServerName(boolean useWildcard) {
        this.m_useWildcardServerName = useWildcard;
    }

    public static final boolean getDefaultWildcardFileServerName() {
        return _useWildcardFileServer;
    }

    public static final void setDefaultWildcardFileServerName(boolean useWildcard) {
        _useWildcardFileServer = useWildcard;
    }

    protected void finalize() {
        if (this.m_nbSocket != null) {
            try {
                this.m_nbSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_nbSocket = null;
        }
    }

    static {
        m_tranIdx = 1;
        m_dgramSock = null;
        m_debug = false;
        _subnetMask = null;
        _lookupType = 3;
        _lookupTmo = 500;
        _useWildcardFileServer = true;
    }
}

