/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.ftp;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.alfresco.jlan.ftp.FTPAuthenticator;
import org.alfresco.jlan.ftp.FTPCommand;
import org.alfresco.jlan.ftp.FTPConfigSection;
import org.alfresco.jlan.ftp.FTPDataSession;
import org.alfresco.jlan.ftp.FTPDate;
import org.alfresco.jlan.ftp.FTPPath;
import org.alfresco.jlan.ftp.FTPRequest;
import org.alfresco.jlan.ftp.FTPServer;
import org.alfresco.jlan.ftp.FTPSiteInterface;
import org.alfresco.jlan.ftp.InvalidPathException;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.acl.AccessControlManager;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.TreeConnectionHash;
import org.alfresco.jlan.util.UTF8Normalizer;
import org.alfresco.jlan.util.WildCard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPSrvSession
extends SrvSession
implements Runnable {
    public static final int DBG_STATE = 1;
    public static final int DBG_RXDATA = 2;
    public static final int DBG_TXDATA = 4;
    public static final int DBG_DUMPDATA = 8;
    public static final int DBG_SEARCH = 16;
    public static final int DBG_INFO = 32;
    public static final int DBG_FILE = 64;
    public static final int DBG_FILEIO = 128;
    public static final int DBG_ERROR = 256;
    public static final int DBG_PKTTYPE = 512;
    public static final int DBG_TIMING = 1024;
    public static final int DBG_DATAPORT = 2048;
    public static final int DBG_DIRECTORY = 4096;
    public static final int DBG_SSL = 8192;
    public static final boolean FeatureUTF8 = true;
    public static final boolean FeatureMDTM = true;
    public static final boolean FeatureSIZE = true;
    public static final boolean FeatureMLST = true;
    public static final boolean FeatureAUTH = true;
    private static final String ROOT_DIRECTORY = "/";
    private static final String FTP_SEPERATOR = "/";
    private static final char FTP_SEPERATOR_CHAR = '/';
    private static final String DIR_SEPERATOR = "\\";
    private static final char DIR_SEPERATOR_CHAR = '\\';
    private static final int DEFAULT_BUFFERSIZE = 64000;
    protected static final String CRLF = "\r\n";
    protected static final String LIST_OPTION_PREFIX = "-";
    protected static final char LIST_OPTION_HIDDEN = 'a';
    protected static final int MLST_SIZE = 1;
    protected static final int MLST_MODIFY = 2;
    protected static final int MLST_CREATE = 4;
    protected static final int MLST_TYPE = 8;
    protected static final int MLST_UNIQUE = 16;
    protected static final int MLST_PERM = 32;
    protected static final int MLST_MEDIATYPE = 64;
    protected static final int MLST_DEFAULT = 127;
    protected static final String[] _factNames = new String[]{"size", "modify", "create", "type", "unique", "perm", "media-type"};
    protected static final int MLSD_BUFFER_SIZE = 4096;
    protected static final int MDTM_DATETIME_MINLEN = 14;
    protected static final int TypeIPv4 = 1;
    protected static final int TypeIPv6 = 2;
    protected static final String ProtLevels = "CSEP";
    protected static final String ProtLevelClear = "C";
    protected static final int DefCommandBufSize = 1024;
    protected static final int MaxCommandBufSize = 65535;
    private Socket m_sock;
    private InputStream m_in;
    private byte[] m_inbuf;
    private OutputStreamWriter m_out;
    private List<FTPRequest> m_ftpCmdList;
    private FTPDataSession m_dataSess;
    private FTPPath m_cwd;
    private boolean m_binary = false;
    private long m_restartPos = 0L;
    private boolean m_utf8Paths = true;
    private UTF8Normalizer m_normalizer;
    private int m_mlstFacts = 127;
    private FTPPath m_renameFrom;
    private SharedDeviceList m_shares;
    private TreeConnectionHash m_connections;
    private SSLContext m_sslContext;
    private SSLEngine m_sslEngine;
    private ByteBuffer m_sslIn;
    private ByteBuffer m_sslOut;
    private int m_pbSize = -1;
    private String m_protLevel;

    public FTPSrvSession(Socket sock, FTPServer srv) {
        super(-1, srv, "FTP", null);
        this.m_sock = sock;
        try {
            this.m_sock.setSoLinger(false, 0);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.setLoggedOn(false);
        this.m_cwd = new FTPPath();
        this.m_connections = new TreeConnectionHash();
        this.m_ftpCmdList = new ArrayList<FTPRequest>();
        this.m_normalizer = srv.getUTF8Normalizer();
    }

    @Override
    public final void closeSession() {
        super.closeSession();
        if (this.m_dataSess != null) {
            this.getFTPServer().releaseDataSession(this.m_dataSess);
            this.m_dataSess = null;
        }
        if (this.hasTransaction()) {
            this.debugPrintln("** Active transaction after packet processing, cleaning up **");
            this.endTransaction();
        }
        if (this.m_sock != null) {
            try {
                this.m_sock.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_sock = null;
        }
        if (this.m_in != null) {
            try {
                this.m_in.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_in = null;
        }
        if (this.m_out != null) {
            try {
                this.m_out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_out = null;
        }
        this.getFTPServer().removeSession(this);
        if (this.hasDebug(1)) {
            this.debugPrintln("Session closed, " + this.getSessionId());
        }
    }

    public final String getCurrentWorkingDirectory() {
        return this.m_cwd.getFTPPath();
    }

    public final FTPServer getFTPServer() {
        return (FTPServer)this.getServer();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.m_sock.getInetAddress();
    }

    public final boolean hasCurrentWorkingDirectory() {
        return this.m_cwd != null;
    }

    public final boolean isUTF8Enabled() {
        return this.m_utf8Paths && this.m_normalizer != null;
    }

    public final void setRootPath(FTPPath rootPath) {
        this.m_cwd = new FTPPath(rootPath);
        this.m_cwd.setSharedDevice(this.getShareList(), this);
    }

    protected final FTPPath generatePathForRequest(FTPRequest req, boolean filePath) {
        return this.generatePathForRequest(req, filePath, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final FTPPath generatePathForRequest(FTPRequest req, boolean filePath, boolean checkExists) {
        FTPPath ftpPath;
        block25: {
            String path = req.getArgument();
            path = this.convertToFTPSeperators(path);
            ftpPath = null;
            if (path.compareTo("/") == 0) {
                FTPServer ftpSrv = (FTPServer)this.getServer();
                if (ftpSrv.hasRootPath()) {
                    ftpPath = ftpSrv.getRootPath();
                    break block25;
                } else {
                    try {
                        return new FTPPath("/");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    return ftpPath;
                }
            }
            if (!FTPPath.isRelativePath(path)) {
                try {
                    ftpPath = new FTPPath(path);
                }
                catch (InvalidPathException ex) {
                    return null;
                }
                if (!ftpPath.setSharedDevice(this.getShareList(), this)) {
                    return null;
                }
            } else {
                if (path.equals(".")) return this.m_cwd;
                if (path.length() == 0) {
                    return this.m_cwd;
                }
                if (path.equals("..")) {
                    if (this.m_cwd.isRootPath()) return null;
                    this.m_cwd.removeDirectory();
                    this.m_cwd.setSharedDevice(this.getShareList(), this);
                    return this.m_cwd;
                }
                ftpPath = new FTPPath(this.m_cwd);
                if (ftpPath.isRootPath()) {
                    try {
                        ftpPath.setFTPPath("/" + path);
                    }
                    catch (InvalidPathException ex) {
                        return null;
                    }
                } else if (filePath) {
                    ftpPath.addFile(path);
                } else {
                    ftpPath.addDirectory(path);
                }
                if (!ftpPath.hasSharedDevice() && !ftpPath.setSharedDevice(this.getShareList(), this)) {
                    return null;
                }
            }
        }
        if (!checkExists) return ftpPath;
        if (!ftpPath.hasSharePath()) return ftpPath;
        if (ftpPath.getSharePath().length() <= 1) return ftpPath;
        DiskInterface disk = null;
        TreeConnection tree = null;
        try {
            tree = this.getTreeConnection(ftpPath.getSharedDevice());
            disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
            int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
            if (sts == 0) {
                String pathStr = req.getArgument();
                if (!pathStr.startsWith("/")) {
                    pathStr = "/" + pathStr;
                }
                if (!(ftpPath = new FTPPath(pathStr)).setSharedDevice(this.getShareList(), this)) {
                    ftpPath = null;
                }
                if (disk.fileExists(this, tree, ftpPath.getSharePath()) != 0) return ftpPath;
                return null;
            }
            if (sts == 1) {
                if (!filePath) return null;
            }
            if (sts != 2) return ftpPath;
            if (!filePath) return ftpPath;
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected final String convertToFTPSeperators(String path) {
        if (path == null || path.indexOf(DIR_SEPERATOR) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }

    protected final DiskSharedDevice findShare(String name) {
        if (name == null) {
            return null;
        }
        SharedDevice shr = this.getFTPServer().getShareList().findShare(this.m_cwd.getShareName(), 0, true);
        if (shr != null && shr instanceof DiskSharedDevice) {
            return (DiskSharedDevice)shr;
        }
        return null;
    }

    protected final void setBinary(boolean bin) {
        this.m_binary = bin;
    }

    public final void sendFTPResponse(int stsCode, String msg) throws IOException {
        StringBuffer outbuf = new StringBuffer(10 + (msg != null ? msg.length() : 0));
        outbuf.append(stsCode);
        outbuf.append(" ");
        if (msg != null) {
            outbuf.append(msg);
        }
        if (this.hasDebug(4)) {
            this.debugPrintln("Tx msg=" + outbuf.toString());
        }
        if (this.hasDebug(256) && stsCode >= 500) {
            this.debugPrintln("Error status=" + stsCode + ", msg=" + msg);
        }
        outbuf.append(CRLF);
        if (this.m_out != null) {
            if (this.m_sslEngine != null) {
                this.sendEncryptedFTPResponse(outbuf.toString());
            } else {
                this.m_out.write(outbuf.toString());
                this.m_out.flush();
            }
        }
    }

    public final void sendUnencryptedFTPResponse(int stsCode, String msg) throws IOException {
        StringBuffer outbuf = new StringBuffer(10 + (msg != null ? msg.length() : 0));
        outbuf.append(stsCode);
        outbuf.append(" ");
        if (msg != null) {
            outbuf.append(msg);
        }
        if (this.hasDebug(4)) {
            this.debugPrintln("Tx msg=" + outbuf.toString());
        }
        if (this.hasDebug(256) && stsCode >= 500) {
            this.debugPrintln("Error status=" + stsCode + ", msg=" + msg);
        }
        outbuf.append(CRLF);
        if (this.m_out != null) {
            this.m_out.write(outbuf.toString());
            this.m_out.flush();
        }
    }

    public final void sendFTPResponse(StringBuffer msg) throws IOException {
        this.sendFTPResponse(msg.toString());
    }

    public final void sendFTPResponse(String msg) throws IOException {
        if (this.hasDebug(4)) {
            this.debugPrintln("Tx msg=" + msg);
        }
        if (this.m_out != null) {
            if (this.m_sslEngine != null) {
                StringBuilder str = new StringBuilder(msg.length() + CRLF.length());
                str.append(msg);
                str.append(CRLF);
                this.sendEncryptedFTPResponse(str.toString());
            } else {
                this.m_out.write(msg);
                this.m_out.write(CRLF);
                this.m_out.flush();
            }
        }
    }

    protected final void sendEncryptedFTPResponse(String msg) throws IOException {
        if (this.hasDebug(4)) {
            this.debugPrintln("Tx msg=" + msg);
        }
        if (this.m_out != null && this.m_sslEngine != null) {
            byte[] respByts = msg.getBytes();
            ByteBuffer inByts = ByteBuffer.wrap(respByts, 0, respByts.length);
            this.m_sslOut.position(0);
            this.m_sslOut.limit(this.m_sslOut.capacity());
            SSLEngineResult sslRes = this.m_sslEngine.wrap(inByts, this.m_sslOut);
            if (this.m_sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable task;
                while ((task = this.m_sslEngine.getDelegatedTask()) != null) {
                    task.run();
                }
            }
            this.m_sslOut.flip();
            this.m_sock.getOutputStream().write(this.m_sslOut.array(), 0, this.m_sslOut.remaining());
            this.m_sock.getOutputStream().flush();
        }
    }

    protected final void procUser(FTPRequest req) throws IOException {
        this.setClientInformation(null);
        this.setLoggedOn(false);
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Syntax error in parameters or arguments");
            return;
        }
        if (this.getFTPServer().getFTPConfiguration().isFTPSEnabled() && this.getFTPServer().getFTPConfiguration().requireSecureSession() && !this.isSecureSession()) {
            this.sendFTPResponse(530, "Only secure logons are allowed, use FTPS");
            return;
        }
        if (this.getFTPServer().allowAnonymous() && req.getArgument().equalsIgnoreCase(this.getFTPServer().getAnonymousAccount())) {
            ClientInfo cinfo = ClientInfo.createInfo(this.getFTPServer().getAnonymousAccount(), null);
            cinfo.setGuest(true);
            this.setClientInformation(cinfo);
            this.sendFTPResponse(331, "Guest login ok, send your complete e-mail address as password");
            return;
        }
        this.setClientInformation(ClientInfo.createInfo(req.getArgument(), null));
        this.sendFTPResponse(331, "User name okay, need password for " + req.getArgument());
    }

    protected final void procPassword(FTPRequest req) throws IOException {
        if (!this.hasClientInformation()) {
            this.sendFTPResponse(500, "Syntax error, command " + FTPCommand.getCommandName(req.isCommand()) + " unrecognized");
            return;
        }
        if (this.getClientInformation().isGuest()) {
            this.getClientInformation().setPassword(req.getArgument());
            this.setLoggedOn(true);
            this.sendFTPResponse(230, "User logged in, proceed");
            if (this.hasDebug(1)) {
                this.debugPrintln("Anonymous login, info=" + req.getArgument());
            }
        } else {
            this.getClientInformation().setPassword(req.getArgument());
            FTPAuthenticator auth = this.getFTPServer().getFTPConfiguration().getFTPAuthenticator();
            if (auth.authenticateUser(this.getClientInformation(), this)) {
                this.sendFTPResponse(230, "User logged in, proceed");
                this.setLoggedOn(true);
                if (this.hasDebug(1)) {
                    this.debugPrintln("User " + this.getClientInformation().getUserName() + ", logon successful");
                }
            } else {
                this.sendFTPResponse(530, "Access denied");
                if (this.hasDebug(1)) {
                    this.debugPrintln("User " + this.getClientInformation().getUserName() + ", logon failed");
                }
            }
        }
        if (this.isLoggedOn()) {
            this.getFTPServer().sessionLoggedOn(this);
        }
    }

    protected final void procPort(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Required argument missing");
            return;
        }
        StringTokenizer token = new StringTokenizer(req.getArgument(), ",");
        if (token.countTokens() != 6) {
            this.sendFTPResponse(501, "Invalid argument");
            return;
        }
        String addrStr = token.nextToken() + "." + token.nextToken() + "." + token.nextToken() + "." + token.nextToken();
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(addrStr);
        }
        catch (UnknownHostException ex) {
            this.sendFTPResponse(501, "Invalid argument (address)");
            return;
        }
        int port = -1;
        try {
            port = Integer.parseInt(token.nextToken()) * 256;
        }
        catch (NumberFormatException ex) {
            this.sendFTPResponse(501, "Invalid argument (port)");
            return;
        }
        this.m_dataSess = this.getFTPServer().allocateDataSession(this, addr, port += Integer.parseInt(token.nextToken()));
        this.sendFTPResponse(200, "Port OK");
        if (this.hasDebug(2048)) {
            this.debugPrintln("Port open addr=" + addr + ", port=" + port);
        }
    }

    protected final void procPassive(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        try {
            this.m_dataSess = this.getFTPServer().allocatePassiveDataSession(this, this.m_sock.getLocalAddress());
        }
        catch (IOException ex) {
            this.m_dataSess = null;
        }
        if (this.m_dataSess == null) {
            this.sendFTPResponse(550, "Requested action not taken");
            return;
        }
        int pasvPort = this.m_dataSess.getPassivePort();
        StringBuffer msg = new StringBuffer();
        msg.append("227 Entering Passive Mode (");
        msg.append(this.getLocalFTPAddressString());
        msg.append(",");
        msg.append(pasvPort >> 8);
        msg.append(",");
        msg.append(pasvPort & 0xFF);
        msg.append(")");
        this.sendFTPResponse(msg);
        if (this.hasDebug(2048)) {
            this.debugPrintln("Passive open addr=" + this.m_sock.getLocalAddress() + ", port=" + pasvPort);
        }
    }

    protected final void procPrintWorkDir(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        this.sendFTPResponse(257, "\"" + this.m_cwd.getFTPPath() + "\"");
        if (this.hasDebug(4096)) {
            this.debugPrintln("Pwd ftp=" + this.m_cwd.getFTPPath() + ", share=" + this.m_cwd.getShareName() + ", path=" + this.m_cwd.getSharePath());
        }
    }

    protected final void procChangeWorkDir(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Path not specified");
            return;
        }
        FTPPath newPath = this.generatePathForRequest(req, false, true);
        if (newPath == null) {
            this.sendFTPResponse(550, "Invalid path " + req.getArgument());
            return;
        }
        this.m_cwd = newPath;
        this.sendFTPResponse(250, "Requested file action OK");
        if (this.hasDebug(4096)) {
            this.debugPrintln("Cwd ftp=" + this.m_cwd.getFTPPath() + ", share=" + this.m_cwd.getShareName() + ", path=" + this.m_cwd.getSharePath());
        }
    }

    protected final void procCdup(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        if (this.m_cwd.isRootPath()) {
            this.sendFTPResponse(550, "Already at root directory");
            return;
        }
        this.m_cwd.removeDirectory();
        if (!this.m_cwd.isRootPath() && this.m_cwd.getSharedDevice() == null) {
            this.m_cwd.setSharedDevice(this.getShareList(), this);
        }
        this.sendFTPResponse(250, "Requested file action OK");
        if (this.hasDebug(4096)) {
            this.debugPrintln("Cdup ftp=" + this.m_cwd.getFTPPath() + ", share=" + this.m_cwd.getShareName() + ", path=" + this.m_cwd.getSharePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void procList(FTPRequest req) throws IOException {
        TreeConnection tree;
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        boolean hidden = false;
        if (req.hasArgument() && req.getArgument().startsWith(LIST_OPTION_PREFIX)) {
            int pos;
            String arg = req.getArgument();
            if (arg.indexOf(97) != -1) {
                hidden = true;
            }
            arg = (pos = arg.indexOf(" ")) > 0 ? arg.substring(pos + 1) : null;
            req.updateArgument(arg);
        }
        FTPPath ftpPath = this.m_cwd;
        if (req.hasArgument()) {
            ftpPath = this.generatePathForRequest(req, true, false);
        }
        if (ftpPath == null) {
            this.sendFTPResponse(500, "Invalid path");
            return;
        }
        if (!(ftpPath.isRootPath() || (tree = this.getTreeConnection(ftpPath.getSharedDevice())) != null && tree.hasReadAccess())) {
            this.sendFTPResponse(550, "Access denied");
            return;
        }
        try {
            if (ftpPath.hasSharePath() && !WildCard.containsWildcards(ftpPath.getSharePath())) {
                tree = this.getTreeConnection(ftpPath.getSharedDevice());
                DiskInterface disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                if (sts == 0) {
                    this.sendFTPResponse(500, "Invalid path");
                    return;
                }
                if (sts == 2) {
                    ftpPath.setDirectory(true);
                }
            }
        }
        catch (Exception ex) {
            this.sendFTPResponse(451, "Error reading file list");
        }
        this.sendFTPResponse(150, "File status okay, about to open data connection");
        if (this.m_dataSess == null) {
            this.sendFTPResponse(425, "Can't open data connection");
            return;
        }
        Socket dataSock = null;
        try {
            dataSock = this.m_dataSess.getSocket();
        }
        catch (Exception ex) {
            this.debugPrintln(ex);
        }
        if (dataSock == null) {
            this.sendFTPResponse(426, "Connection closed; transfer aborted");
            return;
        }
        Writer dataWrt = null;
        try {
            dataWrt = this.isUTF8Enabled() ? new OutputStreamWriter(dataSock.getOutputStream(), "UTF-8") : new OutputStreamWriter(dataSock.getOutputStream());
            Vector<Object> files = null;
            if (req.hasArgument()) {
                // empty if block
            }
            if ((files = this.listFilesForPath(ftpPath, false, hidden)) != null) {
                if (this.hasDebug(16)) {
                    this.debugPrintln("List found " + files.size() + " files in " + ftpPath.getFTPPath());
                }
                StringBuffer str = new StringBuffer(256);
                for (int i = 0; i < files.size(); ++i) {
                    FileInfo finfo = (FileInfo)files.elementAt(i);
                    str.setLength(0);
                    str.append(finfo.isDirectory() ? "d" : LIST_OPTION_PREFIX);
                    str.append("rw-rw-rw-   1 user group ");
                    str.append(finfo.getSize());
                    str.append(" ");
                    FTPDate.packUnixDate(str, new Date(finfo.getModifyDateTime()));
                    str.append(" ");
                    str.append(finfo.getFileName());
                    str.append(CRLF);
                    dataWrt.write(str.toString());
                }
            }
            this.sendFTPResponse(226, "Closing data connection");
        }
        catch (Exception ex) {
            this.sendFTPResponse(451, "Error reading file list");
        }
        finally {
            if (dataWrt != null) {
                dataWrt.close();
            }
            if (this.m_dataSess != null) {
                this.getFTPServer().releaseDataSession(this.m_dataSess);
                this.m_dataSess = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void procNList(FTPRequest req) throws IOException {
        TreeConnection tree;
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        FTPPath ftpPath = this.m_cwd;
        if (req.hasArgument()) {
            ftpPath = this.generatePathForRequest(req, true);
        }
        if (ftpPath == null) {
            this.sendFTPResponse(500, "Invalid path");
            return;
        }
        if (!(ftpPath.isRootPath() || (tree = this.getTreeConnection(ftpPath.getSharedDevice())) != null && tree.hasReadAccess())) {
            this.sendFTPResponse(550, "Access denied");
            return;
        }
        this.sendFTPResponse(150, "File status okay, about to open data connection");
        if (this.m_dataSess == null) {
            this.sendFTPResponse(425, "Can't open data connection");
            return;
        }
        Socket dataSock = null;
        try {
            dataSock = this.m_dataSess.getSocket();
        }
        catch (Exception ex) {
            this.debugPrintln(ex);
        }
        if (dataSock == null) {
            this.sendFTPResponse(426, "Connection closed; transfer aborted");
            return;
        }
        Writer dataWrt = null;
        try {
            dataWrt = this.isUTF8Enabled() ? new OutputStreamWriter(dataSock.getOutputStream(), "UTF-8") : new OutputStreamWriter(dataSock.getOutputStream());
            Vector<Object> files = null;
            if (req.hasArgument()) {
                // empty if block
            }
            if ((files = this.listFilesForPath(ftpPath, false, false)) != null) {
                if (this.hasDebug(16)) {
                    this.debugPrintln("List found " + files.size() + " files in " + ftpPath.getFTPPath());
                }
                for (int i = 0; i < files.size(); ++i) {
                    FileInfo finfo = (FileInfo)files.elementAt(i);
                    dataWrt.write(finfo.getFileName());
                    dataWrt.write(CRLF);
                }
            }
            this.sendFTPResponse(226, "Closing data connection");
        }
        catch (Exception ex) {
            this.sendFTPResponse(451, "Error reading file list");
        }
        finally {
            if (dataWrt != null) {
                dataWrt.close();
            }
            if (this.m_dataSess != null) {
                this.getFTPServer().releaseDataSession(this.m_dataSess);
                this.m_dataSess = null;
            }
        }
    }

    protected final void procSystemStatus(FTPRequest req) throws IOException {
        this.sendFTPResponse(215, "UNIX Type: Java FTP Server");
    }

    protected final void procServerStatus(FTPRequest req) throws IOException {
        this.sendFTPResponse(211, "JLAN Server - Java FTP Server");
    }

    protected final void procHelp(FTPRequest req) throws IOException {
        this.sendFTPResponse(211, "HELP text");
    }

    protected final void procNoop(FTPRequest req) throws IOException {
        this.sendFTPResponse(200, "");
    }

    protected final void procOptions(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Required argument missing");
            return;
        }
        StringTokenizer token = new StringTokenizer(req.getArgument(), " ");
        if (!token.hasMoreTokens()) {
            this.sendFTPResponse(501, "Invalid argument");
            return;
        }
        String optsCmd = token.nextToken();
        if (optsCmd.equalsIgnoreCase("UTF8")) {
            if (token.hasMoreTokens()) {
                String optsArg = token.nextToken();
                if (optsArg.equalsIgnoreCase("ON")) {
                    this.m_utf8Paths = true;
                } else if (optsArg.equalsIgnoreCase("OFF")) {
                    this.m_utf8Paths = false;
                } else {
                    this.sendFTPResponse(501, "OPTS UTF8 Invalid argument");
                    return;
                }
                this.sendFTPResponse(200, "OPTS UTF8 " + (this.isUTF8Enabled() ? "ON" : "OFF"));
                if (this.hasDebug(64)) {
                    this.debugPrintln("UTF8 options utf8=" + (this.isUTF8Enabled() ? "ON" : "OFF"));
                }
            }
        } else if (optsCmd.equalsIgnoreCase("MLST")) {
            if (!token.hasMoreTokens()) {
                this.sendFTPResponse(501, "OPTS MLST Invalid argument");
                return;
            }
            int mlstFacts = 0;
            StringTokenizer factTokens = new StringTokenizer(token.nextToken(), ";");
            StringBuffer factStr = new StringBuffer();
            while (factTokens.hasMoreTokens()) {
                String factName = factTokens.nextToken();
                int factIdx = -1;
                int idx = 0;
                while (idx < _factNames.length && factIdx == -1) {
                    if (_factNames[idx].equalsIgnoreCase(factName)) {
                        factIdx = idx;
                        continue;
                    }
                    ++idx;
                }
                if (factIdx == -1) continue;
                factStr.append(_factNames[factIdx]);
                factStr.append(";");
                mlstFacts += 1 << factIdx;
            }
            if (mlstFacts == 0) {
                this.sendFTPResponse(501, "OPTS MLST Invalid Argument");
                return;
            }
            this.m_mlstFacts = mlstFacts;
            this.sendFTPResponse(200, "MLST OPTS " + factStr.toString());
            if (this.hasDebug(16)) {
                this.debugPrintln("MLst options facts=" + factStr.toString());
            }
        } else {
            this.sendFTPResponse(501, "Invalid argument");
        }
    }

    protected final void procQuit(FTPRequest req) throws IOException {
        this.sendFTPResponse(221, "Bye");
        if (this.hasDebug(1)) {
            this.debugPrintln("Quit closing connection(s) to client");
        }
        this.closeSession();
    }

    protected final void procType(FTPRequest req) throws IOException {
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Syntax error, parameter required");
            return;
        }
        String arg = req.getArgument().toUpperCase();
        if (arg.startsWith("A")) {
            this.setBinary(false);
        } else if (arg.startsWith("I") || arg.startsWith("L")) {
            this.setBinary(true);
        } else {
            this.sendFTPResponse(501, "Syntax error, invalid parameter");
            return;
        }
        this.sendFTPResponse(200, "Command OK");
        if (this.hasDebug(1)) {
            this.debugPrintln("Type arg=" + req.getArgument() + ", binary=" + this.m_binary);
        }
    }

    protected final void procRestart(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Syntax error, parameter required");
            return;
        }
        try {
            this.m_restartPos = Integer.parseInt(req.getArgument());
        }
        catch (NumberFormatException ex) {
            this.sendFTPResponse(501, "Invalid restart position");
            return;
        }
        this.sendFTPResponse(350, "Restart OK");
        if (this.hasDebug(128)) {
            this.debugPrintln("Restart pos=" + this.m_restartPos);
        }
    }

    /*
     * Exception decompiling
     */
    protected final void procReturnFile(FTPRequest req) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 36[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procStoreFile(FTPRequest req, boolean append) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Syntax error, parameter required");
            return;
        }
        FTPPath ftpPath = this.generatePathForRequest(req, true, false);
        if (ftpPath == null) {
            this.sendFTPResponse(500, "Invalid path");
            return;
        }
        InputStream is = null;
        DiskInterface disk = null;
        TreeConnection tree = null;
        NetworkFile netFile = null;
        int sts = 0;
        boolean deleteOnClose = false;
        try {
            block71: {
                try {
                    Socket dataSock;
                    block70: {
                        block69: {
                            tree = this.getTreeConnection(ftpPath.getSharedDevice());
                            if (tree == null || !tree.hasWriteAccess()) {
                                this.sendFTPResponse(550, "Access denied");
                                Object var22_10 = null;
                                if (netFile != null && deleteOnClose) {
                                    netFile.setDeleteOnClose(true);
                                }
                                if (netFile != null && disk != null && tree != null) {
                                    disk.closeFile(this, tree, netFile);
                                }
                                if (is != null) {
                                    is.close();
                                }
                                if (this.m_dataSess == null) return;
                                this.getFTPServer().releaseDataSession(this.m_dataSess);
                                this.m_dataSess = null;
                                return;
                            }
                            disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                            sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                            if (sts == 2) {
                                this.sendFTPResponse(500, "Invalid path (existing directory)");
                                Object var22_11 = null;
                                if (netFile != null && deleteOnClose) {
                                    netFile.setDeleteOnClose(true);
                                }
                                if (netFile != null && disk != null && tree != null) {
                                    disk.closeFile(this, tree, netFile);
                                }
                                if (is != null) {
                                    is.close();
                                }
                                if (this.m_dataSess == null) return;
                                this.getFTPServer().releaseDataSession(this.m_dataSess);
                                this.m_dataSess = null;
                                return;
                            }
                            int openAction = 16;
                            if (sts == 1) {
                                openAction = !append ? 2 : 1;
                            }
                            FileOpenParams params = new FileOpenParams(ftpPath.getSharePath(), openAction, 2, 0, 0);
                            if (sts == 1) {
                                netFile = disk.openFile(this, tree, params);
                                disk.truncateFile(this, tree, netFile, 0L);
                            } else {
                                netFile = disk.createFile(this, tree, params);
                            }
                            DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                            if (diskCtx.hasChangeHandler()) {
                                diskCtx.getChangeHandler().notifyFileChanged(1, ftpPath.getSharePath());
                            }
                            this.sendFTPResponse(150, "File status okay, about to open data connection");
                            if (this.m_dataSess != null) break block69;
                            this.sendFTPResponse(425, "Can't open data connection");
                            Object var20_27 = null;
                            this.endTransaction();
                            Object var22_12 = null;
                            if (netFile != null && deleteOnClose) {
                                netFile.setDeleteOnClose(true);
                            }
                            if (netFile != null && disk != null && tree != null) {
                                disk.closeFile(this, tree, netFile);
                            }
                            if (is != null) {
                                is.close();
                            }
                            if (this.m_dataSess == null) return;
                            this.getFTPServer().releaseDataSession(this.m_dataSess);
                            this.m_dataSess = null;
                            return;
                        }
                        dataSock = null;
                        try {
                            dataSock = this.m_dataSess.getSocket();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        if (dataSock != null) break block70;
                        this.sendFTPResponse(426, "Connection closed; transfer aborted");
                        Object var20_28 = null;
                        this.endTransaction();
                        Object var22_13 = null;
                        if (netFile != null && deleteOnClose) {
                            netFile.setDeleteOnClose(true);
                        }
                        if (netFile != null && disk != null && tree != null) {
                            disk.closeFile(this, tree, netFile);
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (this.m_dataSess == null) return;
                        this.getFTPServer().releaseDataSession(this.m_dataSess);
                        this.m_dataSess = null;
                        return;
                    }
                    try {
                        is = dataSock.getInputStream();
                        if (this.hasDebug(64)) {
                            this.debugPrintln("Storing ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath() + (append ? " (Append)" : ""));
                        }
                        byte[] buf = new byte[64000];
                        long filePos = 0L;
                        int len = is.read(buf, 0, buf.length);
                        boolean abort = false;
                        if (append) {
                            filePos = netFile.getFileSize();
                        }
                        while (len > 0 && !abort) {
                            if (this.hasDebug(128)) {
                                this.debugPrintln(" Receive len=" + len + " bytes");
                            }
                            disk.writeFile(this, tree, netFile, buf, 0, len, filePos);
                            filePos += (long)len;
                            len = is.read(buf, 0, buf.length);
                            abort = this.checkForAbort();
                        }
                        is.close();
                        is = null;
                        disk.closeFile(this, tree, netFile);
                        netFile = null;
                        if (!abort) {
                            this.sendFTPResponse(226, "Closing data connection");
                        } else {
                            this.sendFTPResponse(426, "Transfer aborted by client");
                        }
                        if (this.hasDebug(128)) {
                            this.debugPrintln(" Transfer complete, file closed");
                        }
                        Object var20_29 = null;
                        this.endTransaction();
                    }
                    catch (Throwable throwable) {
                        Object var20_30 = null;
                        this.endTransaction();
                        throw throwable;
                    }
                    Object var22_14 = null;
                    if (netFile != null && deleteOnClose) {
                        netFile.setDeleteOnClose(true);
                    }
                    if (netFile == null || disk == null || tree == null) break block71;
                }
                catch (SocketException ex) {
                    if (this.hasDebug(256)) {
                        this.debugPrintln(" Error during transfer, " + ex.toString());
                    }
                    if (this.m_dataSess != null) {
                        this.getFTPServer().releaseDataSession(this.m_dataSess);
                        this.m_dataSess = null;
                    }
                    this.sendFTPResponse(426, "Data connection closed by client");
                    Object var22_15 = null;
                    if (netFile != null && deleteOnClose) {
                        netFile.setDeleteOnClose(true);
                    }
                    if (netFile != null && disk != null && tree != null) {
                        disk.closeFile(this, tree, netFile);
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (this.m_dataSess == null) return;
                    this.getFTPServer().releaseDataSession(this.m_dataSess);
                    this.m_dataSess = null;
                    return;
                }
                catch (DiskFullException ex) {
                    if (this.hasDebug(256)) {
                        this.debugPrintln(" Error during transfer, " + ex.toString());
                    }
                    if (this.m_dataSess != null) {
                        this.getFTPServer().releaseDataSession(this.m_dataSess);
                        this.m_dataSess = null;
                    }
                    if (sts != 1) {
                        deleteOnClose = true;
                        if (this.hasDebug(256)) {
                            this.debugPrintln(" Marking file for delete on close (quota exceeded)");
                        }
                    }
                    this.sendFTPResponse(451, "Disk full or Quota Exceeded");
                    Object var22_16 = null;
                    if (netFile != null && deleteOnClose) {
                        netFile.setDeleteOnClose(true);
                    }
                    if (netFile != null && disk != null && tree != null) {
                        disk.closeFile(this, tree, netFile);
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (this.m_dataSess == null) return;
                    this.getFTPServer().releaseDataSession(this.m_dataSess);
                    this.m_dataSess = null;
                    return;
                }
                catch (AccessDeniedException ex) {
                    if (this.hasDebug(256)) {
                        this.debugPrintln(" Error during transfer, " + ex.toString());
                    }
                    if (this.m_dataSess != null) {
                        this.getFTPServer().releaseDataSession(this.m_dataSess);
                        this.m_dataSess = null;
                    }
                    if (sts != 1) {
                        deleteOnClose = true;
                        if (this.hasDebug(256)) {
                            this.debugPrintln(" Marking file for delete on close (access denied)");
                        }
                    }
                    this.sendFTPResponse(451, "Access denied, file may be in use or locked by another user");
                    Object var22_17 = null;
                    if (netFile != null && deleteOnClose) {
                        netFile.setDeleteOnClose(true);
                    }
                    if (netFile != null && disk != null && tree != null) {
                        disk.closeFile(this, tree, netFile);
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (this.m_dataSess == null) return;
                    this.getFTPServer().releaseDataSession(this.m_dataSess);
                    this.m_dataSess = null;
                    return;
                }
                catch (Exception ex) {
                    if (this.hasDebug(256)) {
                        this.debugPrintln(" Error during transfer, " + ex.toString());
                    }
                    this.debugPrintln(ex);
                    this.sendFTPResponse(426, "Error during transmission");
                    Object var22_18 = null;
                    if (netFile != null && deleteOnClose) {
                        netFile.setDeleteOnClose(true);
                    }
                    if (netFile != null && disk != null && tree != null) {
                        disk.closeFile(this, tree, netFile);
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (this.m_dataSess == null) return;
                    this.getFTPServer().releaseDataSession(this.m_dataSess);
                    this.m_dataSess = null;
                    return;
                }
                disk.closeFile(this, tree, netFile);
            }
            if (is != null) {
                is.close();
            }
            if (this.m_dataSess == null) return;
            this.getFTPServer().releaseDataSession(this.m_dataSess);
            this.m_dataSess = null;
            return;
        }
        catch (Throwable throwable) {
            Object var22_19 = null;
            if (netFile != null && deleteOnClose) {
                netFile.setDeleteOnClose(true);
            }
            if (netFile != null && disk != null && tree != null) {
                disk.closeFile(this, tree, netFile);
            }
            if (is != null) {
                is.close();
            }
            if (this.m_dataSess == null) throw throwable;
            this.getFTPServer().releaseDataSession(this.m_dataSess);
            this.m_dataSess = null;
            throw throwable;
        }
    }

    protected final void procDeleteFile(FTPRequest req) throws IOException {
        block9: {
            if (!this.isLoggedOn()) {
                this.sendFTPNotLoggedOnResponse();
                return;
            }
            if (!req.hasArgument()) {
                this.sendFTPResponse(501, "Syntax error, parameter required");
                return;
            }
            FTPPath ftpPath = this.generatePathForRequest(req, true);
            if (ftpPath == null) {
                this.sendFTPResponse(550, "Invalid path specified");
                return;
            }
            DiskInterface disk = null;
            TreeConnection tree = null;
            try {
                tree = this.getTreeConnection(ftpPath.getSharedDevice());
                if (tree == null || !tree.hasWriteAccess()) {
                    this.sendFTPResponse(550, "Access denied");
                    return;
                }
                disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                if (sts == 1) {
                    disk.deleteFile(this, tree, ftpPath.getSharePath());
                    DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                    if (diskCtx.hasChangeHandler()) {
                        diskCtx.getChangeHandler().notifyFileChanged(2, ftpPath.getSharePath());
                    }
                    if (this.hasDebug(64)) {
                        this.debugPrintln("Deleted ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath());
                    }
                    break block9;
                }
                this.sendFTPResponse(550, "File " + req.getArgument() + (sts == 0 ? " not available" : " is a directory"));
                return;
            }
            catch (Exception ex) {
                this.sendFTPResponse(450, "File action not taken");
                return;
            }
        }
        this.sendFTPResponse(250, "File " + req.getArgument() + " deleted");
    }

    protected final void procRenameFrom(FTPRequest req) throws IOException {
        block8: {
            if (!this.isLoggedOn()) {
                this.sendFTPNotLoggedOnResponse();
                return;
            }
            if (!req.hasArgument()) {
                this.sendFTPResponse(501, "Syntax error, parameter required");
                return;
            }
            this.m_renameFrom = null;
            FTPPath ftpPath = this.generatePathForRequest(req, false, false);
            if (ftpPath == null) {
                this.sendFTPResponse(550, "Invalid path specified");
                return;
            }
            DiskInterface disk = null;
            TreeConnection tree = null;
            try {
                tree = this.getTreeConnection(ftpPath.getSharedDevice());
                if (tree == null || !tree.hasWriteAccess()) {
                    this.sendFTPResponse(550, "Access denied");
                    return;
                }
                disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                if (sts != 0) {
                    this.m_renameFrom = ftpPath;
                    if (this.hasDebug(64)) {
                        this.debugPrintln("RenameFrom ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath());
                    }
                    break block8;
                }
                this.sendFTPResponse(550, "File " + req.getArgument() + (sts == 0 ? " not available" : " is a directory"));
                return;
            }
            catch (Exception ex) {
                this.sendFTPResponse(450, "File action not taken");
                return;
            }
        }
        this.sendFTPResponse(350, "File " + req.getArgument() + " OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procRenameTo(FTPRequest req) throws IOException {
        block13: {
            if (!this.isLoggedOn()) {
                this.sendFTPNotLoggedOnResponse();
                return;
            }
            if (!req.hasArgument()) {
                this.sendFTPResponse(501, "Syntax error, parameter required");
                return;
            }
            if (this.m_renameFrom == null) {
                this.sendFTPResponse(550, "Rename from not set");
                return;
            }
            FTPPath ftpPath = this.generatePathForRequest(req, true, false);
            if (ftpPath == null) {
                this.sendFTPResponse(550, "Invalid path specified");
                return;
            }
            if (this.m_renameFrom.getShareName().compareTo(ftpPath.getShareName()) != 0) {
                this.sendFTPResponse(550, "Cannot rename across shares");
                return;
            }
            DiskInterface disk = null;
            TreeConnection tree = null;
            try {
                try {
                    tree = this.getTreeConnection(ftpPath.getSharedDevice());
                    if (tree == null || !tree.hasWriteAccess()) {
                        this.sendFTPResponse(550, "Access denied");
                        Object var8_5 = null;
                        this.m_renameFrom = null;
                        return;
                    }
                    disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                    int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                    if (sts == 0) {
                        disk.renameFile(this, tree, this.m_renameFrom.getSharePath(), ftpPath.getSharePath());
                        DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                        if (diskCtx.hasChangeHandler()) {
                            diskCtx.getChangeHandler().notifyRename(this.m_renameFrom.getSharePath(), ftpPath.getSharePath());
                        }
                        if (this.hasDebug(64)) {
                            this.debugPrintln("RenameTo ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath());
                        }
                        break block13;
                    }
                    this.sendFTPResponse(550, "File " + req.getArgument() + (sts == 0 ? " not available" : " is a directory"));
                }
                catch (Exception ex) {
                    this.sendFTPResponse(450, "File action not taken");
                    Object var8_8 = null;
                    this.m_renameFrom = null;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.m_renameFrom = null;
                throw throwable;
            }
            Object var8_6 = null;
            this.m_renameFrom = null;
            return;
        }
        Object var8_7 = null;
        this.m_renameFrom = null;
        this.sendFTPResponse(250, "File renamed OK");
    }

    protected final void procCreateDirectory(FTPRequest req) throws IOException {
        FTPPath ftpPath;
        block9: {
            if (!this.isLoggedOn()) {
                this.sendFTPNotLoggedOnResponse();
                return;
            }
            if (!req.hasArgument()) {
                this.sendFTPResponse(501, "Syntax error, parameter required");
                return;
            }
            ftpPath = this.generatePathForRequest(req, false, false);
            if (ftpPath == null) {
                this.sendFTPResponse(550, "Invalid path " + req.getArgument());
                return;
            }
            DiskInterface disk = null;
            TreeConnection tree = null;
            try {
                tree = this.getTreeConnection(ftpPath.getSharedDevice());
                if (tree == null || !tree.hasWriteAccess()) {
                    this.sendFTPResponse(550, "Access denied");
                    return;
                }
                disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                if (sts == 0) {
                    FileOpenParams params = new FileOpenParams(ftpPath.getSharePath(), 16, 2, 16, 0);
                    disk.createDirectory(this, tree, params);
                    DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                    if (diskCtx.hasChangeHandler()) {
                        diskCtx.getChangeHandler().notifyFileChanged(1, ftpPath.getSharePath());
                    }
                    if (this.hasDebug(4096)) {
                        this.debugPrintln("CreateDir ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath());
                    }
                    break block9;
                }
                this.sendFTPResponse(450, sts == 1 ? "File exists with that name" : "Directory already exists");
                return;
            }
            catch (Exception ex) {
                this.sendFTPResponse(450, "Failed to create directory");
                return;
            }
        }
        this.sendFTPResponse(257, ftpPath.getFTPPath());
    }

    protected final void procRemoveDirectory(FTPRequest req) throws IOException {
        block10: {
            if (!this.isLoggedOn()) {
                this.sendFTPNotLoggedOnResponse();
                return;
            }
            if (!req.hasArgument()) {
                this.sendFTPResponse(501, "Syntax error, parameter required");
                return;
            }
            FTPPath ftpPath = this.generatePathForRequest(req, false);
            if (ftpPath == null) {
                this.sendFTPResponse(550, "Invalid path " + req.getArgument());
                return;
            }
            if (ftpPath.isRootPath() || ftpPath.isRootSharePath()) {
                this.sendFTPResponse(550, "Access denied, cannot delete directory in root");
                return;
            }
            DiskInterface disk = null;
            TreeConnection tree = null;
            try {
                tree = this.getTreeConnection(ftpPath.getSharedDevice());
                if (tree == null || !tree.hasWriteAccess()) {
                    this.sendFTPResponse(550, "Access denied");
                    return;
                }
                disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                if (sts == 2) {
                    disk.deleteDirectory(this, tree, ftpPath.getSharePath());
                    DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                    if (diskCtx.hasChangeHandler()) {
                        diskCtx.getChangeHandler().notifyFileChanged(2, ftpPath.getSharePath());
                    }
                    if (this.hasDebug(4096)) {
                        this.debugPrintln("DeleteDir ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath());
                    }
                    break block10;
                }
                this.sendFTPResponse(550, sts == 1 ? "File exists with that name" : "Directory does not exist");
                return;
            }
            catch (Exception ex) {
                this.sendFTPResponse(550, "Failed to delete directory");
                return;
            }
        }
        this.sendFTPResponse(250, "Directory deleted OK");
    }

    protected final void procMachineListing(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPResponse(530, "Not logged in");
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Syntax error, parameter required");
            return;
        }
        FTPPath ftpPath = this.generatePathForRequest(req, false, true);
        if (ftpPath == null) {
            this.sendFTPResponse(500, "Invalid path");
            return;
        }
        DiskInterface disk = null;
        TreeConnection tree = null;
        try {
            tree = this.getTreeConnection(ftpPath.getSharedDevice());
            disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
            FileInfo finfo = disk.getFileInformation(this, tree, ftpPath.getSharePath());
            if (finfo == null) {
                this.sendFTPResponse(550, "Path " + req.getArgument() + " not available");
                return;
            }
            if (!finfo.isDirectory()) {
                this.sendFTPResponse(501, "Path " + req.getArgument() + " is not a directory");
                return;
            }
            this.sendFTPResponse("250- Listing " + req.getArgument());
            StringBuffer mlstStr = new StringBuffer(80);
            mlstStr.append(" ");
            this.generateMlstString(finfo, this.m_mlstFacts, mlstStr, true);
            mlstStr.append(CRLF);
            this.sendFTPResponse(mlstStr.toString());
            this.sendFTPResponse("250 End");
            if (this.hasDebug(64)) {
                this.debugPrintln("Mlst ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", info=" + finfo);
            }
        }
        catch (Exception ex) {
            this.sendFTPResponse(550, "Error retrieving file information");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procMachineListingContents(FTPRequest req) throws IOException {
        block20: {
            TreeConnection tree;
            if (!this.isLoggedOn()) {
                this.sendFTPNotLoggedOnResponse();
                return;
            }
            if (!req.hasArgument()) {
                req.updateArgument(".");
            }
            FTPPath ftpPath = this.m_cwd;
            if (req.hasArgument()) {
                ftpPath = this.generatePathForRequest(req, true);
            }
            if (ftpPath == null) {
                this.sendFTPResponse(500, "Invalid path");
                return;
            }
            if (!(ftpPath.isRootPath() || (tree = this.getTreeConnection(ftpPath.getSharedDevice())) != null && tree.hasReadAccess())) {
                this.sendFTPResponse(550, "Access denied");
                return;
            }
            this.sendFTPResponse(150, "File status okay, about to open data connection");
            if (this.m_dataSess == null) {
                this.sendFTPResponse(425, "Can't open data connection");
                return;
            }
            Socket dataSock = null;
            try {
                dataSock = this.m_dataSess.getSocket();
            }
            catch (Exception ex) {
                this.debugPrintln(ex);
            }
            if (dataSock == null) {
                this.sendFTPResponse(426, "Connection closed; transfer aborted");
                return;
            }
            Writer dataWrt = null;
            try {
                try {
                    dataWrt = this.isUTF8Enabled() ? new OutputStreamWriter(dataSock.getOutputStream(), "UTF-8") : new OutputStreamWriter(dataSock.getOutputStream());
                    Vector<Object> files = null;
                    files = this.listFilesForPath(ftpPath, false, false);
                    if (files != null) {
                        if (this.hasDebug(16)) {
                            this.debugPrintln("MLsd found " + files.size() + " files in " + ftpPath.getFTPPath());
                        }
                        StringBuffer str = new StringBuffer(4096);
                        for (int i = 0; i < files.size(); ++i) {
                            FileInfo finfo = (FileInfo)files.elementAt(i);
                            this.generateMlstString(finfo, this.m_mlstFacts, str, false);
                            str.append(CRLF);
                            if (str.length() < 4096) continue;
                            dataWrt.write(str.toString());
                            str.setLength(0);
                        }
                        if (str.length() > 0) {
                            dataWrt.write(str.toString());
                        }
                    }
                    this.sendFTPResponse(226, "Closing data connection");
                }
                catch (Exception ex) {
                    this.sendFTPResponse(451, "Error reading file list");
                    Object var10_12 = null;
                    if (dataWrt != null) {
                        dataWrt.close();
                    }
                    if (this.m_dataSess == null) return;
                    this.getFTPServer().releaseDataSession(this.m_dataSess);
                    this.m_dataSess = null;
                    return;
                }
                Object var10_11 = null;
                if (dataWrt == null) break block20;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (dataWrt != null) {
                    dataWrt.close();
                }
                if (this.m_dataSess == null) throw throwable;
                this.getFTPServer().releaseDataSession(this.m_dataSess);
                this.m_dataSess = null;
                throw throwable;
            }
            dataWrt.close();
        }
        if (this.m_dataSess == null) return;
        this.getFTPServer().releaseDataSession(this.m_dataSess);
        this.m_dataSess = null;
    }

    protected final void procModifyDateTime(FTPRequest req) throws IOException {
        FTPPath ftpPath;
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Syntax error, parameter required");
            return;
        }
        String path = req.getArgument();
        long modifyDateTime = 0L;
        if (path.length() > 14 && path.indexOf(32) != -1) {
            boolean settime = true;
            for (int i = 0; i < 14; ++i) {
                if (Character.isDigit(path.charAt(i))) continue;
                settime = false;
            }
            if (settime) {
                try {
                    int year = Integer.valueOf(path.substring(0, 4));
                    int month = Integer.valueOf(path.substring(4, 6));
                    int day = Integer.valueOf(path.substring(6, 8));
                    int hours = Integer.valueOf(path.substring(8, 10));
                    int mins = Integer.valueOf(path.substring(10, 12));
                    int secs = Integer.valueOf(path.substring(12, 14));
                    int millis = 0;
                    int sep = path.indexOf(32, 14);
                    if (path.charAt(14) == '.') {
                        millis = Integer.valueOf(path.substring(15, sep));
                    }
                    Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    cal.set(year, month, day, hours, mins, secs);
                    if (millis != 0) {
                        cal.set(14, millis);
                    }
                    modifyDateTime = cal.getTimeInMillis();
                    path = path.substring(sep + 1);
                    req.updateArgument(path);
                    if (this.hasDebug(64)) {
                        this.debugPrintln("Modify date/time arg=" + path + ", utcTime=" + modifyDateTime);
                    }
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        if ((ftpPath = this.generatePathForRequest(req, true)) == null) {
            this.sendFTPResponse(550, "Invalid path");
            return;
        }
        DiskInterface disk = null;
        TreeConnection tree = null;
        try {
            FileInfo finfo;
            tree = this.getTreeConnection(ftpPath.getSharedDevice());
            disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
            if (modifyDateTime != 0L) {
                FileInfo finfo2 = new FileInfo();
                finfo2.setModifyDateTime(modifyDateTime);
                finfo2.setFileInformationFlags(8);
                disk.setFileInformation(this, tree, ftpPath.getSharePath(), finfo2);
            }
            if ((finfo = disk.getFileInformation(this, tree, ftpPath.getSharePath())) == null) {
                this.sendFTPResponse(550, "File " + req.getArgument() + " not available");
                return;
            }
            if (finfo.hasModifyDateTime()) {
                this.sendFTPResponse(213, FTPDate.packMlstDateTime(finfo.getModifyDateTime()));
            } else {
                this.sendFTPResponse(550, "Modification date/time not available for " + finfo.getFileName());
            }
            if (this.hasDebug(64)) {
                this.debugPrintln("File modify date/time ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", modified=" + finfo.getModifyDateTime());
            }
        }
        catch (Exception ex) {
            this.sendFTPResponse(550, "Error retrieving file modification date/time");
        }
    }

    protected final void procFeatures(FTPRequest req) throws IOException {
        this.sendFTPResponse("211-Features supported");
        this.sendFTPResponse(" MDTM");
        this.sendFTPResponse(" SIZE");
        this.sendFTPResponse(" UTF8");
        StringBuffer mlstStr = new StringBuffer();
        mlstStr.append(" MLST ");
        for (int i = 0; i < _factNames.length; ++i) {
            mlstStr.append(_factNames[i]);
            if ((0x7F & 1 << i) != 0) {
                mlstStr.append("*");
            }
            mlstStr.append(";");
        }
        this.sendFTPResponse(mlstStr.toString());
        this.sendFTPResponse(" MLSD");
        this.sendFTPResponse(" AUTH TLS");
        this.sendFTPResponse(211, "END");
    }

    protected final void procFileSize(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Syntax error, parameter required");
            return;
        }
        FTPPath ftpPath = this.generatePathForRequest(req, true);
        if (ftpPath == null) {
            this.sendFTPResponse(550, "Invalid path");
            return;
        }
        DiskInterface disk = null;
        TreeConnection tree = null;
        try {
            tree = this.getTreeConnection(ftpPath.getSharedDevice());
            disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
            FileInfo finfo = disk.getFileInformation(this, tree, ftpPath.getSharePath());
            if (finfo == null) {
                this.sendFTPResponse(550, "File " + req.getArgument() + " not available");
                return;
            }
            this.sendFTPResponse(213, "" + finfo.getSize());
            if (this.hasDebug(64)) {
                this.debugPrintln("File size ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", size=" + finfo.getSize());
            }
        }
        catch (Exception ex) {
            this.sendFTPResponse(550, "Error retrieving file size");
        }
    }

    protected final void procSite(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        if (this.getFTPServer().hasSiteInterface()) {
            FTPSiteInterface siteInterface = this.getFTPServer().getSiteInterface();
            siteInterface.processFTPSiteCommand(this, req);
        } else {
            this.sendFTPResponse(501, "SITE commands not implemented");
        }
    }

    protected final void procStructure(FTPRequest req) throws IOException {
        if (req.hasArgument() && req.getArgument().equalsIgnoreCase("F")) {
            this.sendFTPResponse(200, "OK");
        } else {
            this.sendFTPResponse(504, "Obsolete");
        }
    }

    protected final void procMode(FTPRequest req) throws IOException {
        if (req.hasArgument() && req.getArgument().equalsIgnoreCase("S")) {
            this.sendFTPResponse(200, "OK");
        } else {
            this.sendFTPResponse(504, "Obsolete");
        }
    }

    protected final void procAllocate(FTPRequest req) throws IOException {
        this.sendFTPResponse(202, "Obsolete");
    }

    protected final void procAbort(FTPRequest req) throws IOException {
        this.sendFTPResponse(226, "No active transfer to abort");
    }

    protected final void procAuth(FTPRequest req) throws IOException {
        if (!this.getFTPServer().getFTPConfiguration().isFTPSEnabled()) {
            this.sendFTPResponse(534, "SSL/TLS sessions not available");
            return;
        }
        try {
            if (req.hasArgument()) {
                String engineTyp = req.getArgument().toUpperCase();
                if (engineTyp.equals("SSL") || engineTyp.equals("TLS")) {
                    this.setupSSLEngine(engineTyp);
                    this.sendUnencryptedFTPResponse(234, "Switching to " + engineTyp + " secure session");
                }
            } else {
                this.sendFTPResponse(421, "Failed to negotiate SSL/TLS, type not specified");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.m_sslEngine = null;
            this.sendFTPResponse(421, "Failed to negotiate SSL/TLS");
        }
    }

    protected final void procProtectedBufferSize(FTPRequest req) throws IOException {
        if (this.m_sslEngine == null) {
            this.sendFTPResponse(503, "Not using secure connection");
            return;
        }
        String arg = req.getArgument();
        if (arg == null || arg.length() == 0) {
            this.sendFTPResponse(501, "Empty buffer size argument");
            return;
        }
        try {
            this.m_pbSize = Integer.parseInt(arg);
        }
        catch (NumberFormatException ex) {
            this.sendFTPResponse(501, "Invalid buffer size argument");
            return;
        }
        this.sendFTPResponse(200, "Buffer size ok");
    }

    protected final void procDataChannelProtection(FTPRequest req) throws IOException {
        if (this.m_pbSize == -1) {
            this.sendFTPResponse(503, "Protected buffer size not negotiated");
            return;
        }
        String arg = req.getArgument().toUpperCase();
        if (arg == null || ProtLevels.indexOf(arg) == -1) {
            this.sendFTPResponse(504, "Invalid protection level, " + arg);
            return;
        }
        if (arg.equals(ProtLevelClear)) {
            this.sendFTPResponse(200, "Protection level accepted");
        } else {
            this.sendFTPResponse(534, "Protected data connections not supported");
        }
    }

    protected final void procClearCommandChannel(FTPRequest ftpReq) throws IOException {
        if (this.m_sslEngine == null) {
            this.sendFTPResponse(533, "Not using secure connection");
            return;
        }
        this.sendFTPResponse(200, "Secure connection closed");
        this.m_sslEngine.closeOutbound();
        this.getSSLCommand(this.m_inbuf, 0);
        this.m_sslEngine = null;
        this.m_sslContext = null;
        this.m_sslIn = null;
        this.m_sslOut = null;
    }

    protected final void procExtendedPort(FTPRequest req) throws IOException {
        InetSocketAddress clientAddr;
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Required argument missing");
            return;
        }
        try {
            clientAddr = this.parseExtendedAddress(req.getArgument());
        }
        catch (Exception ex) {
            this.sendFTPResponse(501, ex.getMessage());
            return;
        }
        if (this.hasDebug(2048)) {
            this.debugPrintln("Opening data socket addr=" + clientAddr.getAddress() + ", port=" + clientAddr.getPort());
        }
        this.m_dataSess = this.getFTPServer().allocateDataSession(this, clientAddr.getAddress(), clientAddr.getPort());
        this.sendFTPResponse(200, "Port OK");
        if (this.hasDebug(2048)) {
            this.debugPrintln("Extended port open addr=" + clientAddr.getAddress() + ", port=" + clientAddr.getPort());
        }
    }

    protected final void procExtendedPassive(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPNotLoggedOnResponse();
            return;
        }
        try {
            this.m_dataSess = this.getFTPServer().allocatePassiveDataSession(this, this.m_sock.getLocalAddress());
        }
        catch (IOException ex) {
            this.m_dataSess = null;
        }
        if (this.m_dataSess == null) {
            this.sendFTPResponse(550, "Requested action not taken");
            return;
        }
        int pasvPort = this.m_dataSess.getPassivePort();
        StringBuffer msg = new StringBuffer();
        msg.append("229 Entering Extended Passive Mode (|||");
        msg.append(pasvPort);
        msg.append("|)");
        this.sendFTPResponse(msg);
        if (this.hasDebug(2048)) {
            this.debugPrintln("Extended passive open addr=" + this.m_sock.getLocalAddress() + ", port=" + pasvPort);
        }
    }

    private final InetSocketAddress parseExtendedAddress(String extAddr) {
        if (extAddr == null || extAddr.length() < 7) {
            throw new IllegalArgumentException("Invalid argument");
        }
        StringTokenizer tokens = new StringTokenizer(extAddr, extAddr.substring(0, 1));
        if (tokens.countTokens() < 3) {
            throw new IllegalArgumentException("Invalid argument");
        }
        String netType = tokens.nextToken();
        String netAddr = tokens.nextToken();
        String netPort = tokens.nextToken();
        int afNumber = 0;
        try {
            afNumber = Integer.parseInt(netType);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (afNumber == 1 || afNumber == 2) {
            InetSocketAddress sockAddr = null;
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(netAddr);
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
            InetAddress remoteAddr = this.m_sock.getInetAddress();
            if (!addr.equals(remoteAddr)) {
                if (this.hasDebug(2048)) {
                    this.debugPrintln("EPRT address [" + addr + "] is not equals to client address [" + remoteAddr + "]. For security purposes client address is used for data transmition.");
                }
                addr = remoteAddr;
            }
            if (addr != null && addr instanceof Inet6Address) {
                try {
                    addr = InetAddress.getByAddress(addr.getAddress());
                }
                catch (UnknownHostException ex) {
                    throw new IllegalArgumentException("Unknown host");
                }
            }
            int port = -1;
            try {
                port = Integer.parseInt(netPort);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (port != -1) {
                sockAddr = new InetSocketAddress(addr, port);
            }
            return sockAddr;
        }
        throw new IllegalArgumentException("Invalid address/port argument");
    }

    protected final Vector<Object> listFilesForPath(FTPPath path, boolean nameOnly, boolean hidden) {
        Vector<Object> files;
        block11: {
            block12: {
                if (path == null) {
                    return null;
                }
                files = new Vector<Object>();
                if (path.hasSharedDevice()) break block12;
                SharedDeviceList shares = this.getShareList();
                if (shares == null) break block11;
                Enumeration<SharedDevice> enm = shares.enumerateShares();
                while (enm.hasMoreElements()) {
                    SharedDevice shr = enm.nextElement();
                    if (!nameOnly) {
                        FileInfo finfo = new FileInfo(shr.getName(), 0L, 16);
                        files.add(finfo);
                        continue;
                    }
                    files.add(shr.getName());
                }
                break block11;
            }
            String searchPath = path.getSharePath();
            if (path.isDirectory()) {
                searchPath = path.makeSharePathToFile("*.*");
            }
            TreeConnection tree = new TreeConnection(path.getSharedDevice());
            DiskInterface disk = null;
            SearchContext ctx = null;
            int searchAttr = 16;
            if (hidden) {
                searchAttr += 2;
            }
            try {
                disk = (DiskInterface)path.getSharedDevice().getInterface();
                ctx = disk.startSearch(this, tree, searchPath, searchAttr);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (ctx != null) {
                while (ctx.hasMoreFiles()) {
                    if (nameOnly) {
                        files.addElement(ctx.nextFileName());
                        continue;
                    }
                    FileInfo finfo = new FileInfo();
                    if (ctx.nextFileInfo(finfo)) {
                        if (finfo.getFileName() == null) continue;
                        files.addElement(finfo);
                        continue;
                    }
                    break;
                }
            }
        }
        return files;
    }

    protected final SharedDeviceList getShareList() {
        if (this.m_shares == null) {
            SharedDeviceList shares = this.getFTPServer().getShareMapper().getShareList(this.getFTPServer().getServerName(), this, false);
            this.m_shares = new SharedDeviceList();
            Enumeration<SharedDevice> enm = shares.enumerateShares();
            while (enm.hasMoreElements()) {
                SharedDevice shr = enm.nextElement();
                if (!(shr instanceof DiskSharedDevice)) continue;
                this.m_shares.addShare(shr);
            }
            if (this.getServer().hasAccessControlManager()) {
                AccessControlManager aclMgr = this.getServer().getAccessControlManager();
                this.m_shares = aclMgr.filterShareList(this, this.m_shares);
            }
        }
        return this.m_shares;
    }

    protected final TreeConnection getTreeConnection(SharedDevice share) {
        if (share == null) {
            return null;
        }
        TreeConnection tree = this.m_connections.findConnection(share.getName());
        if (tree == null) {
            tree = new TreeConnection(share);
            this.m_connections.addConnection(tree);
            if (this.getServer().hasAccessControlManager()) {
                AccessControlManager aclMgr = this.getServer().getAccessControlManager();
                int access = aclMgr.checkAccessControl(this, share);
                if (access != -1) {
                    tree.setPermission(access);
                }
            } else {
                tree.setPermission(2);
            }
        }
        return tree;
    }

    private final boolean checkForAbort() {
        block5: {
            try {
                FTPRequest ftpReq;
                if (this.m_in.available() > 0 && (ftpReq = this.getNextCommand(false)) != null) {
                    if (ftpReq.isCommand() == 21) {
                        if (this.hasDebug(128)) {
                            this.debugPrintln("Transfer aborted by client");
                        }
                        return true;
                    }
                    this.m_ftpCmdList.add(ftpReq);
                }
            }
            catch (IOException ex) {
                if (!this.hasDebug(256)) break block5;
                this.debugPrintln("Error during check for abort, " + ex.toString());
            }
        }
        return false;
    }

    private final FTPRequest getNextCommand(boolean checkQueue) throws SocketException, IOException {
        FTPRequest nextReq = null;
        if (checkQueue && this.m_ftpCmdList.size() > 0) {
            nextReq = this.m_ftpCmdList.remove(0);
        } else {
            while (nextReq == null) {
                int rdlen = this.m_in.read(this.m_inbuf);
                if (rdlen == -1) {
                    this.closeSession();
                    return null;
                }
                if (rdlen == this.m_inbuf.length) {
                    if (this.m_inbuf.length < 65535) {
                        int curLen = this.m_inbuf.length;
                        int availLen = this.m_in.available();
                        int newLen = Math.max(this.m_inbuf.length * 2, curLen + availLen + 50);
                        if (newLen > 65535) {
                            newLen = 65535;
                        }
                        if (newLen > curLen + availLen) {
                            int rdlen2;
                            byte[] newbuf = new byte[newLen];
                            System.arraycopy(this.m_inbuf, 0, newbuf, 0, this.m_inbuf.length);
                            this.m_inbuf = newbuf;
                            if (this.hasDebug(2)) {
                                this.debugPrintln("Extended command buffer to " + this.m_inbuf.length + " bytes");
                            }
                            if ((rdlen2 = this.m_in.read(this.m_inbuf, curLen, this.m_inbuf.length - curLen)) == -1) {
                                this.closeSession();
                                return null;
                            }
                            rdlen += rdlen2;
                            if (this.hasDebug(2)) {
                                this.debugPrintln("Secondary read " + rdlen2 + " bytes, total bytes read " + rdlen);
                            }
                        }
                    } else {
                        this.clearCommandSocket();
                        if (this.hasDebug(2)) {
                            this.debugPrintln("Received command too large, ignored");
                        }
                        return null;
                    }
                }
                if (this.m_sslEngine != null) {
                    rdlen = this.getSSLCommand(this.m_inbuf, rdlen);
                }
                if (rdlen <= 0) continue;
                while (rdlen > 0 && this.m_inbuf[rdlen - 1] == 13 || this.m_inbuf[rdlen - 1] == 10) {
                    --rdlen;
                }
                String cmd = null;
                cmd = this.isUTF8Enabled() ? this.m_normalizer.normalize(new String(this.m_inbuf, 0, rdlen, "UTF8")) : new String(this.m_inbuf, 0, rdlen);
                nextReq = new FTPRequest(cmd);
            }
        }
        return nextReq;
    }

    protected void clearCommandSocket() throws IOException {
        int rdlen = 0;
        while (this.m_in.available() > 0 && rdlen >= 0) {
            rdlen = this.m_in.read(this.m_inbuf);
            if (rdlen != -1) continue;
            this.closeSession();
        }
    }

    protected final int getSSLCommand(byte[] buf, int len) throws SocketException, IOException {
        this.m_sslIn.limit(this.m_sslIn.capacity());
        this.m_sslIn.position(len);
        this.m_sslIn.flip();
        this.m_sslOut.clear();
        SSLEngineResult sslRes = this.m_sslEngine.unwrap(this.m_sslIn, this.m_sslOut);
        if (this.hasDebug(8192)) {
            this.debugPrintln("SSL unwrap() len=" + len + ", returned " + sslRes.bytesProduced() + " bytes, res=" + sslRes);
        }
        int unwrapLen = sslRes.bytesProduced();
        boolean loopDone = false;
        Runnable task = null;
        while (!loopDone && this.m_sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && sslRes.getStatus() != SSLEngineResult.Status.CLOSED) {
            switch (this.m_sslEngine.getHandshakeStatus()) {
                case NEED_TASK: {
                    if (this.hasDebug(8192)) {
                        this.debugPrintln("SSL engine status=NEED_TASK");
                    }
                    while ((task = this.m_sslEngine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    break;
                }
                case NEED_WRAP: {
                    if (this.hasDebug(8192)) {
                        this.debugPrintln("SSL engine status=NEED_WRAP");
                    }
                    this.m_sslIn.limit(this.m_sslIn.capacity());
                    this.m_sslIn.flip();
                    this.m_sslOut.clear();
                    while (this.m_sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                        sslRes = this.m_sslEngine.wrap(this.m_sslIn, this.m_sslOut);
                        if (!this.hasDebug(8192)) continue;
                        this.debugPrintln("  wrap() returned " + sslRes.bytesProduced() + " bytes, res=" + sslRes);
                    }
                    this.m_sslOut.flip();
                    if (this.m_sslOut.remaining() <= 0) break;
                    if (this.hasDebug(8192)) {
                        this.debugPrintln("  Send data to client = " + this.m_sslOut.remaining());
                    }
                    this.m_sock.getOutputStream().write(this.m_sslOut.array(), 0, this.m_sslOut.remaining());
                    this.m_sock.getOutputStream().flush();
                    break;
                }
                case NEED_UNWRAP: {
                    int rdlen;
                    if (this.hasDebug(8192)) {
                        this.debugPrintln("SSL engine status=NEED_UNWRAP");
                    }
                    if ((rdlen = this.m_in.read(this.m_inbuf)) == -1) {
                        if (this.hasDebug(8192)) {
                            this.debugPrintln("  Socket read returned -1, closing session");
                        }
                        this.closeSession();
                        return 0;
                    }
                    this.m_sslIn.limit(this.m_sslIn.capacity());
                    this.m_sslIn.position(rdlen);
                    this.m_sslIn.flip();
                    while (this.m_sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && this.m_sslIn.remaining() > 0) {
                        this.m_sslOut.limit(this.m_sslOut.capacity());
                        sslRes = this.m_sslEngine.unwrap(this.m_sslIn, this.m_sslOut);
                        if (this.hasDebug(8192)) {
                            this.debugPrintln("  unwrap() len=" + rdlen + ",returned " + sslRes.bytesProduced() + " bytes, res=" + sslRes);
                        }
                        if (this.m_sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                        while ((task = this.m_sslEngine.getDelegatedTask()) != null) {
                            task.run();
                            if (!this.hasDebug(8192)) continue;
                            this.debugPrintln("  task during unwrap");
                        }
                    }
                    this.m_sslOut.flip();
                    if (this.m_sslOut.remaining() <= 0) break;
                    if (this.m_sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                        unwrapLen = this.m_sslOut.remaining();
                        loopDone = true;
                        break;
                    }
                    if (this.hasDebug(8192)) {
                        this.debugPrintln("  Send data to client = " + this.m_sslOut.remaining());
                    }
                    this.m_sock.getOutputStream().write(this.m_sslOut.array(), 0, this.m_sslOut.remaining());
                    this.m_sock.getOutputStream().flush();
                    break;
                }
                case NOT_HANDSHAKING: {
                    if (this.hasDebug(8192)) {
                        this.debugPrintln("SSL engine status=NOT_HANDSHAKING");
                    }
                    loopDone = true;
                    break;
                }
                case FINISHED: {
                    if (this.hasDebug(8192)) {
                        this.debugPrintln("SSL engine status=FINISHED");
                    }
                    loopDone = true;
                }
            }
        }
        if (unwrapLen > 0) {
            System.arraycopy(this.m_sslOut.array(), 0, this.m_inbuf, 0, unwrapLen);
        }
        return unwrapLen;
    }

    protected final void setupSSLEngine(String engineTyp) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        FTPConfigSection ftpConfig = this.getFTPServer().getFTPConfiguration();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        KeyStore trustStore = KeyStore.getInstance("JKS");
        char[] passphrase = ftpConfig.getPassphrase();
        keyStore.load(new FileInputStream(ftpConfig.getKeyStorePath()), passphrase);
        trustStore.load(new FileInputStream(ftpConfig.getTrustStorePath()), passphrase);
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(defaultAlgorithm);
        keyFactory.init(keyStore, passphrase);
        defaultAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(defaultAlgorithm);
        trustFactory.init(trustStore);
        this.m_sslContext = SSLContext.getInstance(engineTyp);
        this.m_sslContext.init(keyFactory.getKeyManagers(), trustFactory.getTrustManagers(), null);
        this.m_sslEngine = this.m_sslContext.createSSLEngine();
        this.m_sslEngine.setUseClientMode(false);
        this.m_sslEngine.setWantClientAuth(true);
        SSLSession sslSess = this.m_sslEngine.getSession();
        this.m_sslOut = ByteBuffer.allocate(sslSess.getApplicationBufferSize() + 50);
        if (this.m_inbuf.length < sslSess.getApplicationBufferSize()) {
            this.m_inbuf = new byte[sslSess.getApplicationBufferSize()];
        }
        this.m_sslIn = ByteBuffer.wrap(this.m_inbuf);
    }

    protected final boolean isSecureSession() {
        return this.m_sslEngine != null;
    }

    protected final void generateMlstString(FileInfo finfo, int mlstFlags, StringBuffer buf, boolean isMlsd) {
        block8: for (int i = 0; i < _factNames.length; ++i) {
            int curFact = 1 << i;
            if ((mlstFlags & curFact) == 0) continue;
            switch (curFact) {
                case 1: {
                    buf.append(_factNames[i]);
                    buf.append("=");
                    buf.append(finfo.getSize());
                    buf.append(";");
                    continue block8;
                }
                case 2: {
                    if (!finfo.hasModifyDateTime()) continue block8;
                    buf.append(_factNames[i]);
                    buf.append("=");
                    buf.append(FTPDate.packMlstDateTime(finfo.getModifyDateTime()));
                    buf.append(";");
                    continue block8;
                }
                case 4: {
                    if (!finfo.hasCreationDateTime()) continue block8;
                    buf.append(_factNames[i]);
                    buf.append("=");
                    buf.append(FTPDate.packMlstDateTime(finfo.getCreationDateTime()));
                    buf.append(";");
                    continue block8;
                }
                case 8: {
                    buf.append(_factNames[i]);
                    if (!finfo.isDirectory()) {
                        buf.append("=file;");
                        continue block8;
                    }
                    buf.append("=dir;");
                    continue block8;
                }
                case 16: {
                    if (finfo.getFileId() == -1) continue block8;
                    buf.append(_factNames[i]);
                    buf.append("=");
                    buf.append(finfo.getFileId());
                    buf.append(";");
                    continue block8;
                }
                case 32: {
                    buf.append(_factNames[i]);
                    buf.append("=");
                    if (finfo.isDirectory()) {
                        buf.append(finfo.isReadOnly() ? "el" : "ceflmp");
                    } else {
                        buf.append(finfo.isReadOnly() ? "r" : "rwadf");
                    }
                    buf.append(";");
                    continue block8;
                }
            }
        }
        buf.append(" ");
        buf.append(finfo.getFileName());
    }

    private final String getLocalFTPAddressString() {
        return this.m_sock.getLocalAddress().getHostAddress().replace('.', ',');
    }

    protected final void sendFTPNotLoggedOnResponse() throws IOException {
        this.sendFTPResponse(530, "Not logged on");
    }

    @Override
    public boolean useCaseSensitiveSearch() {
        return true;
    }

    @Override
    public void run() {
        block54: {
            try {
                if (this.hasDebug(1)) {
                    this.debugPrintln("FTP session started");
                }
                this.m_in = this.m_sock.getInputStream();
                this.m_out = new OutputStreamWriter(this.m_sock.getOutputStream());
                this.m_inbuf = new byte[1024];
                this.sendFTPResponse(220, "FTP server ready");
                long startTime = 0L;
                long endTime = 0L;
                FTPRequest ftpReq = null;
                while (this.m_sock != null) {
                    long duration;
                    ftpReq = this.getNextCommand(true);
                    if (ftpReq == null) continue;
                    if (this.hasDebug(1024)) {
                        startTime = System.currentTimeMillis();
                    }
                    if (this.hasDebug(2)) {
                        this.debugPrintln("Rx cmd=" + ftpReq);
                    }
                    switch (ftpReq.isCommand()) {
                        case 0: {
                            this.procUser(ftpReq);
                            break;
                        }
                        case 1: {
                            this.procPassword(ftpReq);
                            break;
                        }
                        case 7: {
                            this.procQuit(ftpReq);
                            break;
                        }
                        case 10: {
                            this.procType(ftpReq);
                            break;
                        }
                        case 8: {
                            this.procPort(ftpReq);
                            break;
                        }
                        case 9: {
                            this.procPassive(ftpReq);
                            break;
                        }
                        case 18: {
                            this.procRestart(ftpReq);
                            break;
                        }
                        case 13: {
                            this.procReturnFile(ftpReq);
                            this.m_restartPos = 0L;
                            break;
                        }
                        case 14: {
                            this.procStoreFile(ftpReq, false);
                            break;
                        }
                        case 16: {
                            this.procStoreFile(ftpReq, true);
                            break;
                        }
                        case 25: 
                        case 37: {
                            this.procPrintWorkDir(ftpReq);
                            break;
                        }
                        case 3: 
                        case 41: {
                            this.procChangeWorkDir(ftpReq);
                            break;
                        }
                        case 4: 
                        case 40: {
                            this.procCdup(ftpReq);
                            break;
                        }
                        case 26: {
                            this.procList(ftpReq);
                            break;
                        }
                        case 27: {
                            this.procNList(ftpReq);
                            break;
                        }
                        case 22: {
                            this.procDeleteFile(ftpReq);
                            break;
                        }
                        case 19: {
                            this.procRenameFrom(ftpReq);
                            break;
                        }
                        case 20: {
                            this.procRenameTo(ftpReq);
                            break;
                        }
                        case 24: 
                        case 38: {
                            this.procCreateDirectory(ftpReq);
                            break;
                        }
                        case 23: 
                        case 39: {
                            this.procRemoveDirectory(ftpReq);
                            break;
                        }
                        case 34: {
                            this.procFileSize(ftpReq);
                            break;
                        }
                        case 33: {
                            this.procModifyDateTime(ftpReq);
                            break;
                        }
                        case 29: {
                            this.procSystemStatus(ftpReq);
                            break;
                        }
                        case 30: {
                            this.procServerStatus(ftpReq);
                            break;
                        }
                        case 31: {
                            this.procHelp(ftpReq);
                            break;
                        }
                        case 32: {
                            this.procNoop(ftpReq);
                            break;
                        }
                        case 21: {
                            this.procAbort(ftpReq);
                            break;
                        }
                        case 36: {
                            this.procFeatures(ftpReq);
                            break;
                        }
                        case 35: {
                            this.procOptions(ftpReq);
                            break;
                        }
                        case 42: {
                            this.procMachineListing(ftpReq);
                            break;
                        }
                        case 43: {
                            this.procMachineListingContents(ftpReq);
                            break;
                        }
                        case 28: {
                            this.procSite(ftpReq);
                            break;
                        }
                        case 11: {
                            this.procStructure(ftpReq);
                            break;
                        }
                        case 12: {
                            this.procMode(ftpReq);
                            break;
                        }
                        case 17: {
                            this.procAllocate(ftpReq);
                            break;
                        }
                        case 44: {
                            this.procExtendedPort(ftpReq);
                            break;
                        }
                        case 45: {
                            this.procExtendedPassive(ftpReq);
                            break;
                        }
                        case 46: {
                            this.procAuth(ftpReq);
                            break;
                        }
                        case 47: {
                            this.procProtectedBufferSize(ftpReq);
                            break;
                        }
                        case 48: {
                            this.procDataChannelProtection(ftpReq);
                            break;
                        }
                        case 49: {
                            this.procClearCommandChannel(ftpReq);
                            break;
                        }
                        default: {
                            if (ftpReq.isCommand() != -1) {
                                this.sendFTPResponse(502, "Command " + FTPCommand.getCommandName(ftpReq.isCommand()) + " not implemented");
                                break;
                            }
                            this.sendFTPResponse(502, "Command not implemented");
                        }
                    }
                    if (this.hasDebug(1024) && (duration = (endTime = System.currentTimeMillis()) - startTime) > 20L) {
                        this.debugPrintln("Processed cmd " + FTPCommand.getCommandName(ftpReq.isCommand()) + " in " + duration + "ms");
                    }
                    this.endTransaction();
                }
            }
            catch (SocketException ex) {
                if (this.hasDebug(1)) {
                    this.debugPrintln("Socket closed by remote client");
                }
            }
            catch (Exception ex) {
                if (this.isShutdown()) break block54;
                this.debugPrintln(ex);
            }
        }
        this.closeSession();
        if (this.hasDebug(1)) {
            this.debugPrintln("Server session closed");
        }
    }
}

