/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.debug;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import org.alfresco.jlan.debug.DebugInterface;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.springframework.extensions.config.ConfigElement;

public abstract class DebugInterfaceBase
implements DebugInterface {
    private static final String LineSeperator = System.getProperty("line.separator");
    private int m_logLevel = 4;

    public void close() {
    }

    public final void debugPrint(String str) {
        this.debugPrint(str, 4);
    }

    public abstract void debugPrint(String var1, int var2);

    public final void debugPrintln(String str) {
        this.debugPrintln(str, 4);
    }

    public abstract void debugPrintln(String var1, int var2);

    public void debugPrintln(Exception ex, int level) {
        StringWriter strWrt = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)strWrt, true));
        StringTokenizer strTok = new StringTokenizer(strWrt.toString(), LineSeperator);
        while (strTok.hasMoreTokens()) {
            this.debugPrintln(strTok.nextToken(), level);
        }
    }

    public final int getLogLevel() {
        return this.m_logLevel;
    }

    public final void setLogLevel(int logLevel) {
        this.m_logLevel = logLevel;
    }

    public void initialize(ConfigElement params, ServerConfiguration config) throws Exception {
        String logLevelStr;
        ConfigElement logLevelElem = params.getChild("logLevel");
        if (logLevelElem != null && (logLevelStr = logLevelElem.getValue()) != null) {
            if (logLevelStr.equalsIgnoreCase("Debug")) {
                this.m_logLevel = 4;
            } else if (logLevelStr.equalsIgnoreCase("Info")) {
                this.m_logLevel = 3;
            } else if (logLevelStr.equalsIgnoreCase("Warn")) {
                this.m_logLevel = 2;
            } else if (logLevelStr.equalsIgnoreCase("Error")) {
                this.m_logLevel = 1;
            } else if (logLevelStr.equalsIgnoreCase("Fatal")) {
                this.m_logLevel = 0;
            } else {
                throw new Exception("Invalid debug logging level, " + logLevelStr);
            }
        }
    }
}

