/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.info;

public class DeviceInfo {
    public static final int Beep = 1;
    public static final int CDROM = 2;
    public static final int CDROMFileSystem = 3;
    public static final int Controller = 4;
    public static final int Datalink = 5;
    public static final int DFS = 6;
    public static final int Disk = 7;
    public static final int DiskFileSystem = 8;
    public static final int FileSystem = 9;
    public static final int InportPort = 10;
    public static final int Keyboard = 11;
    public static final int Mailslot = 12;
    public static final int MIDIIn = 13;
    public static final int MIDIOut = 14;
    public static final int Mouse = 15;
    public static final int MultiUNCProvider = 16;
    public static final int NamedPipe = 17;
    public static final int Network = 18;
    public static final int NetworkBrowser = 19;
    public static final int NetworkFileSystem = 20;
    public static final int Null = 21;
    public static final int ParallelPort = 22;
    public static final int PhysicalNetcard = 23;
    public static final int Printer = 24;
    public static final int Scanner = 25;
    public static final int SerialMousePort = 26;
    public static final int SerialPort = 27;
    public static final int Screen = 28;
    public static final int Sound = 29;
    public static final int Streams = 30;
    public static final int Tape = 31;
    public static final int TapeFileSystem = 32;
    public static final int Transport = 33;
    public static final int Unknown = 34;
    public static final int Video = 35;
    public static final int VirtualDisk = 36;
    public static final int WaveIn = 37;
    public static final int WaveOut = 38;
    public static final int Port8042 = 39;
    public static final int NetworkRedirector = 40;
    public static final int Battery = 41;
    public static final int BusExtended = 42;
    public static final int Modem = 43;
    public static final int VDM = 44;
    public static final int RemoveableMedia = 1;
    public static final int ReadOnlyDevice = 2;
    public static final int FloppyDisk = 4;
    public static final int WriteOnceMedia = 8;
    public static final int RemoteDevice = 16;
    public static final int DeviceMounted = 32;
    public static final int VirtualVolume = 64;
    private int m_type;
    private int m_chars;

    public DeviceInfo(int typ, int chr) {
        this.m_type = typ;
        this.m_chars = chr;
    }

    public final int getType() {
        return this.m_type;
    }

    public final int getCharacteristics() {
        return this.m_chars;
    }

    public final boolean isRemoveable() {
        return this.hasFlag(1);
    }

    public final boolean isReadOnly() {
        return this.hasFlag(2);
    }

    public final boolean isFloppyDisk() {
        return this.hasFlag(4);
    }

    public final boolean isWriteOnce() {
        return this.hasFlag(8);
    }

    public final boolean isRemote() {
        return this.hasFlag(16);
    }

    public final boolean isMounted() {
        return this.hasFlag(32);
    }

    public final boolean isVirtual() {
        return this.hasFlag(64);
    }

    private final boolean hasFlag(int flg) {
        return (this.m_chars & flg) != 0;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getType());
        str.append(",0x");
        str.append(Integer.toHexString(this.getCharacteristics()));
        str.append("]");
        return str.toString();
    }
}

