/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.demo;

import java.io.IOException;
import java.io.PrintStream;
import org.alfresco.jlan.client.AsynchRequest;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.CIFSFile;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.NotifyChange;
import org.alfresco.jlan.client.SessionFactory;
import org.alfresco.jlan.client.demo.jlanApp;
import org.alfresco.jlan.client.smb.DirectoryWatcher;
import org.alfresco.jlan.smb.InvalidUNCPathException;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.util.NameValue;
import org.alfresco.jlan.util.NameValueList;

public class jlanWatch
extends jlanApp {
    public jlanWatch() {
        super("jlanWatch", "Monitor file/folder changes on a remote folder");
    }

    protected void outputCommandHelp(PrintStream out) {
        out.println("Usage: jlanWatch \\\\<host>|<ip_address>\\<share_name>[\\<path\\");
        out.println("  The UNC path to the file/folder may use forward or backslash characters.");
        out.println("  Access control may be embedded in the UNC path using:-");
        out.println("    \\\\<host>\\<share>[%username][:<password.]\\<path>\\...");
    }

    protected void doCommand(PrintStream out) throws Exception {
        PCShare share = this.getShare();
        DiskSession sess = SessionFactory.OpenDisk(share);
        this.setSession(sess);
        String path = share.getRelativePath();
        if (!sess.FileExists(path) || !sess.isDirectory(path)) {
            out.println("%% Folder does not exist - " + path);
        } else if (sess instanceof CIFSDiskSession) {
            CIFSDiskSession cifsSess = (CIFSDiskSession)sess;
            CIFSFile watchDir = cifsSess.NTCreate(path, 1, 128, 3, 1, 0L, 0);
            DirectoryWatcher watcher = new DirectoryWatcher(){

                public void directoryChanged(int typ, String fname) {
                    System.out.println("  " + NotifyChange.getActionAsString(typ) + " : " + fname);
                }
            };
            AsynchRequest dirWatch = cifsSess.NTNotifyChange(watchDir.getFileId(), 11, true, watcher, true);
            out.println("Watching directory " + path + " on \\\\" + share.getNodeName() + "\\" + share.getShareName() + ", enter 'x' to stop");
            boolean userExit = false;
            while (!userExit) {
                int ch;
                if (System.in.available() > 0 && ((ch = System.in.read()) == 120 || ch == 88)) {
                    userExit = true;
                    break;
                }
                try {
                    cifsSess.checkForAsynchReceive(-1);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    userExit = true;
                }
            }
            out.println("Watcher closed.");
            dirWatch.setAutoReset(false);
            watchDir.Close();
        } else {
            out.println("%% Server does not support notifications");
        }
        sess.CloseSession();
        this.setSession(null);
    }

    protected boolean validateCommandLine(NameValueList cmdLine, PrintStream out) {
        if (cmdLine.numberOfItems() < 1) {
            out.println("%% Wrong number of command line arguments");
            return false;
        }
        NameValue arg1 = cmdLine.findItem("Arg1");
        if (arg1 == null || arg1.getValue() == null || arg1.getValue().length() == 0) {
            out.println("%% Invalid command line argument, " + arg1 != null ? arg1.getValue() : "");
            return false;
        }
        PCShare share = null;
        try {
            share = new PCShare(arg1.getValue());
            this.setShare(share);
        }
        catch (InvalidUNCPathException ex) {
            out.println("%% Invalid UNC path, " + ex.toString());
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        jlanWatch cmd = new jlanWatch();
        cmd.runCommand(args);
    }
}

