/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.demo;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.alfresco.jlan.client.SessionFactory;
import org.alfresco.jlan.client.admin.AdminSession;
import org.alfresco.jlan.client.admin.SamrPipeFile;
import org.alfresco.jlan.client.demo.jlanApp;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.dcerpc.PolicyHandle;
import org.alfresco.jlan.smb.dcerpc.info.UserInfo;
import org.alfresco.jlan.smb.nt.RID;
import org.alfresco.jlan.smb.nt.RIDList;
import org.alfresco.jlan.util.NameValue;
import org.alfresco.jlan.util.NameValueList;
import org.alfresco.jlan.util.StringList;

public class jlanUser
extends jlanApp {
    private static String[] _accFlagStr = new String[]{"Account Disabled", "Home Directory Required", "Password Not Required", "Temporary Duplicate", "Normal Account", "MNSUser", "Domain Trust", "Workstation Trust", "Server Trust", "Password Does Not Expire", "Auto Locked"};
    private String m_domain;
    private String m_userName;
    private SimpleDateFormat m_formatter;

    public jlanUser() {
        super("jlanUser", "User account detailed information");
    }

    protected void outputCommandHelp(PrintStream out) {
        out.println("Usage: jlanUser <host>|<ip_address> <account_name> -username=<username> -password=<password>");
        out.println("  <host>|<ip_address>\tThe target server to retrieve user account information from");
        out.println("  <account_name>       Account name to return information for. May be specified as");
        out.println("                       <domain>\\<username> or");
        out.println("                       <domain>/<username>  or");
        out.println("                       <username>");
    }

    protected void doCommand(PrintStream out) throws Exception {
        AdminSession sess = SessionFactory.OpenAdminSession(this.getShare());
        this.setSession(sess.getSession());
        SamrPipeFile samr = sess.openSecurityAccountsManagerPipe();
        if (this.m_domain == null) {
            StringList domains = samr.enumerateDomains();
            if (domains != null && domains.numberOfStrings() > 0) {
                this.m_domain = domains.getStringAt(0);
            } else {
                out.println("%% Cannot find default domain");
                return;
            }
        }
        PolicyHandle userHandle = samr.openUser(this.m_domain, this.m_userName);
        UserInfo userInfo = samr.queryUserInformation(userHandle, 21);
        out.println("User : " + this.m_domain + "\\" + userInfo.getUserName());
        out.println("Full name   : " + this.formatString(userInfo.getFullName()));
        out.println("Comment     : " + this.formatString(userInfo.getComment()));
        out.println("Description : " + this.formatString(userInfo.getDescription()));
        out.println();
        out.println("Profile        : " + this.formatString(userInfo.getProfile()));
        out.println("Home drive     : " + this.formatString(userInfo.getHomeDirectoryDrive()));
        out.println("Home directory : " + this.formatString(userInfo.getHomeDirectory()));
        out.println("Script path    : " + this.formatString(userInfo.getLogonScriptPath()));
        out.println();
        out.println("Last logon   : " + this.formatDate(userInfo.getLastLogon()));
        out.println("Last logoff  : " + this.formatDate(userInfo.getLastLogoff()));
        out.println("Logon server : " + this.formatString(userInfo.getLogonServer()));
        out.println("Logon count  : " + userInfo.numberOfLogons());
        out.println("Bad passwords: " + userInfo.getBadPasswordCount());
        out.println();
        out.println("Password change         : " + this.formatDate(userInfo.getLastPasswordChange()));
        out.println("Password must change by : " + this.formatDate(userInfo.getPasswordMustChangeBy()));
        out.println("Account expires         : " + this.formatDate(userInfo.getAccountExpires()));
        out.println();
        out.println("Flags : ");
        StringList flagStrings = this.buildAccountControlStringList(userInfo.getFlags());
        if (flagStrings != null && flagStrings.numberOfStrings() > 0) {
            for (int i = 0; i < flagStrings.numberOfStrings(); ++i) {
                out.print("  ");
                out.println(flagStrings.getStringAt(i));
            }
        } else {
            out.println("  <None>");
        }
        out.println();
        RIDList groups = samr.getGroupsForUser(this.m_domain, this.m_userName);
        out.println("Groups:");
        if (groups != null && groups.numberOfRIDs() > 0) {
            for (int i = 0; i < groups.numberOfRIDs(); ++i) {
                RID group = groups.getRIDAt(i);
                out.println("  " + group.getName());
            }
            out.println();
        } else {
            out.println("  <None>");
        }
        RIDList aliases = samr.getAliasesForUser(this.m_domain, this.m_userName);
        out.println("Aliases:");
        if (aliases != null && aliases.numberOfRIDs() > 0) {
            for (int i = 0; i < aliases.numberOfRIDs(); ++i) {
                RID alias = aliases.getRIDAt(i);
                out.println("  " + alias.getName());
            }
            out.println();
        } else {
            out.println("  <None>");
        }
        samr.closeHandle(userHandle);
        sess.CloseSession();
        this.setSession(null);
    }

    protected boolean validateCommandLine(NameValueList cmdLine, PrintStream out) {
        if (cmdLine.numberOfItems() == 0) {
            out.println("%% Host name or address must be specified");
            return false;
        }
        if (cmdLine.numberOfItems() > 4) {
            out.println("%% Too many command line arguments");
            return false;
        }
        NameValue arg1 = cmdLine.findItem("Arg1");
        if (arg1 == null || arg1.getValue() == null || arg1.getValue().length() == 0) {
            out.println("%% Invalid host name specified, " + arg1 != null ? arg1.getValue() : "");
            return false;
        }
        NameValue arg2 = cmdLine.findItem("Arg2");
        if (arg2 == null || arg2.getValue() == null || arg2.getValue().length() == 0) {
            out.println("%% invalid account name specified, " + arg2 != null ? arg2.getValue() : "");
            return false;
        }
        String account = arg2.getValue();
        int pos = account.indexOf("\\");
        if (pos == -1) {
            pos = account.indexOf("/");
        }
        if (pos != -1) {
            this.m_domain = account.substring(0, pos);
            this.m_userName = account.substring(pos + 1);
        } else {
            this.m_userName = account;
        }
        PCShare share = new PCShare(arg1.getValue(), "IPC$", this.getUserName(), this.getPassword());
        this.setShare(share);
        return true;
    }

    private final String formatDate(long date) {
        if (this.m_formatter == null) {
            this.m_formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        }
        if (date == Long.MAX_VALUE) {
            return "<No Limit>";
        }
        if (date == 0L) {
            return "<Not Specified>";
        }
        return this.m_formatter.format(new Date(date));
    }

    private final String formatString(String str) {
        if (str == null) {
            return "<Not Specified>";
        }
        return str;
    }

    private final StringList buildAccountControlStringList(int flags) {
        StringList list = new StringList();
        if (flags == 0) {
            return list;
        }
        int mask = 1;
        for (int idx = 0; idx < _accFlagStr.length; ++idx) {
            if ((flags & mask) != 0) {
                list.addString(_accFlagStr[idx]);
            }
            mask <<= 1;
        }
        return list;
    }

    public static void main(String[] args) {
        jlanUser cmd = new jlanUser();
        cmd.runCommand(args);
    }
}

