/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.demo;

import java.io.PrintStream;
import org.alfresco.jlan.client.SessionFactory;
import org.alfresco.jlan.client.admin.AdminSession;
import org.alfresco.jlan.client.demo.jlanApp;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.dcerpc.info.ShareInfo;
import org.alfresco.jlan.smb.dcerpc.info.ShareInfoList;
import org.alfresco.jlan.util.NameValue;
import org.alfresco.jlan.util.NameValueList;

public class jlanShares
extends jlanApp {
    public jlanShares() {
        super("jlanShares", "Display remote server share list");
    }

    protected void outputCommandHelp(PrintStream out) {
        out.println("Usage: jlanShares <host>|<ip_address> [-username=<username>] [-password=<password>]");
        out.println("  If not specified <username> defaults to the logged in user name.");
    }

    protected void doCommand(PrintStream out) throws Exception {
        AdminSession sess = SessionFactory.OpenAdminSession(this.getShare());
        this.setSession(sess.getSession());
        ShareInfoList shareList = sess.getShareList();
        if (shareList != null && shareList.numberOfEntries() > 0) {
            this.formatOutput(System.out, "Name", 30, "Type", 8, "Comment", 40, "Users", 32778, "Hidden", -1);
            this.formatOutput(System.out, "----", 30, "----", 8, "-------", 40, "-----", 32778, "------", -1);
            for (int i = 0; i < shareList.numberOfEntries(); ++i) {
                ShareInfo shareInfo = shareList.getShare(i);
                this.formatOutput(System.out, shareInfo.getName(), 30, shareInfo.getTypeAsString(), 8, shareInfo.getComment(), 40, "" + shareInfo.getCurrentUsers() + "/" + shareInfo.getMaximumUsers(), 32778, shareInfo.isHidden() ? "  Yes" : "", -1);
            }
        } else {
            out.println("No shares to display");
        }
        sess.CloseSession();
        this.setSession(null);
    }

    protected boolean validateCommandLine(NameValueList cmdLine, PrintStream out) {
        if (cmdLine.numberOfItems() == 0) {
            out.println("%% Host name or address must be specified");
            return false;
        }
        if (cmdLine.numberOfItems() > 3) {
            out.println("%% Too many command line arguments");
            return false;
        }
        NameValue arg1 = cmdLine.findItem("Arg1");
        if (arg1 == null || arg1.getValue() == null || arg1.getValue().length() == 0) {
            out.println("%% Invalid host name specified, " + arg1 != null ? arg1.getValue() : "");
            return false;
        }
        PCShare share = new PCShare(arg1.getValue(), "IPC$", this.getUserName(), this.getPassword());
        this.setShare(share);
        return true;
    }

    public static void main(String[] args) {
        jlanShares cmd = new jlanShares();
        cmd.runCommand(args);
    }
}

