/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.demo;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.alfresco.jlan.client.SessionFactory;
import org.alfresco.jlan.client.admin.AdminSession;
import org.alfresco.jlan.client.admin.EventlogHandle;
import org.alfresco.jlan.client.admin.EventlogPipeFile;
import org.alfresco.jlan.client.demo.jlanApp;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.dcerpc.info.EventlogRecord;
import org.alfresco.jlan.smb.dcerpc.info.EventlogRecordList;
import org.alfresco.jlan.util.NameValue;
import org.alfresco.jlan.util.NameValueList;

public class jlanEventlog
extends jlanApp {
    private static final int DisplayCount = 50;
    private String m_logType = "System";

    public jlanEventlog() {
        super("jlanEventlog", "Display the latest event log entries on a remote server");
    }

    protected void outputCommandHelp(PrintStream out) {
        out.println("Usage: jlanEventlog <host>|<ip_address> [<logname>] -username=<username> -password=<password>");
        out.println("  <logname> may be one of the following :-");
        out.println("    System      For the system event log");
        out.println("    Application For the application event log");
        out.println("    Security    For the security event log");
    }

    protected void doCommand(PrintStream out) throws Exception {
        EventlogRecordList recList;
        AdminSession sess = SessionFactory.OpenAdminSession(this.getShare());
        this.setSession(sess.getSession());
        EventlogPipeFile evtPipe = sess.openEventLogPipe();
        if (evtPipe == null) {
            throw new Exception("Failed to open service control pipe, Eventlog");
        }
        EventlogHandle handle = evtPipe.openEventLog(this.getEventLogName());
        int recCnt = evtPipe.getNumberOfRecords(handle);
        int recNo = evtPipe.getOldestRecordNumber(handle) + recCnt;
        if (recCnt > 50) {
            recCnt = 50;
        }
        if ((recList = evtPipe.readEventLog(handle, 6, recNo - recCnt - 1)) != null && recList.numberOfRecords() > 0) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMMyyyy HH:mm:ss");
            this.formatOutput(out, "Time", 19, "Source", 30, "Type", 15, "Text", 50);
            this.formatOutput(out, "----", 19, "------", 30, "----", 15, "----", 50);
            for (int i = recList.numberOfRecords() - 1; i >= 0; --i) {
                EventlogRecord event = recList.getRecordAt(i);
                this.formatOutput(out, dateFormat.format(event.getTimeGenerated()), 19, event.getEventSource(), 30, event.getEventTypeAsString(), 15, event.getEventString(), 50);
            }
        } else {
            out.println("No records to display");
        }
        evtPipe.closeEventlog(handle);
        evtPipe.ClosePipe();
        sess.CloseSession();
        this.setSession(null);
    }

    protected boolean validateCommandLine(NameValueList cmdLine, PrintStream out) {
        if (cmdLine.numberOfItems() == 0) {
            out.println("%% Host name or address must be specified");
            return false;
        }
        if (cmdLine.numberOfItems() > 4) {
            out.println("%% Too many command line arguments");
            return false;
        }
        NameValue arg1 = cmdLine.findItem("Arg1");
        if (arg1 == null || arg1.getValue() == null || arg1.getValue().length() == 0) {
            out.println("%% Invalid host name specified, " + arg1 != null ? arg1.getValue() : "");
            return false;
        }
        NameValue arg2 = cmdLine.findItem("Arg2");
        if (arg2 != null) {
            String logName = null;
            if (arg2.getValue().equalsIgnoreCase("System")) {
                logName = "System";
            } else if (arg2.getValue().equalsIgnoreCase("Application")) {
                logName = "Application";
            } else if (arg2.getValue().equalsIgnoreCase("Security")) {
                logName = "Security";
            } else {
                out.println("%% Invalid event log name - " + arg2.getValue());
                return false;
            }
            this.setEventLogName(logName);
        }
        PCShare share = new PCShare(arg1.getValue(), "IPC$", this.getUserName(), this.getPassword());
        this.setShare(share);
        return true;
    }

    protected final String getEventLogName() {
        return this.m_logType;
    }

    protected final void setEventLogName(String type) {
        this.m_logType = type;
    }

    public static void main(String[] args) {
        jlanEventlog cmd = new jlanEventlog();
        cmd.runCommand(args);
    }
}

