/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.demo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.alfresco.jlan.client.Session;
import org.alfresco.jlan.client.SessionFactory;
import org.alfresco.jlan.netbios.NetBIOSSession;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.util.IPAddress;
import org.alfresco.jlan.util.NameValue;
import org.alfresco.jlan.util.NameValueList;

public abstract class jlanApp {
    public static final String CmdLineArg = "Arg";
    public static final String CmdLineArg1 = "Arg1";
    public static final String CmdLineArg2 = "Arg2";
    public static final String CmdLineArg3 = "Arg3";
    public static final String CmdLineArg4 = "Arg4";
    public static final String CmdLineArg5 = "Arg5";
    public static final String CmdLineArg6 = "Arg6";
    public static final String SwitchUserName = "username";
    public static final String SwitchPassword = "password";
    public static final String SwitchDomain = "domain";
    protected static final int RightAlign = 32768;
    protected static final String PropertiesFileName = "jlan.properties";
    protected static final String PropertyUserName = "UserName";
    protected static final String PropertyPassword = "Password";
    protected static final String PropertyDomain = "Domain";
    protected static final String PropertyWINS = "WINS";
    protected static final String PropertyBroadcast = "Broadcast";
    protected static final String PropertyDebug = "DebugEnable";
    protected static final String PropertyResolveOrder = "ResolveOrder";
    protected static final String PropertyConnectOrder = "ConnectOrder";
    protected static final String PropertyNameScope = "NameScope";
    protected static final String PropertyWildcardName = "WildcardServerName";
    protected static final String PropertyJCEProvider = "JCEProvider";
    private String m_cmdName;
    private String m_cmdDesc;
    private PCShare m_share;
    private Session m_session;
    private NameValueList m_cmdLine;
    private boolean m_cmdSwitches = true;
    private StringBuffer m_fmtBuf;
    private Properties m_properties;

    public jlanApp(String name, String desc) {
        this.m_cmdName = name;
        this.m_cmdDesc = desc;
    }

    public jlanApp(String name, String desc, boolean switches) {
        this.m_cmdName = name;
        this.m_cmdDesc = desc;
        this.m_cmdSwitches = switches;
    }

    public final String getCommandName() {
        return this.m_cmdName;
    }

    public final String getCommandDescription() {
        return this.m_cmdDesc;
    }

    protected abstract void outputCommandHelp(PrintStream var1);

    protected abstract void doCommand(PrintStream var1) throws Exception;

    protected abstract boolean validateCommandLine(NameValueList var1, PrintStream var2);

    protected final String getUserName() {
        String userName = null;
        NameValue val = this.m_cmdLine.findItem(SwitchUserName);
        if (val != null) {
            userName = val.getValue();
        } else if (this.m_properties != null) {
            userName = this.m_properties.getProperty(PropertyUserName);
        }
        return userName;
    }

    protected final String getDomain() {
        String domain = null;
        NameValue val = this.m_cmdLine.findItem(SwitchDomain);
        if (val != null) {
            domain = val.getValue();
        } else if (this.m_properties != null) {
            domain = this.m_properties.getProperty(PropertyDomain);
        }
        return domain;
    }

    protected final String getPassword() {
        String password = null;
        NameValue val = this.m_cmdLine.findItem(SwitchPassword);
        if (val != null) {
            password = val.getValue();
        } else if (this.m_properties != null) {
            password = this.m_properties.getProperty(PropertyPassword);
        }
        return password;
    }

    private final void loadProperties(PrintStream out) throws IOException {
        int pos;
        String dir = System.getProperty("user.dir");
        File propFile = new File(dir + File.separator + PropertiesFileName);
        FileInputStream propStream = null;
        if (propFile.exists()) {
            propStream = new FileInputStream(propFile);
        } else {
            String userHome = System.getProperty("user.home");
            if (userHome != null && userHome.length() > 0 && (propFile = new File(userHome + File.separator + PropertiesFileName)).exists()) {
                propStream = new FileInputStream(propFile);
            }
        }
        if (propStream == null) {
            return;
        }
        this.m_properties = new Properties();
        this.m_properties.load(propStream);
        ((InputStream)propStream).close();
        String property = this.m_properties.getProperty(PropertyDebug);
        if (property != null && (property.equals("1") || property.equalsIgnoreCase("true"))) {
            Session.setDebug(3);
        }
        if ((property = this.m_properties.getProperty(PropertyWINS)) != null && property.length() > 0) {
            NetBIOSSession.setDefaultWINSServer(InetAddress.getByName(property));
        }
        if ((property = this.m_properties.getProperty(PropertyBroadcast)) != null && IPAddress.isNumericAddress(property)) {
            NetBIOSSession.setDefaultSubnetMask(property);
        }
        if ((property = this.m_properties.getProperty(PropertyResolveOrder)) != null && property.length() > 0) {
            property = property.toUpperCase();
            pos = property.indexOf(",");
            String resolve1 = null;
            String resolve2 = null;
            if (pos != -1) {
                resolve1 = property.substring(0, pos).trim();
                resolve2 = property.substring(pos + 1).trim();
            } else {
                resolve1 = property.trim();
            }
            if (!resolve1.equals("NETBIOS") && !resolve1.equals("DNS")) {
                out.println("%% Invalid ResolveOrder - " + property + " (use NetBIOS and DNS)");
            } else if (resolve2 != null && !resolve2.equals("NETBIOS") && !resolve2.equals("DNS")) {
                out.println("%% Invalid ResolveOrder - " + property + " (use NetBIOS and DNS)");
            } else {
                int resolveType = 3;
                if (resolve1.equals("NETBIOS") && resolve2 == null) {
                    resolveType = 2;
                } else if (resolve1.equals("DNS") && resolve2 == null) {
                    resolveType = 1;
                }
                NetBIOSSession.setDefaultLookupType(resolveType);
            }
        }
        if ((property = this.m_properties.getProperty(PropertyConnectOrder)) != null && property.length() > 0) {
            property = property.toUpperCase();
            pos = property.indexOf(",");
            String conn1 = null;
            String conn2 = null;
            if (pos != -1) {
                conn1 = property.substring(0, pos).trim();
                conn2 = property.substring(pos + 1).trim();
            } else {
                conn1 = property.trim();
            }
            if (!conn1.equals("NETBIOS") && !conn1.equals("TCPIP")) {
                out.println("%% Invalid ConnectOrder - " + property + " (use NetBIOS and TCPIP)");
            } else if (conn2 != null && !conn2.equals("NETBIOS") && !conn2.equals("TCPIP")) {
                out.println("%% Invalid ConnectOrder - " + property + " (use NetBIOS and TCPIP)");
            } else {
                int c1 = conn1.equals("NETBIOS") ? 1 : 2;
                int c2 = -1;
                if (conn2 != null) {
                    int n = c2 = conn2.equals("NETBIOS") ? 1 : 2;
                }
                if (c1 == c2) {
                    c2 = -1;
                }
                SessionFactory.setProtocolOrder(c1, c2);
            }
        }
        if ((property = this.m_properties.getProperty(PropertyNameScope)) != null && property.length() > 0) {
            if (property.length() < 3 || property.indexOf(46) == -1) {
                out.println("%% Invalid NetBIOS name scope - " + property);
            } else {
                SessionFactory.setNetBIOSNameScope(property);
            }
        }
        if ((property = this.m_properties.getProperty(PropertyWildcardName)) != null && (property.equals("0") || property.equalsIgnoreCase("false"))) {
            NetBIOSSession.setDefaultWildcardFileServerName(false);
        }
        if ((property = this.m_properties.getProperty(PropertyJCEProvider)) != null && property.length() > 0) {
            Provider jceProvider = null;
            try {
                Object jceObj = Class.forName(property).newInstance();
                if (jceObj instanceof Provider) {
                    jceProvider = (Provider)jceObj;
                } else {
                    out.println("%% JCE provider not a valid provider, " + property);
                }
            }
            catch (ClassNotFoundException ex) {
                out.println("%% JCE provider class not found, " + property);
            }
            catch (InstantiationException ex) {
                out.println("%% JCE provider instantiation error, " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                out.println("%% JCE provider class error, " + ex.getMessage());
            }
            if (jceProvider != null) {
                Security.addProvider(jceProvider);
            }
        }
    }

    protected final int parseCommandLine(String[] args) {
        if (args == null) {
            return 0;
        }
        this.m_cmdLine = new NameValueList();
        int arg = 1;
        int idx = 0;
        while (idx < args.length) {
            String param;
            if ((param = args[idx++]).equalsIgnoreCase("-help") || param.equalsIgnoreCase("--help") || param.equalsIgnoreCase("-?")) {
                return 0;
            }
            if (this.hasCommandSwitches() && param.startsWith("-")) {
                String name = null;
                String value = null;
                int pos = param.indexOf("=");
                if (pos != -1) {
                    name = param.substring(1, pos);
                    value = param.substring(pos + 1);
                } else {
                    name = param.substring(1);
                    value = "";
                }
                this.m_cmdLine.addItem(new NameValue(name, value));
                continue;
            }
            this.m_cmdLine.addItem(new NameValue(CmdLineArg + arg++, param));
        }
        return this.m_cmdLine.numberOfItems();
    }

    public final void runCommand(String[] args) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        out.print(this.getCommandName());
        out.print(" - ");
        out.println(this.getCommandDescription());
        out.println("Copyright (C) 2006-2010 Alfresco Software Limited.");
        out.println();
        try {
            this.loadProperties(err);
        }
        catch (Exception ex) {
            // empty catch block
        }
        int sts = 0;
        if (this.parseCommandLine(args) == 0) {
            this.outputCommandHelp(out);
            sts = 1;
        } else if (this.validateCommandLine(this.m_cmdLine, err)) {
            try {
                this.doCommand(out);
            }
            catch (Exception ex) {
                err.println("Error: " + ex.toString());
                ex.printStackTrace(err);
                sts = 2;
            }
            if (this.hasSession()) {
                try {
                    this.getSession().CloseSession();
                    this.setSession(null);
                }
                catch (Exception ex) {
                    err.println("Failed to close network session, " + ex.toString());
                }
            }
        }
        System.exit(sts);
    }

    protected final String promptForPassword() {
        return null;
    }

    protected final PCShare getShare() {
        return this.m_share;
    }

    protected final boolean hasSession() {
        return this.m_session != null;
    }

    protected final Session getSession() {
        return this.m_session;
    }

    protected final boolean hasCommandSwitches() {
        return this.m_cmdSwitches;
    }

    protected final void setShare(PCShare shr) {
        String pass;
        this.m_share = shr;
        String user = this.getUserName();
        if (user != null && shr.getUserName().equals("GUEST")) {
            shr.setUserName(user);
        }
        if ((pass = this.getPassword()) != null && shr.getPassword() == null) {
            shr.setPassword(pass);
        }
        shr.setDomain(this.getDomain());
    }

    protected final void setSession(Session sess) {
        this.m_session = sess;
    }

    protected final void formatOutput(PrintStream out, String col1, int width1, String col2, int width2, String col3, int width3, String col4, int width4, String col5, int width5) {
        if (this.m_fmtBuf == null) {
            this.m_fmtBuf = new StringBuffer(100);
        }
        this.m_fmtBuf.setLength(0);
        this.formatColumn(this.m_fmtBuf, col1, width1);
        if (col2 != null) {
            this.formatColumn(this.m_fmtBuf, col2, width2);
        }
        if (col3 != null) {
            this.formatColumn(this.m_fmtBuf, col3, width3);
        }
        if (col4 != null) {
            this.formatColumn(this.m_fmtBuf, col4, width4);
        }
        if (col5 != null) {
            this.formatColumn(this.m_fmtBuf, col5, width5);
        }
        out.println(this.m_fmtBuf.toString());
    }

    protected final void formatOutput(PrintStream out, String col1, int width1, String col2, int width2, String col3, int width3, String col4, int width4) {
        this.formatOutput(out, col1, width1, col2, width2, col3, width3, col4, width4, null, 0);
    }

    protected final void formatOutput(PrintStream out, String col1, int width1, String col2, int width2, String col3, int width3) {
        this.formatOutput(out, col1, width1, col2, width2, col3, width3, null, 0, null, 0);
    }

    protected final void formatOutput(PrintStream out, String col1, int width1, String col2, int width2) {
        this.formatOutput(out, col1, width1, col2, width2, null, 0, null, 0, null, 0);
    }

    protected final void formatOutput(PrintStream out, String col1, int width1) {
        this.formatOutput(out, col1, width1, null, 0, null, 0, null, 0, null, 0);
    }

    private final void formatColumn(StringBuffer buf, String str, int width) {
        boolean rightAlign;
        if (width == -1) {
            buf.append(str);
            return;
        }
        int fieldLen = width & 0xFFF;
        boolean bl = rightAlign = (width & 0x8000) != 0;
        if (rightAlign) {
            --fieldLen;
        }
        String field = str;
        if (str.length() > fieldLen) {
            field = str.substring(0, fieldLen - 4) + "...";
        }
        int padding = fieldLen - field.length();
        if (rightAlign) {
            while (padding-- > 0) {
                buf.append(" ");
            }
            buf.append(field);
            buf.append(" ");
        } else {
            buf.append(field);
            while (padding-- > 0) {
                buf.append(" ");
            }
        }
    }
}

