/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.alfresco.jlan.client.SessionFactory;
import org.alfresco.jlan.client.admin.AdminSession;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.NetBIOSPacket;
import org.alfresco.jlan.netbios.NetBIOSSession;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.dcerpc.info.ServerInfo;
import org.alfresco.jlan.util.StringList;

class NetworkDiscovery
extends Thread {
    private static DatagramSocket m_dgramSock = null;
    private static String m_subnetMask = null;
    private String m_domainName;
    private String m_browseMaster;
    private Vector m_nodeList;
    private boolean m_debug;

    public NetworkDiscovery() {
        this.setDaemon(true);
        this.m_nodeList = new Vector();
    }

    String getBrowseMaster() {
        return this.m_browseMaster;
    }

    String getDomainName() {
        return this.m_domainName;
    }

    Vector getNodeList() {
        return this.m_nodeList;
    }

    String getSubnetMask() {
        return m_subnetMask;
    }

    boolean hasDebug() {
        return this.m_debug;
    }

    public static void main(String[] args) {
        System.out.println("NetworkDiscovery Test");
        SessionFactory.enableDialect(7);
        NetworkDiscovery netDiscover = new NetworkDiscovery();
        netDiscover.start();
        while (true) {
            if (netDiscover.getNodeList().size() > 0) {
                Vector nodeList = netDiscover.getNodeList();
                System.out.println("Known node list :-");
                for (int i = 0; i < nodeList.size(); ++i) {
                    System.out.println(" " + nodeList.elementAt(i));
                }
            }
            try {
                NetworkDiscovery.sleep(2000L);
                continue;
            }
            catch (InterruptedException ex) {
                System.out.println(ex.toString());
                continue;
            }
            break;
        }
    }

    public void run() {
        if (this.hasDebug()) {
            Debug.println("NetworkDiscovery: run () called");
        }
        try {
            m_dgramSock = new DatagramSocket();
            m_dgramSock.setSoTimeout(3000);
        }
        catch (SocketException ex) {
            Debug.println("NetworkDiscovery: " + ex.toString());
            return;
        }
        if (m_subnetMask == null) {
            try {
                m_subnetMask = NetBIOSSession.GenerateSubnetMask(null);
            }
            catch (UnknownHostException ex) {
                Debug.println("NetworkDiscovery: " + ex.toString());
                return;
            }
        }
        StringBuffer browseName = new StringBuffer();
        browseName.append('\u0001');
        browseName.append('\u0002');
        browseName.append("__MSBROWSE__");
        browseName.append('\u0002');
        String browseStr = browseName.toString();
        NetBIOSPacket pkt = new NetBIOSPacket();
        pkt.setOpcode(0);
        pkt.setFlags(1);
        pkt.setQuestionCount(1);
        pkt.setQuestionName(browseStr, '\u0001', 32, 1);
        InetAddress destAddr = null;
        try {
            destAddr = InetAddress.getByName(this.getSubnetMask());
        }
        catch (UnknownHostException ex) {
            Debug.println("NetworkDiscovery: " + ex.toString());
            return;
        }
        DatagramPacket dgram = new DatagramPacket(pkt.getBuffer(), pkt.getLength(), destAddr, 137);
        byte[] rxbuf = new byte[256];
        DatagramPacket rxdgram = new DatagramPacket(rxbuf, rxbuf.length);
        NetBIOSPacket rxpkt = new NetBIOSPacket(rxbuf);
        while (this.m_browseMaster == null || this.m_domainName == null) {
            block27: {
                PCShare shr;
                AdminSession admSess;
                block26: {
                    try {
                        StringList srvList;
                        if (this.hasDebug()) {
                            Debug.println("NetworkDiscovery: Send name lookup request ...");
                            pkt.DumpPacket(false);
                        }
                        m_dgramSock.send(dgram);
                        boolean rxOK = false;
                        do {
                            m_dgramSock.receive(rxdgram);
                            if (this.hasDebug()) {
                                Debug.println("NetworkDiscovery: Rx Datagram");
                                rxpkt.DumpPacket(false);
                            }
                            if (!rxpkt.isResponse() || rxpkt.getOpcode() != 16) continue;
                            rxOK = true;
                        } while (!rxOK);
                        if (rxOK) {
                            this.m_browseMaster = rxdgram.getAddress().getHostName();
                            if (this.hasDebug()) {
                                Debug.println("NetworkDiscovery: Found browse master " + this.m_browseMaster);
                            }
                        }
                        if ((srvList = (admSess = SessionFactory.OpenAdminSession(shr = new PCShare(this.m_browseMaster, "IPC$", "guest", ""))).getServerNames(65535)) != null) {
                            for (int i = 0; i < srvList.numberOfStrings(); ++i) {
                                if (this.m_nodeList.contains(srvList.getStringAt(i))) continue;
                                this.m_nodeList.addElement(srvList.getStringAt(i));
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!this.hasDebug()) break block26;
                        Debug.println("Error: " + ex.toString());
                    }
                }
                if (this.m_browseMaster == null) {
                    try {
                        ServerInfo srvInfo;
                        StringList nameList = NetBIOSSession.FindNameList("STARLASOFT", '\u0000', 2000);
                        if (nameList != null) {
                            for (int i = 0; i < nameList.numberOfStrings(); ++i) {
                                if (this.m_nodeList.contains(nameList.getStringAt(i))) continue;
                                this.m_nodeList.addElement(nameList.getStringAt(i));
                            }
                        }
                        if ((srvInfo = (admSess = SessionFactory.OpenAdminSession(shr = new PCShare(InetAddress.getLocalHost().getHostName(), "IPC$", "", ""))).getServerInfo()) != null && !this.m_nodeList.contains(srvInfo.getServerName())) {
                            this.m_nodeList.addElement(srvInfo.getServerName());
                        }
                        admSess.CloseSession();
                    }
                    catch (Exception ex) {
                        if (!this.hasDebug()) break block27;
                        Debug.println("LocalHost Error: " + ex.toString());
                    }
                }
            }
            try {
                NetworkDiscovery.sleep(5000L);
            }
            catch (InterruptedException ex) {}
        }
    }

    void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }

    void setSubnetMask(String subnet) {
        m_subnetMask = subnet;
    }
}

