/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client;

import java.io.IOException;
import org.alfresco.jlan.client.CoreFile;
import org.alfresco.jlan.client.CoreSearchContext;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.client.SMBPacket;
import org.alfresco.jlan.client.SearchContext;
import org.alfresco.jlan.client.info.DiskInfo;
import org.alfresco.jlan.client.info.FileInfo;
import org.alfresco.jlan.client.info.VolumeInfo;
import org.alfresco.jlan.server.filesys.AccessMode;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.SMBException;

public class CoreDiskSession
extends DiskSession {
    private static final int CORE_LEN_FILEOPEN = 256;

    protected CoreDiskSession(PCShare shr, int dialect) {
        super(shr, dialect);
    }

    public void CloseSession() throws IOException, SMBException {
        SMBPacket pkt = new SMBPacket();
        pkt.setCommand(113);
        pkt.setUserId(this.getUserId());
        pkt.setTreeId(this.m_treeid);
        this.m_pkt.setParameterCount(0);
        this.m_pkt.setByteCount(0);
        pkt.ExchangeSMB(this, pkt);
        this.m_treeid = -1;
        super.CloseSession();
    }

    public final void CreateDirectory(String dir) throws IOException, SMBException {
        this.m_pkt.setCommand(0);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(0);
        StringBuffer pathbuf = new StringBuffer();
        pathbuf.append('\u0004');
        if (dir.startsWith("\\")) {
            pathbuf.append(dir);
        } else {
            pathbuf.append(PCShare.makePath(this.getWorkingDirectory(), dir));
        }
        pathbuf.append('\u0000');
        this.m_pkt.setBytes(pathbuf.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt, true);
    }

    public final SMBFile CreateFile(String fname) throws IOException, SMBException {
        return this.OpenFile(fname, 1);
    }

    public final void DeleteDirectory(String dir) throws IOException, SMBException {
        this.m_pkt.setCommand(1);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(0);
        StringBuffer pathbuf = new StringBuffer();
        pathbuf.append('\u0004');
        if (dir.startsWith("\\")) {
            pathbuf.append(dir);
        } else {
            pathbuf.append(PCShare.makePath(this.getWorkingDirectory(), dir));
        }
        pathbuf.append('\u0000');
        this.m_pkt.setBytes(pathbuf.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt, true);
    }

    public final void DeleteFile(String fname, int attr) throws IOException, SMBException {
    }

    public final DiskInfo getDiskInformation() throws IOException, SMBException {
        this.m_pkt.setCommand(128);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(0);
        this.m_pkt.setByteCount(0);
        this.m_pkt.ExchangeSMB(this, this.m_pkt);
        if (this.m_pkt.isValidResponse()) {
            int totunit = this.m_pkt.getParameter(0);
            int blkperunit = this.m_pkt.getParameter(1);
            int blksize = this.m_pkt.getParameter(2);
            int freeblk = this.m_pkt.getParameter(3);
            return new DiskInfo(this.getPCShare(), totunit, blkperunit, blksize, freeblk);
        }
        return null;
    }

    public final FileInfo getFileInformation(String fname, int level) throws IOException, SMBException {
        this.m_pkt.setCommand(8);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(0);
        StringBuffer pathbuf = new StringBuffer();
        pathbuf.append('\u0004');
        if (fname.startsWith("\\")) {
            pathbuf.append(fname);
        } else {
            pathbuf.append(PCShare.makePath(this.getWorkingDirectory(), fname));
        }
        pathbuf.append('\u0000');
        this.m_pkt.setBytes(pathbuf.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt);
        if (this.m_pkt.isValidResponse()) {
            int attr = this.m_pkt.getParameter(0);
            int ftim = (this.m_pkt.getParameter(2) << 16) + this.m_pkt.getParameter(1);
            int fsiz = (this.m_pkt.getParameter(4) << 16) + this.m_pkt.getParameter(3);
            return new FileInfo(fname, fsiz, attr, ftim);
        }
        return null;
    }

    public final VolumeInfo getVolumeInformation() throws IOException, SMBException {
        return null;
    }

    public final boolean isDirectory(String dir) throws IOException, SMBException {
        SMBPacket pkt = new SMBPacket();
        pkt.setCommand(16);
        pkt.setUserId(this.getUserId());
        pkt.setTreeId(this.getTreeId());
        pkt.setParameterCount(0);
        StringBuffer pathbuf = new StringBuffer();
        pathbuf.append('\u0004');
        if (dir.startsWith("\\")) {
            pathbuf.append(dir);
        } else {
            pathbuf.append(PCShare.makePath(this.getWorkingDirectory(), dir));
        }
        if (pathbuf.charAt(pathbuf.length() - 1) != '\\') {
            pathbuf.append("\\");
        }
        pathbuf.append('\u0000');
        pkt.setBytes(pathbuf.toString().getBytes());
        pkt.ExchangeSMB(this, pkt);
        return pkt.isValidResponse();
    }

    public final SMBFile OpenFile(String fname, int flags) throws IOException, SMBException {
        if (!this.isValidFilePath(fname)) {
            throw new SMBException(6, -1073741811);
        }
        this.m_pkt.setCommand(2);
        this.m_pkt.setFlags(0);
        this.m_pkt.setParameterCount(2);
        this.m_pkt.setParameter(0, flags);
        this.m_pkt.setParameter(1, 0);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        StringBuffer pathbuf = new StringBuffer();
        pathbuf.append('\u0004');
        if (fname.startsWith("\\")) {
            pathbuf.append(fname);
        } else {
            pathbuf.append(PCShare.makePath(this.getWorkingDirectory(), fname));
        }
        pathbuf.append('\u0000');
        this.m_pkt.setBytes(pathbuf.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt);
        if (this.m_pkt.isValidResponse()) {
            int fid = this.m_pkt.getParameter(0);
            int attr = this.m_pkt.getParameter(1);
            int fsiz = (this.m_pkt.getParameter(5) << 16) + this.m_pkt.getParameter(4);
            FileInfo finfo = new FileInfo(fname, fsiz, attr);
            return new CoreFile(this, finfo, fid);
        }
        if (AccessMode.getAccessMode(flags) == 1) {
            this.m_pkt.setCommand(15);
            this.m_pkt.setFlags(0);
            this.m_pkt.setParameterCount(3);
            this.m_pkt.setParameter(0, flags);
            this.m_pkt.setParameter(1, 0);
            this.m_pkt.setParameter(2, 0);
            this.m_pkt.setUserId(this.getUserId());
            this.m_pkt.setTreeId(this.getTreeId());
            this.m_pkt.setErrorClass(0);
            this.m_pkt.setErrorCode(0);
            this.m_pkt.setBytes(pathbuf.toString().getBytes());
            this.m_pkt.ExchangeSMB(this, this.m_pkt);
            if (this.m_pkt.isValidResponse()) {
                int fid = this.m_pkt.getParameter(0);
                FileInfo finfo = new FileInfo(fname, 0L, 0);
                return new CoreFile(this, finfo, fid);
            }
        }
        return null;
    }

    public final boolean RenameFile(String curnam, String newnam, int attr) throws IOException, SMBException {
        this.m_pkt.setCommand(7);
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setParameterCount(1);
        this.m_pkt.setParameter(0, attr);
        StringBuffer pathbuf = new StringBuffer();
        if (curnam.startsWith("\\")) {
            pathbuf.append('\u0004');
            pathbuf.append(curnam);
            pathbuf.append('\u0000');
            pathbuf.append('\u0004');
            pathbuf.append(newnam);
            pathbuf.append('\u0000');
        } else {
            pathbuf.append(PCShare.makePath(this.getWorkingDirectory(), curnam));
            pathbuf.append('\u0000');
            pathbuf.append('\u0004');
            if (newnam.startsWith("\\")) {
                pathbuf.append(newnam);
            } else {
                pathbuf.append(PCShare.makePath(this.getWorkingDirectory(), newnam));
            }
            pathbuf.append('\u0000');
        }
        this.m_pkt.setBytes(pathbuf.toString().getBytes());
        this.m_pkt.ExchangeSMB(this, this.m_pkt, true);
        return this.m_pkt.isValidResponse();
    }

    public final void setFileInformation(String fname, FileInfo finfo) throws IOException, SMBException {
    }

    public final void setFileInformation(SMBFile file, FileInfo finfo) throws IOException, SMBException {
    }

    public final void setFileAttributes(String fname, int attrib) throws IOException, SMBException {
    }

    public final SearchContext StartSearch(String dir, int attr, int level) throws IOException, SMBException {
        CoreSearchContext srch = new CoreSearchContext(this);
        if (srch == null) {
            return null;
        }
        srch.StartSearch(dir, attr, level);
        return srch;
    }
}

