/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sdk.feign.config;

import java.util.Collection;
import java.util.List;
import org.alfresco.rest.sdk.feign.oauth2.OAuth2FeignRequestInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientPropertiesMapper;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;

@Configuration
@EnableConfigurationProperties(value={OAuth2ClientProperties.class})
@ConditionalOnProperty(value={"spring.security.oauth2.client.registration.alfresco-rest-api.provider"})
public class OAuth2Configuration {
    private static final String OAUTH2_CLIENT_REGISTRATION_ID = "alfresco-rest-api";
    @Value(value="${spring.security.oauth2.client.registration.alfresco-rest-api.username:#{null}}")
    private String oAuth2Username;
    @Value(value="${spring.security.oauth2.client.registration.alfresco-rest-api.password:#{null}}")
    private String oAuth2Password;

    @Bean
    @ConditionalOnMissingBean(value={ClientRegistrationRepository.class})
    public InMemoryClientRegistrationRepository clientRegistrationRepository(OAuth2ClientProperties properties) {
        List registrations = new OAuth2ClientPropertiesMapper(properties).asClientRegistrations().values().stream().toList();
        return new InMemoryClientRegistrationRepository(registrations);
    }

    @Bean
    @ConditionalOnMissingBean(value={OAuth2AuthorizedClientService.class})
    public InMemoryOAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizedClientProvider oAuth2AuthorizedClientProvider() {
        return OAuth2AuthorizedClientProviderBuilder.builder().clientCredentials().password().refreshToken().build();
    }

    @Bean
    public OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService authorizedClientService, OAuth2AuthorizedClientProvider oAuth2AuthorizedClientProvider) {
        AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientServiceOAuth2AuthorizedClientManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientService);
        authorizedClientServiceOAuth2AuthorizedClientManager.setAuthorizedClientProvider(oAuth2AuthorizedClientProvider);
        authorizedClientServiceOAuth2AuthorizedClientManager.setContextAttributesMapper(OAuth2AuthorizeRequest::getAttributes);
        return authorizedClientServiceOAuth2AuthorizedClientManager;
    }

    @Bean
    public OAuth2AuthorizeRequest oAuth2AuthorizeRequest() {
        return OAuth2AuthorizeRequest.withClientRegistrationId((String)OAUTH2_CLIENT_REGISTRATION_ID).principal((Authentication)new AnonymousAuthenticationToken("feignClient", (Object)"feignClient", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}))).attribute(OAuth2AuthorizationContext.USERNAME_ATTRIBUTE_NAME, (Object)this.oAuth2Username).attribute(OAuth2AuthorizationContext.PASSWORD_ATTRIBUTE_NAME, (Object)this.oAuth2Password).build();
    }

    @Bean
    public OAuth2FeignRequestInterceptor requestInterceptor(OAuth2AuthorizedClientManager authorizedClientManager, OAuth2AuthorizeRequest oAuth2AuthorizeRequest) {
        return new OAuth2FeignRequestInterceptor(authorizedClientManager, oAuth2AuthorizeRequest);
    }
}

