/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sdk.feign.oauth2;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.core.OAuth2AccessToken;

public class OAuth2FeignRequestInterceptor
implements RequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2FeignRequestInterceptor.class);
    private static final String AUTH_HEADER_FORMAT = "%s %s";
    private final OAuth2AuthorizedClientManager oAuth2AuthorizedClientManager;
    private final OAuth2AuthorizeRequest oAuth2AuthorizeRequest;

    public OAuth2FeignRequestInterceptor(OAuth2AuthorizedClientManager oAuth2AuthorizedClientManager, OAuth2AuthorizeRequest oAuth2AuthorizeRequest) {
        this.oAuth2AuthorizedClientManager = oAuth2AuthorizedClientManager;
        this.oAuth2AuthorizeRequest = oAuth2AuthorizeRequest;
    }

    public void apply(RequestTemplate template) {
        LOGGER.debug("Applying OAuth2 authentication to feign request template {}", (Object)template);
        template.header("Authorization", new String[]{this.getAuthorizationToken()});
    }

    private String getAuthorizationToken() {
        OAuth2AccessToken accessToken = this.oAuth2AuthorizedClientManager.authorize(this.oAuth2AuthorizeRequest).getAccessToken();
        return String.format(AUTH_HEADER_FORMAT, accessToken.getTokenType().getValue(), accessToken.getTokenValue());
    }
}

