/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sdk.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Objects;
import org.alfresco.rest.sdk.feign.DelegatedAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedAuthenticationRequestInterceptor
implements RequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationRequestInterceptor.class);
    private final DelegatedAuthenticationProvider delegatedAuthenticationProvider;

    public DelegatedAuthenticationRequestInterceptor(DelegatedAuthenticationProvider delegatedAuthenticationProvider) {
        this.delegatedAuthenticationProvider = Objects.requireNonNull(delegatedAuthenticationProvider);
    }

    public void apply(RequestTemplate requestTemplate) {
        LOGGER.debug("Delegating authentication setup to the provider {}", (Object)this.delegatedAuthenticationProvider);
        this.delegatedAuthenticationProvider.setAuthentication(requestTemplate);
    }
}

