/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEvent;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEventType;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.StoreRef;

public class RecordsManagementEventServiceImplTest
extends BaseRMTestCase
implements RecordsManagementModel {
    protected static StoreRef SPACES_STORE = new StoreRef("workspace", "SpacesStore");
    private RetryingTransactionHelper transactionHelper;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.transactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
    }

    public void testGetEventTypes() {
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List eventTypes = RecordsManagementEventServiceImplTest.this.rmEventService.getEventTypes();
                TestCase.assertNotNull((Object)eventTypes);
                for (RecordsManagementEventType eventType : eventTypes) {
                    System.out.println(eventType.getName() + " - " + eventType.getDisplayLabel());
                }
                return null;
            }
        });
    }

    public void testGetEvents() {
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List events = RecordsManagementEventServiceImplTest.this.rmEventService.getEvents();
                TestCase.assertNotNull((Object)events);
                for (RecordsManagementEvent event : events) {
                    System.out.println(event.getName());
                }
                return null;
            }
        });
    }

    public void testAddRemoveEvents() {
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List events = RecordsManagementEventServiceImplTest.this.rmEventService.getEvents();
                TestCase.assertNotNull((Object)events);
                TestCase.assertFalse((boolean)RecordsManagementEventServiceImplTest.this.containsEvent(events, "myEvent"));
                RecordsManagementEventServiceImplTest.this.rmEventService.addEvent("rmEventType.simple", "myEvent", "My Event");
                events = RecordsManagementEventServiceImplTest.this.rmEventService.getEvents();
                TestCase.assertNotNull((Object)events);
                TestCase.assertTrue((boolean)RecordsManagementEventServiceImplTest.this.containsEvent(events, "myEvent"));
                RecordsManagementEventServiceImplTest.this.rmEventService.removeEvent("myEvent");
                events = RecordsManagementEventServiceImplTest.this.rmEventService.getEvents();
                TestCase.assertNotNull((Object)events);
                TestCase.assertFalse((boolean)RecordsManagementEventServiceImplTest.this.containsEvent(events, "myEvent"));
                return null;
            }
        });
    }

    private boolean containsEvent(List<RecordsManagementEvent> events, String eventName) {
        boolean result = false;
        for (RecordsManagementEvent event : events) {
            if (!eventName.equals(event.getName())) continue;
            result = true;
            break;
        }
        return result;
    }
}

