/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.lang.invoke.CallSite;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.api.AlfrescoPublicApi;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

public class PublicAPITestUtil {
    private static final String ALFRESCO_PACKAGE = "org.alfresco";

    public static void testPublicAPIConsistency(String basePackageName, SetMultimap<Class<?>, Class<?>> knownBadReferences) {
        Reflections reflections = new Reflections(basePackageName, new Scanner[]{Scanners.TypesAnnotated});
        Set publicAPIClasses = reflections.getTypesAnnotatedWith(AlfrescoPublicApi.class, true);
        HashMultimap referencedFrom = HashMultimap.create();
        HashSet referencedClasses = new HashSet();
        for (Class publicAPIClass : publicAPIClasses) {
            Set<Class<?>> set = PublicAPITestUtil.getReferencedClassesFromClass(publicAPIClass, new HashSet());
            set.forEach(arg_0 -> PublicAPITestUtil.lambda$testPublicAPIConsistency$0((SetMultimap)referencedFrom, publicAPIClass, arg_0));
            if (knownBadReferences.containsKey((Object)publicAPIClass)) {
                for (Class clazz : knownBadReferences.get((Object)publicAPIClass)) {
                    Assert.assertTrue((String)("Supplied knownBadReferences expects " + clazz + " to be referenced by " + publicAPIClass + ", but no such error was found"), (boolean)set.remove(clazz));
                }
            }
            referencedClasses.addAll(set);
        }
        ArrayList<CallSite> errorMessages = new ArrayList<CallSite>();
        for (Class clazz : referencedClasses) {
            if (!PublicAPITestUtil.isInAlfresco(clazz) || PublicAPITestUtil.isPartOfPublicApi(clazz)) continue;
            Set referencerNames = referencedFrom.get((Object)clazz).stream().map(c -> c.getName()).collect(Collectors.toSet());
            errorMessages.add((CallSite)((Object)(clazz.getName() + " <- " + StringUtils.join(referencerNames, (String)", "))));
        }
        if (!errorMessages.isEmpty()) {
            System.out.println("Errors found:");
            System.out.println(StringUtils.join(errorMessages, (String)"\n"));
        }
        Assert.assertEquals((String)"Found references to non-public API classes from public API classes.", Collections.emptyList(), errorMessages);
    }

    private static boolean isPartOfPublicApi(Class<?> clazz) {
        if (clazz.getAnnotation(AlfrescoPublicApi.class) != null) {
            return true;
        }
        if (clazz.getEnclosingClass() != null) {
            return PublicAPITestUtil.isPartOfPublicApi(clazz.getEnclosingClass());
        }
        return false;
    }

    private static Set<Class<?>> getReferencedClassesFromClass(Class<?> initialClass, Set<Class<?>> consideredClasses) {
        HashSet referencedClasses = new HashSet();
        if (consideredClasses.add(initialClass)) {
            for (Method method : initialClass.getDeclaredMethods()) {
                if (!PublicAPITestUtil.isVisibleToExtender(method.getModifiers())) continue;
                referencedClasses.addAll(PublicAPITestUtil.getClassesFromMethod(method));
            }
            for (Executable executable : initialClass.getDeclaredConstructors()) {
                if (!PublicAPITestUtil.isVisibleToExtender(((Constructor)executable).getModifiers())) continue;
                referencedClasses.addAll(PublicAPITestUtil.getClassesFromConstructor(executable));
            }
            for (AccessibleObject accessibleObject : initialClass.getDeclaredFields()) {
                if (!PublicAPITestUtil.isVisibleToExtender(((Field)accessibleObject).getModifiers())) continue;
                referencedClasses.addAll(PublicAPITestUtil.getClassesFromField((Field)accessibleObject));
            }
            for (AnnotatedElement annotatedElement : initialClass.getDeclaredClasses()) {
                if (!PublicAPITestUtil.isVisibleToExtender(((Class)annotatedElement).getModifiers())) continue;
                referencedClasses.addAll(PublicAPITestUtil.getReferencedClassesFromClass(annotatedElement, consideredClasses));
            }
            if (initialClass.getSuperclass() != null) {
                referencedClasses.addAll(PublicAPITestUtil.getReferencedClassesFromClass(initialClass.getSuperclass(), consideredClasses));
            }
            for (AnnotatedElement annotatedElement : initialClass.getInterfaces()) {
                referencedClasses.addAll(PublicAPITestUtil.getReferencedClassesFromClass(annotatedElement, consideredClasses));
            }
        }
        return referencedClasses;
    }

    private static boolean isVisibleToExtender(int modifiers) {
        return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
    }

    private static Set<Class<?>> getClassesFromMethod(Method method) {
        Set<Type> types = PublicAPITestUtil.getTypesFromMethod(method);
        return PublicAPITestUtil.getClassesFromTypes(types);
    }

    private static Set<Class<?>> getClassesFromConstructor(Constructor<?> constructor) {
        Set<Type> types = PublicAPITestUtil.getTypesFromConstructor(constructor);
        return PublicAPITestUtil.getClassesFromTypes(types);
    }

    private static Set<Class<?>> getClassesFromField(Field field) {
        HashSet types = Sets.newHashSet((Object[])new Type[]{field.getGenericType()});
        return PublicAPITestUtil.getClassesFromTypes(types);
    }

    private static Set<Type> getTypesFromMethod(Method method) {
        HashSet<Type> methodTypes = new HashSet<Type>();
        methodTypes.addAll(Sets.newHashSet((Object[])method.getGenericParameterTypes()));
        methodTypes.add(method.getGenericReturnType());
        methodTypes.addAll(Sets.newHashSet((Object[])method.getGenericExceptionTypes()));
        return methodTypes;
    }

    private static Set<Type> getTypesFromConstructor(Constructor<?> constructor) {
        HashSet<Type> methodTypes = new HashSet<Type>();
        methodTypes.addAll(Sets.newHashSet((Object[])constructor.getGenericParameterTypes()));
        methodTypes.addAll(Sets.newHashSet((Object[])constructor.getGenericExceptionTypes()));
        return methodTypes;
    }

    private static Set<Class<?>> getClassesFromTypes(Set<Type> methodTypes) {
        HashSet methodClasses = new HashSet();
        for (Type type : methodTypes) {
            methodClasses.addAll(PublicAPITestUtil.getClassesFromType(type, new HashSet<Type>()));
        }
        return methodClasses;
    }

    private static Set<Class<?>> getClassesFromType(Type type, Set<Type> processedTypes) {
        HashSet returnClasses = new HashSet();
        if (processedTypes.add(type)) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                returnClasses.add((Class)parameterizedType.getRawType());
                for (Type t : parameterizedType.getActualTypeArguments()) {
                    returnClasses.addAll(PublicAPITestUtil.getClassesFromType(t, processedTypes));
                }
            } else if (type instanceof Class) {
                Class clazz = (Class)type;
                if (clazz.isArray()) {
                    returnClasses.add(clazz.getComponentType());
                }
                returnClasses.add(clazz);
            } else if (!(type instanceof WildcardType)) {
                if (type instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)type;
                    for (Type bound : typeVariable.getBounds()) {
                        returnClasses.addAll(PublicAPITestUtil.getClassesFromType(bound, processedTypes));
                    }
                } else if (type instanceof GenericArrayType) {
                    GenericArrayType genericArrayType = (GenericArrayType)type;
                    returnClasses.addAll(PublicAPITestUtil.getClassesFromType(genericArrayType.getGenericComponentType(), processedTypes));
                } else {
                    throw new IllegalStateException("This test was not written to work with type " + type);
                }
            }
        }
        return returnClasses;
    }

    private static boolean isInAlfresco(Class<?> type) {
        if (type.getPackage() == null) {
            return false;
        }
        return type.getPackage().getName().startsWith(ALFRESCO_PACKAGE);
    }

    private static /* synthetic */ void lambda$testPublicAPIConsistency$0(SetMultimap referencedFrom, Class publicAPIClass, Class clazz) {
        referencedFrom.put((Object)clazz, (Object)publicAPIClass);
    }
}

