/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.webscript;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipType;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMWebScriptTestCase;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class RmRestApiTest
extends BaseRMWebScriptTestCase
implements RecordsManagementModel {
    protected static final String GET_NODE_AUDITLOG_URL_FORMAT = "/api/node/{0}/rmauditlog";
    protected static final String GET_TRANSFER_URL_FORMAT = "/api/node/{0}/transfers/{1}";
    protected static final String TRANSFER_REPORT_URL_FORMAT = "/api/node/{0}/transfers/{1}/report";
    protected static final String REF_INSTANCES_URL_FORMAT = "/api/node/{0}/customreferences";
    protected static final String RMA_AUDITLOG_URL = "/api/rma/admin/rmauditlog";
    protected static final String RMA_AUDITLOG_STATUS_URL = "/api/rma/admin/rmauditlog/status";
    protected static final String GET_LIST_URL = "/api/rma/admin/listofvalues";
    protected static final String RMA_ACTIONS_URL = "/api/rma/actions/ExecutionQueue";
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String RMA_CUSTOM_PROPS_DEFINITIONS_URL = "/api/rma/admin/custompropertydefinitions";
    protected static final String RMA_CUSTOM_REFS_DEFINITIONS_URL = "/api/rma/admin/customreferencedefinitions";
    private static final String BI_DI = "BiDi";
    private static final String CHILD_SRC = "childSrc";
    private static final String CHILD_TGT = "childTgt";

    public void testPostActionToNonExistentNode() throws Exception {
        NodeRef nonExistentNode = new NodeRef("workspace://SpacesStore/09ca1e02-1c87-4a53-97e7-xxxxxxxxxxxx");
        JSONObject jsonPostData = new JSONObject();
        jsonPostData.put("nodeRef", (Object)nonExistentNode.toString());
        jsonPostData.put("name", (Object)"reviewed");
        String jsonPostString = jsonPostData.toString();
        int expectedStatus = 404;
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(RMA_ACTIONS_URL, jsonPostString, APPLICATION_JSON), 404);
    }

    public void testPostReviewedAction() throws IOException, JSONException {
        NodeRef testRecord = this.utils.createRecord(this.recordFolder, "test.txt");
        Serializable pristineReviewAsOf = this.nodeService.getProperty(testRecord, PROP_REVIEW_AS_OF);
        String jsonString = new JSONStringer().object().key("name").value((Object)"reviewed").key("nodeRef").value((Object)testRecord.toString()).key("params").object().key("param1").value((Object)"one").key("param2").value((Object)"two").endObject().endObject().toString();
        int expectedStatus = 200;
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(RMA_ACTIONS_URL, jsonString, APPLICATION_JSON), 200);
        String rspContent = rsp.getContentAsString();
        RmRestApiTest.assertTrue((boolean)rspContent.contains("Successfully queued action [reviewed]"));
        Serializable newReviewAsOfDate = this.nodeService.getProperty(testRecord, PROP_REVIEW_AS_OF);
        RmRestApiTest.assertFalse((String)("The reviewAsOf property should have changed. Was " + pristineReviewAsOf), (boolean)pristineReviewAsOf.equals(newReviewAsOfDate));
    }

    public void testPostMultiReviewedAction() throws IOException, JSONException {
        NodeRef testRecord = this.utils.createRecord(this.recordFolder, "test1.txt");
        NodeRef testRecord2 = this.utils.createRecord(this.recordFolder, "test2.txt");
        NodeRef testRecord3 = this.utils.createRecord(this.recordFolder, "test3.txt");
        Serializable pristineReviewAsOf = this.nodeService.getProperty(testRecord, PROP_REVIEW_AS_OF);
        Serializable pristineReviewAsOf2 = this.nodeService.getProperty(testRecord2, PROP_REVIEW_AS_OF);
        Serializable pristineReviewAsOf3 = this.nodeService.getProperty(testRecord3, PROP_REVIEW_AS_OF);
        String jsonString = new JSONStringer().object().key("name").value((Object)"reviewed").key("nodeRefs").array().value((Object)testRecord.toString()).value((Object)testRecord2.toString()).value((Object)testRecord3.toString()).endArray().key("params").object().key("param1").value((Object)"one").key("param2").value((Object)"two").endObject().endObject().toString();
        int expectedStatus = 200;
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(RMA_ACTIONS_URL, jsonString, APPLICATION_JSON), 200);
        String rspContent = rsp.getContentAsString();
        RmRestApiTest.assertTrue((boolean)rspContent.contains("Successfully queued action [reviewed]"));
        Serializable newReviewAsOfDate = this.nodeService.getProperty(testRecord, PROP_REVIEW_AS_OF);
        RmRestApiTest.assertFalse((String)("The reviewAsOf property should have changed. Was " + pristineReviewAsOf), (boolean)pristineReviewAsOf.equals(newReviewAsOfDate));
        Serializable newReviewAsOfDate2 = this.nodeService.getProperty(testRecord2, PROP_REVIEW_AS_OF);
        RmRestApiTest.assertFalse((String)("The reviewAsOf property should have changed. Was " + pristineReviewAsOf2), (boolean)pristineReviewAsOf2.equals(newReviewAsOfDate2));
        Serializable newReviewAsOfDate3 = this.nodeService.getProperty(testRecord3, PROP_REVIEW_AS_OF);
        RmRestApiTest.assertFalse((String)("The reviewAsOf property should have changed. Was " + pristineReviewAsOf3), (boolean)pristineReviewAsOf3.equals(newReviewAsOfDate3));
    }

    public void testActionParams() throws Exception {
        String jsonString = new JSONStringer().object().key("name").value((Object)"testActionParams").key("nodeRef").array().value((Object)"nothing://nothing/nothing").endArray().key("params").object().key("paramDate").object().key("iso8601").value((Object)ISO8601DateFormat.format((Date)new Date())).endObject().endObject().endObject().toString();
        int expectedStatus = 200;
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(RMA_ACTIONS_URL, jsonString, APPLICATION_JSON), 200);
    }

    public void testPostCustomReferenceDefinitions() throws IOException, JSONException {
        this.postCustomReferenceDefinitions();
    }

    private String[] postCustomReferenceDefinitions() throws JSONException, IOException, UnsupportedEncodingException {
        String generatedBidiRefId;
        String generatedChildRefId;
        String[] result = new String[2];
        String jsonString = new JSONStringer().object().key("referenceType").value((Object)RelationshipType.PARENTCHILD).key("source").value((Object)CHILD_SRC).key("target").value((Object)CHILD_TGT).endObject().toString();
        int expectedStatus = 200;
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(RMA_CUSTOM_REFS_DEFINITIONS_URL, jsonString, APPLICATION_JSON), 200);
        String rspContent = rsp.getContentAsString();
        RmRestApiTest.assertTrue((boolean)rspContent.contains("success"));
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rspContent));
        result[0] = generatedChildRefId = jsonRsp.getJSONObject("data").getString("refId");
        jsonString = new JSONStringer().object().key("referenceType").value((Object)RelationshipType.BIDIRECTIONAL).key("label").value((Object)BI_DI).endObject().toString();
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(RMA_CUSTOM_REFS_DEFINITIONS_URL, jsonString, APPLICATION_JSON), 200);
        rspContent = rsp.getContentAsString();
        RmRestApiTest.assertTrue((boolean)rspContent.contains("success"));
        jsonRsp = new JSONObject(new JSONTokener(rspContent));
        result[1] = generatedBidiRefId = jsonRsp.getJSONObject("data").getString("refId");
        AspectDefinition customAssocsAspect = this.dictionaryService.getAspect(ASPECT_CUSTOM_ASSOCIATIONS);
        RmRestApiTest.assertNotNull((String)"Missing customAssocs aspect", (Object)customAssocsAspect);
        QName newRefQname = this.adminService.getQNameForClientId(generatedChildRefId);
        Map associations = customAssocsAspect.getAssociations();
        RmRestApiTest.assertTrue((String)"Custom child assoc not returned by dataDictionary.", (boolean)associations.containsKey(newRefQname));
        newRefQname = this.adminService.getQNameForClientId(generatedBidiRefId);
        RmRestApiTest.assertTrue((String)"Custom std assoc not returned by dataDictionary.", (boolean)customAssocsAspect.getAssociations().containsKey(newRefQname));
        return result;
    }

    public void testPutCustomPropertyDefinition() throws Exception {
        String propertyLabel = "Original label \u00e5\u00e7\u00ee\u00e9\u00f8\u00fc";
        String propId = this.postCustomPropertyDefinition("Original label \u00e5\u00e7\u00ee\u00e9\u00f8\u00fc", null);
        String updatedLabel = "Updated label \u03c0\u00f8^\u00a8\u00a5\u2020\u00ae";
        String jsonString = new JSONStringer().object().key("label").value((Object)"Updated label \u03c0\u00f8^\u00a8\u00a5\u2020\u00ae").endObject().toString();
        String propDefnUrl = "/api/rma/admin/custompropertydefinitions/" + propId;
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(propDefnUrl, jsonString, APPLICATION_JSON), 200);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(propDefnUrl), 200);
        String rspContent = rsp.getContentAsString();
        String updatedConstraint = "rmc:tlList";
        jsonString = new JSONStringer().object().key("constraintRef").value((Object)"rmc:tlList").endObject().toString();
        propDefnUrl = "/api/rma/admin/custompropertydefinitions/" + propId;
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(propDefnUrl, jsonString, APPLICATION_JSON), 200);
        rspContent = rsp.getContentAsString();
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rspContent));
        String urlOfNewPropDef = jsonRsp.getString("url");
        RmRestApiTest.assertNotNull((String)"urlOfNewPropDef was null.", (Object)urlOfNewPropDef);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(propDefnUrl), 200);
        rspContent = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(rspContent));
        JSONObject dataObject = jsonRsp.getJSONObject("data");
        RmRestApiTest.assertNotNull((String)"JSON data object was null", (Object)dataObject);
        JSONObject customPropsObject = dataObject.getJSONObject("customProperties");
        RmRestApiTest.assertNotNull((String)"JSON customProperties object was null", (Object)customPropsObject);
        RmRestApiTest.assertEquals((String)"Wrong customProperties length.", (int)1, (int)customPropsObject.length());
        Object keyToSoleProp = customPropsObject.keys().next();
        JSONObject newPropObject = customPropsObject.getJSONObject((String)keyToSoleProp);
        RmRestApiTest.assertEquals((String)"Wrong property label.", (String)"Updated label \u03c0\u00f8^\u00a8\u00a5\u2020\u00ae", (String)newPropObject.getString("label"));
        JSONArray constraintRefsArray = newPropObject.getJSONArray("constraintRefs");
        RmRestApiTest.assertEquals((String)"ConstraintRefsArray wrong length.", (int)1, (int)constraintRefsArray.length());
        String retrievedUpdatedTitle = constraintRefsArray.getJSONObject(0).getString("name");
        RmRestApiTest.assertEquals((String)"Constraints had wrong name.", (String)"rmc:tlList", (String)retrievedUpdatedTitle);
        jsonString = new JSONStringer().object().key("constraintRef").value(null).endObject().toString();
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(propDefnUrl, jsonString, APPLICATION_JSON), 200);
        rspContent = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(rspContent));
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(propDefnUrl), 200);
        rspContent = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(rspContent));
        dataObject = jsonRsp.getJSONObject("data");
        RmRestApiTest.assertNotNull((String)"JSON data object was null", (Object)dataObject);
        customPropsObject = dataObject.getJSONObject("customProperties");
        RmRestApiTest.assertNotNull((String)"JSON customProperties object was null", (Object)customPropsObject);
        RmRestApiTest.assertEquals((String)"Wrong customProperties length.", (int)1, (int)customPropsObject.length());
        keyToSoleProp = customPropsObject.keys().next();
        newPropObject = customPropsObject.getJSONObject((String)keyToSoleProp);
        RmRestApiTest.assertEquals((String)"Wrong property label.", (String)"Updated label \u03c0\u00f8^\u00a8\u00a5\u2020\u00ae", (String)newPropObject.getString("label"));
        constraintRefsArray = newPropObject.getJSONArray("constraintRefs");
        RmRestApiTest.assertEquals((String)"ConstraintRefsArray wrong length.", (int)0, (int)constraintRefsArray.length());
        String readdedConstraint = "rmc:tlList";
        jsonString = new JSONStringer().object().key("constraintRef").value((Object)"rmc:tlList").endObject().toString();
        propDefnUrl = "/api/rma/admin/custompropertydefinitions/" + propId;
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(propDefnUrl, jsonString, APPLICATION_JSON), 200);
        rspContent = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(rspContent));
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(propDefnUrl), 200);
        rspContent = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(rspContent));
        dataObject = jsonRsp.getJSONObject("data");
        RmRestApiTest.assertNotNull((String)"JSON data object was null", (Object)dataObject);
        customPropsObject = dataObject.getJSONObject("customProperties");
        RmRestApiTest.assertNotNull((String)"JSON customProperties object was null", (Object)customPropsObject);
        RmRestApiTest.assertEquals((String)"Wrong customProperties length.", (int)1, (int)customPropsObject.length());
        keyToSoleProp = customPropsObject.keys().next();
        newPropObject = customPropsObject.getJSONObject((String)keyToSoleProp);
        RmRestApiTest.assertEquals((String)"Wrong property label.", (String)"Updated label \u03c0\u00f8^\u00a8\u00a5\u2020\u00ae", (String)newPropObject.getString("label"));
        constraintRefsArray = newPropObject.getJSONArray("constraintRefs");
        RmRestApiTest.assertEquals((String)"ConstraintRefsArray wrong length.", (int)1, (int)constraintRefsArray.length());
        String readdedUpdatedTitle = constraintRefsArray.getJSONObject(0).getString("name");
        RmRestApiTest.assertEquals((String)"Constraints had wrong name.", (String)"rmc:tlList", (String)readdedUpdatedTitle);
    }

    public void testGetCustomReferences() throws IOException, JSONException {
        this.postCustomReferenceDefinitions();
        int expectedStatus = 200;
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(RMA_CUSTOM_REFS_DEFINITIONS_URL), 200);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        JSONObject dataObj = (JSONObject)jsonRsp.get("data");
        RmRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        JSONArray customRefsObj = (JSONArray)dataObj.get("customReferences");
        RmRestApiTest.assertNotNull((String)"JSON 'customReferences' object was null", (Object)customRefsObj);
        RmRestApiTest.assertTrue((String)("There should be at least two custom references. Found " + customRefsObj), (customRefsObj.length() >= 2 ? 1 : 0) != 0);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/rma/admin/customreferencedefinitions/" + CUSTOM_REF_VERSIONS.getLocalName()), 200);
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        dataObj = (JSONObject)jsonRsp.get("data");
        RmRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        customRefsObj = (JSONArray)dataObj.get("customReferences");
        RmRestApiTest.assertNotNull((String)"JSON 'customProperties' object was null", (Object)customRefsObj);
        RmRestApiTest.assertTrue((String)("There should be exactly 1 custom references. Found " + customRefsObj.length()), (customRefsObj.length() == 1 ? 1 : 0) != 0);
    }

    public void testGetDodCustomTypes() throws IOException, JSONException {
        int expectedStatus = 200;
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/rma/admin/dodcustomtypes"), 200);
        String rspContent = rsp.getContentAsString();
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rspContent));
        JSONObject dataObj = (JSONObject)jsonRsp.get("data");
        RmRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        JSONArray customTypesObj = (JSONArray)dataObj.get("dodCustomTypes");
        RmRestApiTest.assertNotNull((String)"JSON 'dodCustomTypes' object was null", (Object)customTypesObj);
        RmRestApiTest.assertEquals((String)"Wrong DOD custom types count.", (int)4, (int)customTypesObj.length());
    }

    public void testGetPostAndRemoveCustomReferenceInstances() throws Exception {
        NodeRef testRecord1 = this.utils.createRecord(this.recordFolder, "testRecord1" + System.currentTimeMillis(), "The from rec\u00f8rd");
        NodeRef testRecord2 = this.utils.createRecord(this.recordFolder, "testRecord2" + System.currentTimeMillis(), "The to r\u00e9cord");
        String node1Url = testRecord1.toString().replace("://", "/");
        String refInstancesRecord1Url = MessageFormat.format(REF_INSTANCES_URL_FORMAT, node1Url);
        String[] generatedRefIds = this.postCustomReferenceDefinitions();
        String jsonString = new JSONStringer().object().key("toNode").value((Object)testRecord2.toString()).key("refId").value((Object)generatedRefIds[1]).endObject().toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(refInstancesRecord1Url, jsonString, APPLICATION_JSON), 200);
        jsonString = new JSONStringer().object().key("toNode").value((Object)testRecord2.toString()).key("refId").value((Object)generatedRefIds[0]).endObject().toString();
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(refInstancesRecord1Url, jsonString, APPLICATION_JSON), 200);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(refInstancesRecord1Url), 200);
        String contentAsString = rsp.getContentAsString();
        JSONObject jsonRsp = new JSONObject(new JSONTokener(contentAsString));
        JSONObject dataObj = (JSONObject)jsonRsp.get("data");
        RmRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        JSONArray customRefsFromArray = (JSONArray)dataObj.get("customReferencesFrom");
        RmRestApiTest.assertNotNull((String)"JSON 'customReferencesFrom' object was null", (Object)customRefsFromArray);
        int customRefsCount = customRefsFromArray.length();
        RmRestApiTest.assertTrue((String)("There should be at least one custom reference. Found " + customRefsFromArray), (customRefsCount > 0 ? 1 : 0) != 0);
        JSONArray customRefsToArray = (JSONArray)dataObj.get("customReferencesTo");
        RmRestApiTest.assertNotNull((String)"JSON 'customReferencesTo' object was null", (Object)customRefsToArray);
        RmRestApiTest.assertEquals((String)"customReferencesTo wrong length.", (int)0, (int)customRefsToArray.length());
        String node2Url = testRecord2.toString().replace("://", "/");
        String refInstancesRecord2Url = MessageFormat.format(REF_INSTANCES_URL_FORMAT, node2Url);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(refInstancesRecord2Url), 200);
        contentAsString = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(contentAsString));
        dataObj = (JSONObject)jsonRsp.get("data");
        RmRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        customRefsToArray = (JSONArray)dataObj.get("customReferencesTo");
        RmRestApiTest.assertNotNull((String)"JSON 'customReferencesTo' object was null", (Object)customRefsToArray);
        customRefsCount = customRefsToArray.length();
        RmRestApiTest.assertTrue((String)("There should be at least one custom reference. Found " + customRefsToArray), (customRefsCount > 0 ? 1 : 0) != 0);
        customRefsFromArray = (JSONArray)dataObj.get("customReferencesFrom");
        RmRestApiTest.assertNotNull((String)"JSON 'customReferencesFrom' object was null", (Object)customRefsFromArray);
        RmRestApiTest.assertEquals((String)"customReferencesFrom wrong length.", (int)0, (int)customRefsFromArray.length());
        String protocol = testRecord2.getStoreRef().getProtocol();
        String identifier = testRecord2.getStoreRef().getIdentifier();
        String recId = testRecord2.getId();
        String queryFormat = "?st={0}&si={1}&id={2}";
        String urlQueryString = MessageFormat.format("?st={0}&si={1}&id={2}", protocol, identifier, recId);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(refInstancesRecord1Url + "/" + generatedRefIds[1] + urlQueryString), 200);
        RmRestApiTest.assertTrue((boolean)rsp.getContentAsString().contains("success"));
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(refInstancesRecord1Url + "/" + generatedRefIds[0] + urlQueryString), 200);
        RmRestApiTest.assertTrue((boolean)rsp.getContentAsString().contains("success"));
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(refInstancesRecord1Url), 200);
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        dataObj = (JSONObject)jsonRsp.get("data");
        RmRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        customRefsFromArray = (JSONArray)dataObj.get("customReferencesFrom");
        RmRestApiTest.assertNotNull((String)"JSON 'customReferences' object was null", (Object)customRefsFromArray);
        RmRestApiTest.assertTrue((String)"customRefsArray was unexpectedly not empty.", (customRefsFromArray.length() == 0 ? 1 : 0) != 0);
    }

    public void testMob1630ShouldNotBeAbleToCreateTwoSupersedesReferencesOnOneRecordPair() throws Exception {
        NodeRef testRecord1 = this.utils.createRecord(this.recordFolder, "testRecord1" + System.currentTimeMillis(), "The from rec\u00f8rd");
        NodeRef testRecord2 = this.utils.createRecord(this.recordFolder, "testRecord2" + System.currentTimeMillis(), "The to r\u00e9cord");
        String node1Url = testRecord1.toString().replace("://", "/");
        String node2Url = testRecord2.toString().replace("://", "/");
        String refInstancesRecord1Url = MessageFormat.format(REF_INSTANCES_URL_FORMAT, node1Url);
        String refInstancesRecord2Url = MessageFormat.format(REF_INSTANCES_URL_FORMAT, node2Url);
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(refInstancesRecord1Url), 200);
        String rspContent = rsp.getContentAsString();
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rspContent));
        JSONObject dataObj = jsonRsp.getJSONObject("data");
        JSONArray refsFrom = dataObj.getJSONArray("customReferencesFrom");
        JSONArray refsTo = dataObj.getJSONArray("customReferencesTo");
        RmRestApiTest.assertEquals((String)"Incorrect from-refs count.", (int)0, (int)refsFrom.length());
        RmRestApiTest.assertEquals((String)"Incorrect to-refs count.", (int)0, (int)refsTo.length());
        String supersedesRefLocalName = CUSTOM_REF_SUPERSEDES.getLocalName();
        String jsonString = new JSONStringer().object().key("toNode").value((Object)testRecord2.toString()).key("refId").value((Object)supersedesRefLocalName).endObject().toString();
        TestWebScriptServer.Response rsp2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(refInstancesRecord1Url, jsonString, APPLICATION_JSON), 200);
        rsp2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(refInstancesRecord1Url, jsonString, APPLICATION_JSON), 500);
        rsp2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(refInstancesRecord1Url), 200);
        String rspContent2 = rsp2.getContentAsString();
        JSONObject jsonRsp2 = new JSONObject(new JSONTokener(rspContent2));
        JSONObject dataObj2 = jsonRsp2.getJSONObject("data");
        JSONArray refsFrom2 = dataObj2.getJSONArray("customReferencesFrom");
        JSONArray refsTo2 = dataObj2.getJSONArray("customReferencesTo");
        RmRestApiTest.assertEquals((String)"Incorrect from-refs count.", (int)1, (int)refsFrom2.length());
        RmRestApiTest.assertEquals((String)"Incorrect to-refs count.", (int)0, (int)refsTo2.length());
        rsp2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(refInstancesRecord2Url), 200);
        rspContent2 = rsp2.getContentAsString();
        jsonRsp2 = new JSONObject(new JSONTokener(rspContent2));
        dataObj2 = jsonRsp2.getJSONObject("data");
        refsFrom2 = dataObj2.getJSONArray("customReferencesFrom");
        refsTo2 = dataObj2.getJSONArray("customReferencesTo");
        RmRestApiTest.assertEquals((String)"Incorrect from-refs count.", (int)0, (int)refsFrom2.length());
        RmRestApiTest.assertEquals((String)"Incorrect to-refs count.", (int)1, (int)refsTo2.length());
        String protocol = testRecord2.getStoreRef().getProtocol();
        String identifier = testRecord2.getStoreRef().getIdentifier();
        String recId = testRecord2.getId();
        String queryFormat = "?st={0}&si={1}&id={2}";
        String urlQueryString = MessageFormat.format("?st={0}&si={1}&id={2}", protocol, identifier, recId);
        rsp2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(refInstancesRecord1Url + "/" + supersedesRefLocalName + urlQueryString), 200);
        RmRestApiTest.assertTrue((boolean)rsp2.getContentAsString().contains("success"));
        rsp2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(refInstancesRecord1Url), 200);
        String rspContent3 = rsp2.getContentAsString();
        JSONObject jsonRsp3 = new JSONObject(new JSONTokener(rspContent3));
        JSONObject dataObj3 = jsonRsp3.getJSONObject("data");
        JSONArray refsFrom3 = dataObj3.getJSONArray("customReferencesFrom");
        JSONArray refsTo3 = dataObj3.getJSONArray("customReferencesTo");
        RmRestApiTest.assertEquals((String)"Incorrect from-refs count.", (int)0, (int)refsFrom3.length());
        RmRestApiTest.assertEquals((String)"Incorrect to-refs count.", (int)0, (int)refsTo3.length());
        rsp2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(refInstancesRecord2Url), 200);
        rspContent3 = rsp2.getContentAsString();
        jsonRsp3 = new JSONObject(new JSONTokener(rspContent3));
        dataObj3 = jsonRsp3.getJSONObject("data");
        refsFrom3 = dataObj3.getJSONArray("customReferencesFrom");
        refsTo3 = dataObj3.getJSONArray("customReferencesTo");
        RmRestApiTest.assertEquals((String)"Incorrect from-refs count.", (int)0, (int)refsFrom3.length());
        RmRestApiTest.assertEquals((String)"Incorrect to-refs count.", (int)0, (int)refsTo3.length());
    }

    public void testPostCustomPropertyDefinition() throws Exception {
        long currentTimeMillis = System.currentTimeMillis();
        this.postCustomPropertyDefinition("customProperty" + currentTimeMillis, null);
        this.postCustomPropertyDefinition("customProperty" + currentTimeMillis, "prop" + currentTimeMillis);
    }

    private String postCustomPropertyDefinition(String propertyLabel, String propId) throws JSONException, IOException, UnsupportedEncodingException {
        String jsonString = propId == null ? new JSONStringer().object().key("label").value((Object)propertyLabel).key("description").value((Object)"Dynamically defined test property").key("mandatory").value(false).key("dataType").value((Object)"d:text").key("element").value((Object)"record").key("constraintRef").value((Object)"rmc:smList").endObject().toString() : new JSONStringer().object().key("label").value((Object)propertyLabel).key("description").value((Object)"Dynamically defined test property").key("mandatory").value(false).key("dataType").value((Object)"d:text").key("element").value((Object)"record").key("constraintRef").value((Object)"rmc:smList").key("propId").value((Object)propId).endObject().toString();
        int expectedStatus = 200;
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/rma/admin/custompropertydefinitions?element=record", jsonString, APPLICATION_JSON), 200);
        String rspContent = rsp.getContentAsString();
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rspContent));
        String urlOfNewPropDef = jsonRsp.getString("url");
        String newPropId = jsonRsp.getString("propId");
        RmRestApiTest.assertNotNull((String)"urlOfNewPropDef was null.", (Object)urlOfNewPropDef);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(urlOfNewPropDef), 200);
        rspContent = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(rspContent));
        JSONObject dataObject = jsonRsp.getJSONObject("data");
        RmRestApiTest.assertNotNull((String)"JSON data object was null", (Object)dataObject);
        JSONObject customPropsObject = dataObject.getJSONObject("customProperties");
        RmRestApiTest.assertNotNull((String)"JSON customProperties object was null", (Object)customPropsObject);
        RmRestApiTest.assertEquals((String)"Wrong customProperties length.", (int)1, (int)customPropsObject.length());
        Object keyToSoleProp = customPropsObject.keys().next();
        JSONObject newPropObject = customPropsObject.getJSONObject((String)keyToSoleProp);
        RmRestApiTest.assertEquals((String)"Wrong property label.", (String)propertyLabel, (String)newPropObject.getString("label"));
        return newPropId;
    }

    public void testPutCustomReferenceDefinition() throws Exception {
        String[] generatedRefIds = this.postCustomReferenceDefinitions();
        String pcRefId = generatedRefIds[0];
        String bidiRefId = generatedRefIds[1];
        String refDefnUrl = "/api/rma/admin/customreferencedefinitions/" + bidiRefId;
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(refDefnUrl), 200);
        String rspContent = rsp.getContentAsString();
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rspContent));
        refDefnUrl = "/api/rma/admin/customreferencedefinitions/" + pcRefId;
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(refDefnUrl), 200);
        rspContent = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(rspContent));
        String updatedBiDiLabel = "Updated label \u00fc\u00f8\u00e9\u00ee\u00e7\u00e5";
        String jsonString = new JSONStringer().object().key("label").value((Object)"Updated label \u00fc\u00f8\u00e9\u00ee\u00e7\u00e5").endObject().toString();
        refDefnUrl = "/api/rma/admin/customreferencedefinitions/" + bidiRefId;
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(refDefnUrl, jsonString, APPLICATION_JSON), 200);
        rspContent = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(rspContent));
        String urlOfNewRefDef = jsonRsp.getString("url");
        RmRestApiTest.assertNotNull((String)"urlOfNewRefDef was null.", (Object)urlOfNewRefDef);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(refDefnUrl), 200);
        rspContent = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(rspContent));
        JSONObject dataObject = jsonRsp.getJSONObject("data");
        RmRestApiTest.assertNotNull((String)"JSON data object was null", (Object)dataObject);
        JSONArray customRefsObject = dataObject.getJSONArray("customReferences");
        RmRestApiTest.assertNotNull((String)"JSON customReferences object was null", (Object)customRefsObject);
        RmRestApiTest.assertEquals((String)"Wrong customReferences length.", (int)1, (int)customRefsObject.length());
        JSONObject newRefObject = customRefsObject.getJSONObject(0);
        RmRestApiTest.assertEquals((String)"Wrong property label.", (String)"Updated label \u00fc\u00f8\u00e9\u00ee\u00e7\u00e5", (String)newRefObject.getString("label"));
        String updatedPcSource = "Updated source \u2206\u03a9\u00e7\u221a\u222b";
        String updatedPcTarget = "Updated target \u2206\u03a9\u00e7\u221a\u222b";
        jsonString = new JSONStringer().object().key("source").value((Object)"Updated source \u2206\u03a9\u00e7\u221a\u222b").key("target").value((Object)"Updated target \u2206\u03a9\u00e7\u221a\u222b").endObject().toString();
        refDefnUrl = "/api/rma/admin/customreferencedefinitions/" + pcRefId;
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(refDefnUrl, jsonString, APPLICATION_JSON), 200);
        rspContent = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(rspContent));
        urlOfNewRefDef = jsonRsp.getString("url");
        RmRestApiTest.assertNotNull((String)"urlOfNewRefDef was null.", (Object)urlOfNewRefDef);
        refDefnUrl = "/api/rma/admin/customreferencedefinitions/" + pcRefId;
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(refDefnUrl), 200);
        rspContent = rsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(rspContent));
        dataObject = jsonRsp.getJSONObject("data");
        RmRestApiTest.assertNotNull((String)"JSON data object was null", (Object)dataObject);
        customRefsObject = dataObject.getJSONArray("customReferences");
        RmRestApiTest.assertNotNull((String)"JSON customReferences object was null", (Object)customRefsObject);
        RmRestApiTest.assertEquals((String)"Wrong customReferences length.", (int)1, (int)customRefsObject.length());
        newRefObject = customRefsObject.getJSONObject(0);
        RmRestApiTest.assertEquals((String)"Wrong reference source.", (String)"Updated source \u2206\u03a9\u00e7\u221a\u222b", (String)newRefObject.getString("source"));
        RmRestApiTest.assertEquals((String)"Wrong reference target.", (String)"Updated target \u2206\u03a9\u00e7\u221a\u222b", (String)newRefObject.getString("target"));
    }

    public void testGetCustomProperties() throws Exception {
        this.getCustomProperties();
    }

    private String getCustomProperties() throws Exception, IOException, UnsupportedEncodingException, JSONException {
        this.testPostCustomPropertyDefinition();
        int expectedStatus = 200;
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/rma/admin/custompropertydefinitions?element=record"), 200);
        String contentAsString = rsp.getContentAsString();
        JSONObject jsonRsp = new JSONObject(new JSONTokener(contentAsString));
        JSONObject dataObj = (JSONObject)jsonRsp.get("data");
        RmRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        JSONObject customPropsObj = (JSONObject)dataObj.get("customProperties");
        RmRestApiTest.assertNotNull((String)"JSON 'customProperties' object was null", (Object)customPropsObj);
        int customPropsCount = customPropsObj.length();
        RmRestApiTest.assertTrue((String)("There should be at least one custom property. Found " + customPropsObj), (customPropsCount > 0 ? 1 : 0) != 0);
        return contentAsString;
    }

    public void testGetRecordMetaDataAspects() throws Exception {
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/rma/recordmetadataaspects"), 200);
        String contentAsString = rsp.getContentAsString();
        System.out.println(contentAsString);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(contentAsString));
        JSONObject dataObj = (JSONObject)jsonRsp.get("data");
        RmRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        JSONArray aspects = dataObj.getJSONArray("recordMetaDataAspects");
        RmRestApiTest.assertNotNull((Object)aspects);
        RmRestApiTest.assertEquals((int)4, (int)aspects.length());
    }

    public void testExport() throws Exception {
        String exportUrl = "/api/rma/admin/export";
        JSONObject jsonPostData = new JSONObject();
        JSONArray nodeRefs = new JSONArray();
        nodeRefs.put((Object)this.recordFolder.toString());
        nodeRefs.put((Object)this.recordFolder2.toString());
        jsonPostData.put("nodeRefs", (Object)nodeRefs);
        String jsonPostString = jsonPostData.toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(exportUrl, jsonPostString, APPLICATION_JSON), 200);
        RmRestApiTest.assertEquals((String)"application/acp", (String)rsp.getContentType());
    }

    public void testExportInTransferFormat() throws Exception {
        String exportUrl = "/api/rma/admin/export";
        JSONObject jsonPostData = new JSONObject();
        JSONArray nodeRefs = new JSONArray();
        nodeRefs.put((Object)this.recordFolder.toString());
        nodeRefs.put((Object)this.recordFolder2.toString());
        jsonPostData.put("nodeRefs", (Object)nodeRefs);
        jsonPostData.put("transferFormat", true);
        String jsonPostString = jsonPostData.toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(exportUrl, jsonPostString, APPLICATION_JSON), 200);
        RmRestApiTest.assertEquals((String)"application/zip", (String)rsp.getContentType());
    }

    public void testAudit() throws Exception {
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(GET_LIST_URL), 200);
        RmRestApiTest.assertEquals((String)"application/json;charset=UTF-8", (String)rsp.getContentType());
        JSONObject jsonParsedObject = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        RmRestApiTest.assertNotNull((Object)jsonParsedObject);
        JSONObject data = jsonParsedObject.getJSONObject("data");
        JSONObject events = data.getJSONObject("auditEvents");
        JSONArray items = events.getJSONArray("items");
        RmRestApiTest.assertEquals((int)this.auditService.getAuditEvents().size(), (int)items.length());
        RmRestApiTest.assertTrue((items.length() > 0 ? 1 : 0) != 0);
        JSONObject item = items.getJSONObject(0);
        RmRestApiTest.assertTrue((item.length() == 2 ? 1 : 0) != 0);
        RmRestApiTest.assertTrue((boolean)item.has("label"));
        RmRestApiTest.assertTrue((boolean)item.has("value"));
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(RMA_AUDITLOG_URL), 200);
        RmRestApiTest.assertEquals((String)APPLICATION_JSON, (String)rsp.getContentType());
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/rma/admin/rmauditlog?format=html"), 200);
        RmRestApiTest.assertEquals((String)"text/html", (String)rsp.getContentType());
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/rma/admin/rmauditlog?export=true"), 200);
        RmRestApiTest.assertEquals((String)APPLICATION_JSON, (String)rsp.getContentType());
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        String nodeUrl = this.recordCategory.toString().replace("://", "/");
        String auditUrl = MessageFormat.format(GET_NODE_AUDITLOG_URL_FORMAT, nodeUrl);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(auditUrl), 200);
        RmRestApiTest.assertEquals((String)APPLICATION_JSON, (String)rsp.getContentType());
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        String filteredAuditUrl = auditUrl + "?user=gavinc&size=5&from=2009-01-01&to=2009-12-31&event=Login";
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(filteredAuditUrl), 200);
        RmRestApiTest.assertEquals((String)APPLICATION_JSON, (String)rsp.getContentType());
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        filteredAuditUrl = auditUrl + "?user=fred&size=abc&from=2009&to=2010&property=wrong";
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(filteredAuditUrl), 200);
        RmRestApiTest.assertEquals((String)APPLICATION_JSON, (String)rsp.getContentType());
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        this.checkAuditStatus(true);
        JSONObject jsonPostData = new JSONObject();
        jsonPostData.put("enabled", true);
        String jsonPostString = jsonPostData.toString();
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(RMA_AUDITLOG_URL, jsonPostString, APPLICATION_JSON), 200);
        this.checkAuditStatus(true);
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        JSONObject dataObj = (JSONObject)jsonRsp.get("data");
        RmRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        RmRestApiTest.assertTrue((boolean)dataObj.getBoolean("enabled"));
        RmRestApiTest.assertTrue((boolean)dataObj.has("started"));
        RmRestApiTest.assertTrue((boolean)dataObj.has("stopped"));
        jsonPostData = new JSONObject();
        jsonPostData.put("enabled", false);
        jsonPostString = jsonPostData.toString();
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(RMA_AUDITLOG_URL, jsonPostString, APPLICATION_JSON), 200);
        this.checkAuditStatus(false);
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        dataObj = (JSONObject)jsonRsp.get("data");
        RmRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        RmRestApiTest.assertFalse((boolean)dataObj.getBoolean("enabled"));
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(RMA_AUDITLOG_URL), 200);
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        dataObj = (JSONObject)jsonRsp.get("data");
        RmRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        RmRestApiTest.assertFalse((boolean)dataObj.getBoolean("enabled"));
    }

    private void checkAuditStatus(boolean expected) throws Exception {
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(RMA_AUDITLOG_STATUS_URL), 200);
        JSONObject rspObj = new JSONObject(rsp.getContentAsString());
        JSONObject data = rspObj.getJSONObject("data");
        boolean enabled = data.getBoolean("enabled");
        RmRestApiTest.assertEquals((String)"Audit log status does not match expected status.", (boolean)expected, (boolean)enabled);
    }

    public void testFileAuditLogAsRecord() throws Exception {
        JSONObject jsonPostData = new JSONObject();
        jsonPostData.put("destination", (Object)"workspace://SpacesStore/09ca1e02-1c87-4a53-97e7-xxxxxxxxxxxx");
        String jsonPostString = jsonPostData.toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(RMA_AUDITLOG_URL, jsonPostString, APPLICATION_JSON), 404);
        jsonPostData = new JSONObject();
        jsonPostData.put("destination", (Object)this.recordCategory.toString());
        jsonPostString = jsonPostData.toString();
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(RMA_AUDITLOG_URL, jsonPostString, APPLICATION_JSON), 400);
        jsonPostData = new JSONObject();
        jsonPostData.put("destination", (Object)this.recordFolder2);
        jsonPostString = jsonPostData.toString();
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(RMA_AUDITLOG_URL, jsonPostString, APPLICATION_JSON), 200);
        System.out.println(rsp.getContentAsString());
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        RmRestApiTest.assertTrue((boolean)jsonRsp.has("success"));
        RmRestApiTest.assertTrue((boolean)jsonRsp.getBoolean("success"));
        RmRestApiTest.assertTrue((boolean)jsonRsp.has("record"));
        RmRestApiTest.assertNotNull((Object)jsonRsp.get("record"));
        RmRestApiTest.assertTrue((boolean)this.nodeService.exists(new NodeRef(jsonRsp.getString("record"))));
        RmRestApiTest.assertTrue((boolean)jsonRsp.has("recordName"));
        RmRestApiTest.assertNotNull((Object)jsonRsp.get("recordName"));
        RmRestApiTest.assertTrue((boolean)jsonRsp.getString("recordName").startsWith("audit_"));
        jsonPostData = new JSONObject();
        jsonPostData.put("destination", (Object)this.recordFolder2);
        jsonPostData.put("size", (Object)"50");
        jsonPostData.put("user", (Object)"gavinc");
        jsonPostData.put("event", (Object)"Update Metadata");
        jsonPostData.put("property", (Object)"{http://www.alfresco.org/model/content/1.0}modified");
        jsonPostString = jsonPostData.toString();
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(RMA_AUDITLOG_URL, jsonPostString, APPLICATION_JSON), 200);
        System.out.println(rsp.getContentAsString());
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        RmRestApiTest.assertTrue((boolean)jsonRsp.has("success"));
        RmRestApiTest.assertTrue((boolean)jsonRsp.getBoolean("success"));
        RmRestApiTest.assertTrue((boolean)jsonRsp.has("record"));
        RmRestApiTest.assertNotNull((Object)jsonRsp.get("record"));
        RmRestApiTest.assertTrue((boolean)this.nodeService.exists(new NodeRef(jsonRsp.getString("record"))));
        RmRestApiTest.assertTrue((boolean)jsonRsp.has("recordName"));
        RmRestApiTest.assertNotNull((Object)jsonRsp.get("recordName"));
        RmRestApiTest.assertTrue((boolean)jsonRsp.getString("recordName").startsWith("audit_"));
    }

    public void testPropertyLabelWithAccentedChars() throws Exception {
        long number = System.currentTimeMillis();
        String simplePropId = "simpleId" + number;
        this.postCustomPropertyDefinition("simple", simplePropId);
        String originalAccentedLabel = "\u00f8o\u00ea\u2248\u00e7\u0153";
        String accentedPropId = "accentedId" + number;
        this.postCustomPropertyDefinition("\u00f8o\u00ea\u2248\u00e7\u0153", accentedPropId);
        this.putCustomPropDefinition("one", simplePropId);
        this.putCustomPropDefinition("two", simplePropId);
        this.putCustomPropDefinition("three", simplePropId);
        this.putCustomPropDefinition("four", simplePropId);
        this.putCustomPropDefinition("five", simplePropId);
        String rspContent = this.getCustomProperties();
        JSONObject rspObject = new JSONObject(new JSONTokener(rspContent));
        JSONObject dataObj = rspObject.getJSONObject("data");
        RmRestApiTest.assertNotNull((String)"jsonObject was null", (Object)dataObj);
        JSONObject customPropertiesObj = dataObj.getJSONObject("customProperties");
        RmRestApiTest.assertNotNull((String)"customPropertiesObj was null", (Object)customPropertiesObj);
        JSONObject accentedPropertyObj = customPropertiesObj.getJSONObject("rmc:" + accentedPropId);
        RmRestApiTest.assertNotNull((String)"accentedPropertyObj was null", (Object)accentedPropertyObj);
        String labelObj = accentedPropertyObj.getString("label");
        RmRestApiTest.assertEquals((String)"labelObj was changed.", (String)"\u00f8o\u00ea\u2248\u00e7\u0153", (String)labelObj);
    }

    private void putCustomPropDefinition(String label, String id) throws JSONException, IOException, UnsupportedEncodingException {
        String jsonString = new JSONStringer().object().key("label").value((Object)label).endObject().toString();
        String propDefnUrl = "/api/rma/admin/custompropertydefinitions/" + id;
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(propDefnUrl, jsonString, APPLICATION_JSON), 200);
        String rspContent = rsp.getContentAsString();
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rspContent));
        String urlOfNewPropDef = jsonRsp.getString("url");
        RmRestApiTest.assertNotNull((String)"urlOfNewPropDef was null.", (Object)urlOfNewPropDef);
    }
}

