/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.version;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.relationship.Relationship;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionModel;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionPolicy;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public abstract class RecordableVersionsBaseTest
extends BaseRMTestCase
implements RecordableVersionModel {
    protected static final QName QNAME_PUBLISHER = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"publisher");
    protected static final QName QNAME_SUBJECT = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"subject");
    protected static final String DESCRIPTION = "description";
    protected static final String PUBLISHER = "publisher";
    protected static final String SUBJECT = "subject";
    protected static final String OWNER = "GracieWetherall";
    protected static final String CONTENT = "Simple + Smart.  A smarter way to build, a smarter way to deploy.  Its simple because we focus on the end user and smart because we support more open standards than any other ECM platform, while delivering all the value a traditional platform provides.";
    protected RecordableVersionService recordableVersionService;

    @Override
    protected void initServices() {
        super.initServices();
        this.recordableVersionService = (RecordableVersionService)this.applicationContext.getBean("RecordableVersionService");
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected void setupCollaborationSiteTestDataImpl() {
        super.setupCollaborationSiteTestDataImpl();
        this.createPerson(OWNER);
        this.prepareContent(this.dmDocument);
    }

    protected void prepareContent(NodeRef content) {
        PropertyMap titledProperties = new PropertyMap(2);
        titledProperties.put((Object)ContentModel.PROP_TITLE, (Object)"document title");
        titledProperties.put((Object)ContentModel.PROP_DESCRIPTION, (Object)"document description");
        this.nodeService.addAspect(content, ContentModel.ASPECT_TITLED, (Map)titledProperties);
        PropertyMap ownableProperties = new PropertyMap(1);
        ownableProperties.put((Object)ContentModel.PROP_OWNER, (Object)OWNER);
        this.nodeService.addAspect(content, ContentModel.ASPECT_OWNABLE, (Map)ownableProperties);
        PropertyMap dublinCoreProperties = new PropertyMap(2);
        dublinCoreProperties.put((Object)QNAME_PUBLISHER, (Object)PUBLISHER);
        dublinCoreProperties.put((Object)QNAME_SUBJECT, (Object)SUBJECT);
        this.nodeService.addAspect(content, ContentModel.ASPECT_DUBLINCORE, (Map)dublinCoreProperties);
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/plain");
        writer.putContent(CONTENT);
    }

    @Override
    protected void tearDownImpl() {
        super.tearDownImpl();
        this.personService.deletePerson(OWNER);
    }

    protected void checkRecordedVersion(NodeRef document, String description, String versionLabel) {
        RecordableVersionsBaseTest.assertFalse((boolean)this.recordService.isRecord(document));
        Map beforeProperties = this.nodeService.getProperties(document);
        Set beforeAspects = this.nodeService.getAspects(document);
        Version version = this.versionService.getCurrentVersion(document);
        RecordableVersionsBaseTest.assertNotNull((Object)version);
        RecordableVersionsBaseTest.assertEquals((String)description, (String)version.getDescription());
        RecordableVersionsBaseTest.assertEquals((String)versionLabel, (String)version.getVersionLabel());
        NodeRef frozen = version.getFrozenStateNodeRef();
        this.checkProperties(frozen, beforeProperties);
        this.checkAspects(frozen, beforeAspects);
        NodeRef record = this.recordableVersionService.getVersionRecord(version);
        RecordableVersionsBaseTest.assertNotNull((Object)record);
        RecordableVersionsBaseTest.assertTrue((boolean)this.nodeService.hasAspect(record, ASPECT_VERSION_RECORD));
        RecordableVersionsBaseTest.assertEquals((Object)versionLabel, (Object)this.nodeService.getProperty(record, RecordableVersionModel.PROP_VERSION_LABEL));
        RecordableVersionsBaseTest.assertEquals((Object)description, (Object)this.nodeService.getProperty(record, RecordableVersionModel.PROP_VERSION_DESCRIPTION));
        RecordableVersionsBaseTest.assertTrue((boolean)this.recordService.isRecord(record));
        RecordableVersionsBaseTest.assertFalse((boolean)this.recordService.isFiled(record));
        RecordableVersionsBaseTest.assertFalse((boolean)this.nodeService.hasAspect(record, RecordableVersionModel.ASPECT_VERSIONABLE));
        VersionHistory versionHistory = this.versionService.getVersionHistory(document);
        RecordableVersionsBaseTest.assertNotNull((Object)versionHistory);
        Version headVersion = versionHistory.getHeadVersion();
        RecordableVersionsBaseTest.assertNotNull((Object)headVersion);
    }

    protected void checkNotRecordedAspect(NodeRef document, String description, String versionLabel) {
        RecordableVersionsBaseTest.assertFalse((boolean)this.recordService.isRecord(document));
        Version version = this.versionService.getCurrentVersion(document);
        RecordableVersionsBaseTest.assertNotNull((Object)version);
        RecordableVersionsBaseTest.assertEquals((String)description, (String)version.getDescription());
        RecordableVersionsBaseTest.assertEquals((String)versionLabel, (String)version.getVersionLabel());
        NodeRef record = this.recordableVersionService.getVersionRecord(version);
        RecordableVersionsBaseTest.assertNull((Object)record);
        VersionHistory versionHistory = this.versionService.getVersionHistory(document);
        RecordableVersionsBaseTest.assertNotNull((Object)versionHistory);
        Version headVersion = versionHistory.getHeadVersion();
        RecordableVersionsBaseTest.assertNotNull((Object)headVersion);
    }

    protected void checkProperties(NodeRef frozen, Map<QName, Serializable> beforeProperies) {
        Map frozenProperties = this.nodeService.getProperties(frozen);
        HashMap cloneFrozenProperties = new HashMap(frozenProperties);
        for (Map.Entry<QName, Serializable> entry : beforeProperies.entrySet()) {
            QName beforePropertyName = entry.getKey();
            if (frozenProperties.containsKey(beforePropertyName)) {
                Serializable frozenValue = (Serializable)frozenProperties.get(beforePropertyName);
                if (beforePropertyName.equals((Object)ContentModel.PROP_CONTENT)) {
                    RecordableVersionsBaseTest.assertTrue((String)"Content property value should be different.", (entry.getValue() != frozenValue ? 1 : 0) != 0);
                } else {
                    RecordableVersionsBaseTest.assertEquals((String)("Frozen property " + beforePropertyName.getLocalName() + " value is incorrect."), (Object)entry.getValue(), (Object)frozenValue);
                }
                cloneFrozenProperties.remove(beforePropertyName);
                continue;
            }
            if (PROP_FILE_PLAN.equals((Object)beforePropertyName) || PROP_RECORDABLE_VERSION_POLICY.equals((Object)beforePropertyName) || ContentModel.PROP_AUTO_VERSION_PROPS.equals((Object)beforePropertyName) || ContentModel.PROP_AUTO_VERSION.equals((Object)beforePropertyName) || ContentModel.PROP_INITIAL_VERSION.equals((Object)beforePropertyName) || ContentModel.PROP_VERSION_TYPE.equals((Object)beforePropertyName) || ContentModel.PROP_VERSION_LABEL.equals((Object)beforePropertyName)) continue;
            RecordableVersionsBaseTest.fail((String)("Property missing from frozen state .. " + beforePropertyName));
        }
        for (Map.Entry<Object, Serializable> entry : frozenProperties.entrySet()) {
            if (entry.getValue() != null) continue;
            cloneFrozenProperties.remove(entry.getKey());
        }
        cloneFrozenProperties.remove(ContentModel.PROP_OWNER);
        RecordableVersionsBaseTest.assertTrue((String)("Properties in frozen state, but not in origional. " + cloneFrozenProperties.keySet()), (boolean)cloneFrozenProperties.isEmpty());
    }

    protected void checkAspects(NodeRef frozen, Set<QName> beforeAspects) {
        HashSet<QName> cloneBeforeAspects = new HashSet<QName>(beforeAspects);
        Set frozenAspects = this.nodeService.getAspects(frozen);
        cloneBeforeAspects.removeAll(frozenAspects);
        cloneBeforeAspects.remove(RecordableVersionModel.ASPECT_VERSIONABLE);
        cloneBeforeAspects.remove(ContentModel.ASPECT_VERSIONABLE);
        if (!cloneBeforeAspects.isEmpty()) {
            RecordableVersionsBaseTest.fail((String)("Aspects not present in frozen state. " + ((Object)cloneBeforeAspects).toString()));
        }
        frozenAspects.removeAll(beforeAspects);
        if (!frozenAspects.isEmpty()) {
            RecordableVersionsBaseTest.fail((String)("Aspects in the frozen state, but not in origional.  " + frozenAspects.toString()));
        }
    }

    protected NodeRef createDocumentWithRecordVersions() {
        final NodeRef myDocument = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                NodeRef testDoc = RecordableVersionsBaseTest.this.fileFolderService.create(RecordableVersionsBaseTest.this.dmFolder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                ContentWriter writer = RecordableVersionsBaseTest.this.fileFolderService.getWriter(testDoc);
                writer.setEncoding("UTF-8");
                writer.setMimetype("text/plain");
                writer.putContent(GUID.generate());
                HashMap<QName, Object> props = new HashMap<QName, Object>(2);
                props.put(RecordableVersionModel.PROP_RECORDABLE_VERSION_POLICY, RecordableVersionPolicy.ALL);
                props.put(RecordableVersionModel.PROP_FILE_PLAN, RecordableVersionsBaseTest.this.filePlan);
                RecordableVersionsBaseTest.this.nodeService.addAspect(testDoc, RecordableVersionModel.ASPECT_VERSIONABLE, props);
                RecordableVersionsBaseTest.this.nodeService.addAspect(testDoc, ContentModel.ASPECT_VERSIONABLE, null);
                return testDoc;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                ContentWriter writer = RecordableVersionsBaseTest.this.fileFolderService.getWriter(myDocument);
                writer.putContent(GUID.generate());
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                ContentWriter writer = RecordableVersionsBaseTest.this.fileFolderService.getWriter(myDocument);
                writer.putContent(GUID.generate());
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                VersionHistory versionHistory = RecordableVersionsBaseTest.this.versionService.getVersionHistory(myDocument);
                TestCase.assertNotNull((Object)versionHistory);
                Collection versions = versionHistory.getAllVersions();
                TestCase.assertEquals((int)3, (int)versions.size());
                Version version12 = versionHistory.getHeadVersion();
                TestCase.assertEquals((String)"1.2", (String)version12.getVersionLabel());
                NodeRef recordVersion12 = RecordableVersionsBaseTest.this.recordableVersionService.getVersionRecord(version12);
                TestCase.assertNotNull((Object)recordVersion12);
                TestCase.assertTrue((boolean)RecordableVersionsBaseTest.this.relationshipService.getRelationshipsTo(recordVersion12, "versions").isEmpty());
                Set from12 = RecordableVersionsBaseTest.this.relationshipService.getRelationshipsFrom(recordVersion12, "versions");
                TestCase.assertEquals((int)1, (int)from12.size());
                Version version11 = versionHistory.getPredecessor(version12);
                TestCase.assertEquals((String)"1.1", (String)version11.getVersionLabel());
                NodeRef recordVersion11 = RecordableVersionsBaseTest.this.recordableVersionService.getVersionRecord(version11);
                TestCase.assertNotNull((Object)recordVersion11);
                Set to11 = RecordableVersionsBaseTest.this.relationshipService.getRelationshipsTo(recordVersion11, "versions");
                TestCase.assertEquals((int)1, (int)to11.size());
                TestCase.assertEquals((Object)recordVersion12, (Object)((Relationship)to11.iterator().next()).getSource());
                Set from11 = RecordableVersionsBaseTest.this.relationshipService.getRelationshipsFrom(recordVersion11, "versions");
                TestCase.assertEquals((int)1, (int)from11.size());
                Version version10 = versionHistory.getPredecessor(version11);
                TestCase.assertEquals((String)"1.0", (String)version10.getVersionLabel());
                NodeRef recordVersion10 = RecordableVersionsBaseTest.this.recordableVersionService.getVersionRecord(version10);
                TestCase.assertNotNull((Object)recordVersion10);
                Set to10 = RecordableVersionsBaseTest.this.relationshipService.getRelationshipsTo(recordVersion10, "versions");
                TestCase.assertEquals((int)1, (int)to10.size());
                TestCase.assertEquals((Object)recordVersion11, (Object)((Relationship)to10.iterator().next()).getSource());
                TestCase.assertTrue((boolean)RecordableVersionsBaseTest.this.relationshipService.getRelationshipsFrom(recordVersion10, "versions").isEmpty());
                return null;
            }
        });
        return myDocument;
    }
}

