/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.disposition;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;

public class UpdateNextDispositionActionTest
extends BaseRMTestCase {
    public void testUpdateNextDispositionAction_RM3060() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef record;
            NodeRef folder2;

            @Override
            public void given() {
                NodeRef category1 = UpdateNextDispositionActionTest.this.filePlanService.createRecordCategory(UpdateNextDispositionActionTest.this.filePlan, GUID.generate());
                UpdateNextDispositionActionTest.this.createDispositionSchedule(category1);
                NodeRef category2 = UpdateNextDispositionActionTest.this.filePlanService.createRecordCategory(UpdateNextDispositionActionTest.this.filePlan, GUID.generate());
                UpdateNextDispositionActionTest.this.createDispositionSchedule(category2);
                this.folder2 = UpdateNextDispositionActionTest.this.recordFolderService.createRecordFolder(category2, GUID.generate());
                NodeRef folder1 = UpdateNextDispositionActionTest.this.recordFolderService.createRecordFolder(category1, GUID.generate());
                this.record = UpdateNextDispositionActionTest.this.utils.createRecord(folder1, GUID.generate(), GUID.generate());
            }

            @Override
            public void when() throws Exception {
                UpdateNextDispositionActionTest.this.recordService.link(this.record, this.folder2);
                UpdateNextDispositionActionTest.this.utils.completeRecord(this.record);
                UpdateNextDispositionActionTest.this.rmActionService.executeRecordsManagementAction(this.record, "cutoff", null);
            }

            @Override
            public void then() throws Exception {
                TestCase.assertTrue((String)("Record " + this.record + " doesn't have the cutOff aspect."), (boolean)UpdateNextDispositionActionTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_CUT_OFF));
            }
        });
    }

    private void createDispositionSchedule(NodeRef category) {
        DispositionSchedule ds = this.utils.createDispositionSchedule(category, "disposition instructions", "disposition action description", true, false, false);
        HashMap<QName, String> cutOff = new HashMap<QName, String>(3);
        cutOff.put(PROP_DISPOSITION_ACTION_NAME, "cutoff");
        cutOff.put(PROP_DISPOSITION_DESCRIPTION, GUID.generate());
        cutOff.put(PROP_DISPOSITION_PERIOD, "immediately|0");
        this.dispositionService.addDispositionActionDefinition(ds, cutOff);
        HashMap<QName, Object> transfer = new HashMap<QName, Object>(3);
        transfer.put(PROP_DISPOSITION_ACTION_NAME, "transfer");
        transfer.put(PROP_DISPOSITION_DESCRIPTION, GUID.generate());
        transfer.put(PROP_DISPOSITION_EVENT, (Serializable)((Object)Collections.singletonList("case_closed")));
        this.dispositionService.addDispositionActionDefinition(ds, transfer);
        HashMap<QName, String> destroy = new HashMap<QName, String>(3);
        destroy.put(PROP_DISPOSITION_ACTION_NAME, "destroy");
        destroy.put(PROP_DISPOSITION_DESCRIPTION, GUID.generate());
        destroy.put(PROP_DISPOSITION_PERIOD, "week|1");
        this.dispositionService.addDispositionActionDefinition(ds, destroy);
    }
}

