/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v35;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.v35.RMv35HoldNewChildAssocPatch;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class RMv35HoldNewChildAssocPatchUnitTest {
    @Mock
    private FilePlanService mockFilePlanService;
    @Mock
    private HoldService mockHoldService;
    @Mock
    private NodeService mockNodeService;
    @Mock
    private BehaviourFilter mockBehaviourFilter;
    @InjectMocks
    private RMv35HoldNewChildAssocPatch patch;
    private NodeRef filePlanRef;
    private NodeRef holdRef;
    private NodeRef heldItemRef;
    private Set<NodeRef> fileplans;
    private List<NodeRef> holds;
    @Mock
    private ChildAssociationRef childAssociationRef;
    private List<ChildAssociationRef> childAssocs;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.filePlanRef = new NodeRef("workspace://SpacesStore/filePlan");
        this.holdRef = new NodeRef("workspace://SpacesStore/hold");
        this.heldItemRef = new NodeRef("workspace://SpacesStore/heldItem");
        this.fileplans = new HashSet<NodeRef>();
        this.fileplans.add(this.filePlanRef);
        this.holds = new ArrayList<NodeRef>();
        this.holds.add(this.holdRef);
        this.childAssocs = new ArrayList<ChildAssociationRef>();
        this.childAssocs.add(this.childAssociationRef);
    }

    @Test
    public void testAddChildDuringUpgrade() {
        Mockito.when((Object)this.mockFilePlanService.getFilePlans()).thenReturn(this.fileplans);
        Mockito.when((Object)this.mockHoldService.getHolds(this.filePlanRef)).thenReturn(this.holds);
        Mockito.when((Object)this.mockNodeService.getChildAssocs(this.holdRef, (QNamePattern)RecordsManagementModel.ASSOC_FROZEN_CONTENT, RegexQNamePattern.MATCH_ALL)).thenReturn(this.childAssocs);
        Mockito.when((Object)this.childAssociationRef.getChildRef()).thenReturn((Object)this.heldItemRef);
        this.patch.applyInternal();
        ((NodeService)Mockito.verify((Object)this.mockNodeService, (VerificationMode)Mockito.times((int)1))).addChild(this.holdRef, this.heldItemRef, ContentModel.ASSOC_CONTAINS, RMv35HoldNewChildAssocPatch.PATCH_ASSOC_NAME);
    }

    @Test
    public void patchRunWithSuccessWhenNoHeldChildren() {
        Mockito.when((Object)this.mockFilePlanService.getFilePlans()).thenReturn(this.fileplans);
        Mockito.when((Object)this.mockHoldService.getHolds(this.filePlanRef)).thenReturn(this.holds);
        Mockito.when((Object)this.mockNodeService.getChildAssocs(this.holdRef, (QNamePattern)RecordsManagementModel.ASSOC_FROZEN_CONTENT, RegexQNamePattern.MATCH_ALL)).thenReturn(Collections.emptyList());
        this.patch.applyInternal();
        ((NodeService)Mockito.verify((Object)this.mockNodeService, (VerificationMode)Mockito.never())).addChild((NodeRef)ArgumentMatchers.any(NodeRef.class), (NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.any(QName.class));
    }

    @Test
    public void patchRunWithSuccessWhenNoHolds() {
        List holdList = Collections.emptyList();
        Mockito.when((Object)this.mockFilePlanService.getFilePlans()).thenReturn(this.fileplans);
        Mockito.when((Object)this.mockHoldService.getHolds(this.filePlanRef)).thenReturn(holdList);
        this.patch.applyInternal();
        ((NodeService)Mockito.verify((Object)this.mockNodeService, (VerificationMode)Mockito.never())).addChild((NodeRef)ArgumentMatchers.any(NodeRef.class), (NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.any(QName.class));
    }

    @Test
    public void patchRunWithSuccessWhenNoFilePlan() {
        ((FilePlanService)Mockito.doReturn((Object)Collections.EMPTY_SET).when((Object)this.mockFilePlanService)).getFilePlans();
        this.patch.applyInternal();
        ((NodeService)Mockito.verify((Object)this.mockNodeService, (VerificationMode)Mockito.never())).addChild((NodeRef)ArgumentMatchers.any(NodeRef.class), (NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.any(QName.class));
    }
}

